/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.decorator.htmlreport;

import com.mathworks.comparisons.decorator.ComparisonMenuMergeTag;
import com.mathworks.comparisons.decorator.ComparisonReportDecorator;
import com.mathworks.comparisons.decorator.PopupMenuProvider;
import com.mathworks.comparisons.decorator.htmlreport.ComparisonHTMLRenderer;
import com.mathworks.comparisons.decorator.htmlreport.HTMLActionManager;
import com.mathworks.comparisons.event.ComparisonEventListener;
import com.mathworks.comparisons.util.DebugUtils;
import com.mathworks.comparisons.util.ResourceManager;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuBar;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.widgets.desk.DTMenuBoundary;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

public class HTMLReportDecorator
implements ComparisonReportDecorator {
    private Action mSaveAsAction = null;
    private Action mRefreshAction = null;
    private Action mSwapSidesAction = null;
    private Action mFindAction = null;
    private Action mPrintAction = null;
    private Action mCopyAction = null;
    private boolean mAllowSaveAs;
    private final ComparisonEventListener mEventListener;
    protected ComparisonHTMLRenderer mHTMLRenderer = null;

    public HTMLReportDecorator(ComparisonEventListener comparisonEventListener, boolean bl) {
        this.mEventListener = comparisonEventListener;
        this.mAllowSaveAs = bl;
    }

    public HTMLReportDecorator(ComparisonEventListener comparisonEventListener) {
        this(comparisonEventListener, true);
    }

    @Override
    public Component createCentralComponent() {
        assert (SwingUtilities.isEventDispatchThread()) : "Call on AWTEventDispatchThread";
        this.mHTMLRenderer = new ComparisonHTMLRenderer();
        this.initializeActions();
        this.mHTMLRenderer.setPopupMenuProvider(this.createPopupMenuProvider());
        return this.mHTMLRenderer;
    }

    @Override
    public MJToolBar decorate(MJToolBar mJToolBar) {
        assert (SwingUtilities.isEventDispatchThread()) : "Call on AWTEventDispatchThread";
        assert (this.mHTMLRenderer != null) : "HTMLRenderer should have been created";
        if (this.mAllowSaveAs) {
            mJToolBar.add(this.mSaveAsAction);
            mJToolBar.addSeparator();
        }
        if (this.mRefreshAction != null && this.mSwapSidesAction != null) {
            mJToolBar.add(this.mRefreshAction);
            mJToolBar.add(this.mSwapSidesAction);
            mJToolBar.addSeparator();
        }
        mJToolBar.add(this.mFindAction);
        mJToolBar.add(this.mPrintAction);
        return mJToolBar;
    }

    @Override
    public MJMenuBar decorate(MJMenuBar mJMenuBar) {
        assert (SwingUtilities.isEventDispatchThread()) : "Call on AWTEventDispatchThread";
        assert (this.mHTMLRenderer != null) : "HTMLRenderer should have been created";
        MJMenu mJMenu = new MJMenu();
        DTMenuMergeTag.FILE.setTag((JMenuItem)mJMenu);
        mJMenu.add((JMenuItem)new DTMenuBoundary(DTMenuMergeTag.CLOSE));
        if (this.mAllowSaveAs) {
            DTMenuMergeTag.SAVE.setTag(this.mSaveAsAction);
        }
        DTMenuMergeTag.PRINT.setTag(this.mPrintAction);
        mJMenu.addSeparator();
        if (this.mAllowSaveAs) {
            mJMenu.add(this.mSaveAsAction);
        }
        mJMenu.add(this.mPrintAction);
        mJMenuBar.add((JMenu)mJMenu);
        MJMenu mJMenu2 = new MJMenu();
        DTMenuMergeTag.EDIT.setTag((JMenuItem)mJMenu2);
        DTMenuMergeTag.FIND.setTag(this.mFindAction);
        DTMenuMergeTag.COPY.setTag(this.mCopyAction);
        mJMenu2.add(this.mCopyAction);
        mJMenu2.add(this.mFindAction);
        mJMenuBar.add((JMenu)mJMenu2);
        if (this.mRefreshAction != null && this.mSwapSidesAction != null) {
            MJMenu mJMenu3 = new MJMenu(ResourceManager.getString("comparisonreport.comparisonmenu"));
            ComparisonMenuMergeTag.COMPARISON.setTag((JMenuItem)mJMenu3);
            ComparisonMenuMergeTag.COMPARISON.setTag(this.mRefreshAction);
            ComparisonMenuMergeTag.COMPARISON.setTag(this.mSwapSidesAction);
            mJMenu3.add(this.mRefreshAction);
            mJMenu3.add(this.mSwapSidesAction);
            mJMenuBar.add((JMenu)mJMenu3);
        }
        return mJMenuBar;
    }

    @Override
    public void disableControls() {
        this.setEnabled(false);
        this.mHTMLRenderer.setWaitCursor(true);
    }

    @Override
    public void enableControls() {
        this.setEnabled(true);
        this.mHTMLRenderer.setWaitCursor(false);
    }

    public ComparisonHTMLRenderer getHTMLRenderer() {
        return this.mHTMLRenderer;
    }

    public void reportError(String string) {
        ComparisonHTMLRenderer comparisonHTMLRenderer = this.getHTMLRenderer();
        if (comparisonHTMLRenderer != null) {
            comparisonHTMLRenderer.setHtmlText(string);
        }
        if (this.mRefreshAction != null) {
            this.mRefreshAction.setEnabled(true);
        }
    }

    @Override
    public void dispose() {
        assert (SwingUtilities.isEventDispatchThread()) : "Call on AWTEventDispatchThread";
        if (this.mHTMLRenderer != null) {
            this.mHTMLRenderer.dispose();
            this.mHTMLRenderer = null;
        }
    }

    protected void initializeActions() {
        if (this.mAllowSaveAs) {
            this.mSaveAsAction = HTMLActionManager.getSaveAs(this.mHTMLRenderer);
        }
        if (this.mEventListener != null) {
            this.mRefreshAction = HTMLActionManager.getRefresh(this.mEventListener);
            this.mSwapSidesAction = HTMLActionManager.getSwapSides(this.mEventListener);
        }
        this.mFindAction = HTMLActionManager.getFind(this.mHTMLRenderer);
        this.mPrintAction = HTMLActionManager.getPrint(this.mHTMLRenderer);
        this.mCopyAction = HTMLActionManager.getCopy(this.mHTMLRenderer);
    }

    protected PopupMenuProvider createPopupMenuProvider() {
        return new DefaultPopupMenuProvider();
    }

    private void setEnabled(boolean bl) {
        if (this.mAllowSaveAs) {
            this.mSaveAsAction.setEnabled(bl);
        }
        if (this.mRefreshAction != null) {
            this.mRefreshAction.setEnabled(bl);
        }
        if (this.mSwapSidesAction != null) {
            this.mSwapSidesAction.setEnabled(bl);
        }
        this.mFindAction.setEnabled(bl);
        this.mPrintAction.setEnabled(bl);
        this.mCopyAction.setEnabled(bl);
    }

    protected class DefaultPopupMenuProvider
    implements PopupMenuProvider {
        @Override
        public MJPopupMenu createPopupMenu() {
            MJPopupMenu mJPopupMenu = new MJPopupMenu();
            if (HTMLReportDecorator.this.mAllowSaveAs) {
                mJPopupMenu.add(HTMLReportDecorator.this.mSaveAsAction);
                mJPopupMenu.addSeparator();
            }
            if (HTMLReportDecorator.this.mRefreshAction != null && HTMLReportDecorator.this.mSwapSidesAction != null) {
                mJPopupMenu.add(HTMLReportDecorator.this.mRefreshAction);
                mJPopupMenu.add(HTMLReportDecorator.this.mSwapSidesAction);
                mJPopupMenu.addSeparator();
            }
            mJPopupMenu.add(HTMLReportDecorator.this.mCopyAction);
            mJPopupMenu.add(HTMLReportDecorator.this.mPrintAction);
            if (DebugUtils.hasDebugSetting(DebugUtils.DebugSetting.ALLOW_VIEW_SOURCE)) {
                mJPopupMenu.addSeparator();
                mJPopupMenu.add(HTMLActionManager.getViewSource(HTMLReportDecorator.this.mHTMLRenderer));
            }
            mJPopupMenu.setLightWeightPopupEnabled(false);
            return mJPopupMenu;
        }
    }
}

