/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.compare.impl;

import com.mathworks.comparisons.compare.impl.CompareInMatlab;
import com.mathworks.comparisons.decorator.ComparisonReportDecorator;
import com.mathworks.comparisons.decorator.htmlreport.ComparisonHTMLRenderer;
import com.mathworks.comparisons.decorator.htmlreport.HTMLReportDecorator;
import com.mathworks.comparisons.event.ComparisonEvent;
import com.mathworks.comparisons.event.data.CEventDataErrorOccurred;
import com.mathworks.comparisons.result.ComparisonResult;
import com.mathworks.comparisons.result.impl.ComparisonResultString;
import com.mathworks.comparisons.util.HTMLUtils;
import com.mathworks.comparisons.util.LocalIOUtils;
import com.mathworks.comparisons.util.ResourceManager;
import java.io.File;
import java.nio.charset.Charset;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringEscapeUtils;

public abstract class CompareInMatlabGenerateHTML
extends CompareInMatlab<String> {
    private static String COMPARISON_REPORT_PREFIX = "matlab_comparison_report_";
    private static String COMPARISON_REPORT_SUFFIX = ".html";
    private HTMLReportDecorator mHTMLReportDecorator = null;
    private File mTempFile = null;

    protected CompareInMatlabGenerateHTML(String string, int n) {
        this(string, string, n, n);
    }

    protected CompareInMatlabGenerateHTML(String string, String string2, int n, int n2) {
        super(string, string2, n, n2);
    }

    @Override
    public ComparisonReportDecorator getDecorator() {
        if (this.mHTMLReportDecorator == null) {
            this.mHTMLReportDecorator = this.createDefaultDecorator();
        }
        return this.mHTMLReportDecorator;
    }

    @Override
    public void overrideDefaultDecorator(ComparisonReportDecorator comparisonReportDecorator) {
        assert (comparisonReportDecorator instanceof HTMLReportDecorator) : "Decorator should be HTMLReportDecorator implementation";
        if (this.mHTMLReportDecorator != null) {
            this.dispose();
        }
        this.mHTMLReportDecorator = (HTMLReportDecorator)comparisonReportDecorator;
    }

    @Override
    public void dispose() {
        if (this.mHTMLReportDecorator != null) {
            this.mHTMLReportDecorator.dispose();
            this.mHTMLReportDecorator = null;
        }
        this.deleteExistingTempFile();
    }

    @Override
    protected ComparisonResult<String> convertToComparisonResult(Object object) {
        assert (object instanceof String);
        ComparisonResultString comparisonResultString = new ComparisonResultString();
        comparisonResultString.addResultData((String)object);
        return comparisonResultString;
    }

    @Override
    protected void displayComparisonResult(Object object) throws Exception {
        assert (object instanceof String);
        if (this.mHTMLReportDecorator == null) {
            return;
        }
        String string = (String)object;
        ComparisonHTMLRenderer comparisonHTMLRenderer = this.mHTMLReportDecorator.getHTMLRenderer();
        if (comparisonHTMLRenderer == null) {
            return;
        }
        this.deleteExistingTempFile();
        if (string.length() == 0) {
            comparisonHTMLRenderer.setHtmlText("");
        } else {
            this.mTempFile = LocalIOUtils.createTempFile(COMPARISON_REPORT_PREFIX, COMPARISON_REPORT_SUFFIX);
            LocalIOUtils.writeStringToFile(string, this.mTempFile, Charset.forName("UTF-8"));
            comparisonHTMLRenderer.setCurrentLocation(this.mTempFile.toURI().toString());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (CompareInMatlabGenerateHTML.this.mHTMLReportDecorator != null) {
                        CompareInMatlabGenerateHTML.this.mHTMLReportDecorator.enableControls();
                    }
                }
            });
        }
    }

    @Override
    protected void handle(Exception exception, boolean bl) {
        if (this.mHTMLReportDecorator != null) {
            int n;
            String string = exception.getMessage();
            if (bl && (n = string.indexOf("at com.mathworks.")) > 0) {
                string = string.substring(0, n);
            }
            string = StringEscapeUtils.escapeHtml((String)string);
            string = string.replace("\n", "<br/>");
            final String string2 = HTMLUtils.wrapInHTML(ResourceManager.getString("exception.comparisonfailed"), string);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CompareInMatlabGenerateHTML.this.mHTMLReportDecorator.reportError(string2);
                    CompareInMatlabGenerateHTML.this.getEventSupport().fireComparisonEvent(new ComparisonEvent(this, CEventDataErrorOccurred.getInstance()));
                }
            });
        } else {
            exception.printStackTrace();
        }
    }

    protected abstract HTMLReportDecorator createDefaultDecorator();

    private void deleteExistingTempFile() {
        if (this.mTempFile != null) {
            this.mTempFile.delete();
            this.mTempFile = null;
        }
    }
}

