/*
 * Decompiled with CFR 0.152.
 */
package foxtrot;

import foxtrot.Task;
import foxtrot.WorkerThread;
import java.io.InterruptedIOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public abstract class AbstractWorkerThread
implements WorkerThread {
    protected AbstractWorkerThread() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTask(final Task task) {
        try {
            Object obj = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return task.run();
                }
            }, task.getSecurityContext());
            task.setResult(obj);
        }
        catch (PrivilegedActionException x) {
            Exception xx = x.getException();
            task.setThrowable(xx);
            if (xx instanceof InterruptedException || xx instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
        }
        catch (Throwable x) {
            task.setThrowable(x);
        }
        finally {
            task.setCompleted(true);
            task.postRun();
        }
    }
}

