/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services.lmgr;

import com.mathworks.instutil.DecodeInputStream;
import com.mathworks.instutil.PlatformImpl;
import com.mathworks.services.lmgr.ExitMatlabRunnable;
import com.mathworks.services.lmgr.ProcessStarter;
import com.mathworks.services.lmgr.ProcessStarterAdapter;
import com.mathworks.services.lmgr.SessionHelperManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;

public final class SessionHelperManagerImpl
implements SessionHelperManager {
    private static final long SLEEP_TIME_IN_MS = 1000L;
    private static final long TIME_TO_WATCH_PROCESS_IN_MS = 180000L;
    private static SessionHelperManagerImpl sInstance = null;
    private final ProcessStarter processStarter;
    private Runnable sessionStopperRunnable = null;
    private final Runnable exitMatlabRunnable;
    private final long timeToWatchProcessInMS;
    private final ExecutorService executorService;

    private SessionHelperManagerImpl(ProcessStarter processStarter, Runnable runnable, ExecutorService executorService, long l) {
        this.processStarter = processStarter;
        this.exitMatlabRunnable = runnable;
        this.executorService = executorService;
        this.timeToWatchProcessInMS = l;
    }

    public static synchronized SessionHelperManagerImpl getInstance() {
        if (sInstance == null) {
            sInstance = new SessionHelperManagerImpl(new ProcessStarterAdapter(), new ExitMatlabRunnable(), Executors.newSingleThreadExecutor(), 180000L);
        }
        return sInstance;
    }

    public static SessionHelperManagerImpl createTestInstance(ProcessStarter processStarter, Runnable runnable, ExecutorService executorService, long l) {
        return new SessionHelperManagerImpl(processStarter, runnable, executorService, l);
    }

    @Override
    public void startSessionHelperMonitorThread(String string, String string2, String string3, String string4, Runnable runnable) throws IOException {
        if (this.sessionStopperRunnable != null) {
            throw new IllegalStateException("scheduleSessionHelperThread can only be called once.");
        }
        this.sessionStopperRunnable = runnable;
        Process process = this.processStarter.startProcess(SessionHelperManagerImpl.getSessionHelperProgram(string), "-r", string, "-m", SessionHelperManagerImpl.encodeArgument(string2), "-s", SessionHelperManagerImpl.encodeArgument(string3), "-t", SessionHelperManagerImpl.encodeArgument(string4));
        this.executorService.submit(new SessionHelperMonitorThread(process));
        this.executorService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String encodeArgument(String string) throws IOException {
        String string2;
        DecodeInputStream decodeInputStream = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            decodeInputStream = new DecodeInputStream((InputStream)byteArrayInputStream);
            string2 = new String(Base64.encodeBase64((byte[])IOUtils.toByteArray((InputStream)decodeInputStream)));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(decodeInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)decodeInputStream);
        return string2;
    }

    private static String getSessionHelperProgram(String string) {
        return new File(new PlatformImpl().getNativeLibraryPath(string), "session_helper").getAbsolutePath();
    }

    private class SessionHelperMonitorThread
    implements Runnable {
        private final Process process;

        SessionHelperMonitorThread(Process process) {
            this.process = process;
        }

        @Override
        public void run() {
            Date date = new Date(System.currentTimeMillis() + SessionHelperManagerImpl.this.timeToWatchProcessInMS);
            boolean bl = true;
            while (new Date().before(date) && bl) {
                try {
                    this.process.exitValue();
                    bl = false;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
            }
            if (!bl) {
                SessionHelperManagerImpl.this.sessionStopperRunnable.run();
                SessionHelperManagerImpl.this.exitMatlabRunnable.run();
            }
        }
    }
}

