/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.dastudio.truthtable;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTable;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.toolbox.dastudio.truthtable.PredicateTableModel;
import com.mathworks.toolbox.dastudio.truthtable.PredicateTablePopupMenu;
import com.mathworks.toolbox.dastudio.truthtable.TruthTableEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;

class PredicateTableEditor
implements ActionListener {
    private int _selectedRow = -1;
    private int _selectedCol = -1;
    private JPanel editorPanel;
    private MJTable predTbl;
    private PredicateTableModel predTblMdl;
    private PredicateTablePopupMenu popupMenu;
    private MJButton btnAddRow;
    private MJButton btnAddCol;
    private MJButton btnDel;
    private MJButton btnCompact;
    private MJButton btnLeft;
    private MJButton btnRight;
    private MJButton btnUp;
    private MJButton btnDown;

    public PredicateTableEditor() {
        this.predTblMdl = new PredicateTableModel();
        this.initializeEditor();
    }

    public PredicateTableEditor(int n, int n2) {
        this.predTblMdl = new PredicateTableModel(n, n2);
        this.initializeEditor();
    }

    public PredicateTableEditor(String[][] stringArray) {
        this.predTblMdl = new PredicateTableModel(stringArray);
        this.initializeEditor();
    }

    private void initializeEditor() {
        this.editorPanel = new JPanel(new BorderLayout());
        MJToolBar mJToolBar = new MJToolBar();
        mJToolBar.setFloatable(false);
        String string = TruthTableEditor.getMatlabRoot() + "toolbox/shared/dastudio/resources/";
        Insets insets = new Insets(3, 3, 3, 3);
        this.btnAddRow = new MJButton((Icon)new ImageIcon(string + "TTE_addrow.gif"));
        this.btnAddRow.setMargin(insets);
        this.btnAddRow.addActionListener((ActionListener)this);
        this.btnAddRow.setToolTipText("Add a row.");
        this.btnAddCol = new MJButton((Icon)new ImageIcon(string + "TTE_addcolumn.gif"));
        this.btnAddCol.setMargin(insets);
        this.btnAddCol.addActionListener((ActionListener)this);
        this.btnAddCol.setToolTipText("Add a column.");
        this.btnDel = new MJButton((Icon)new ImageIcon(string + "TTE_delete.gif"));
        this.btnDel.setMargin(insets);
        this.btnDel.addActionListener((ActionListener)this);
        this.btnDel.setToolTipText("Delete selected row or column.");
        this.btnDel.setEnabled(false);
        this.btnCompact = new MJButton((Icon)new ImageIcon(string + "TTE_compact.gif"));
        this.btnCompact.setMargin(insets);
        this.btnCompact.addActionListener((ActionListener)this);
        this.btnCompact.setToolTipText("Make table compact.");
        this.btnLeft = new MJButton((Icon)new ImageIcon(string + "TTE_left.gif"));
        this.btnLeft.setMargin(insets);
        this.btnLeft.addActionListener((ActionListener)this);
        this.btnLeft.setToolTipText("Move selected column left.");
        this.btnLeft.setEnabled(false);
        this.btnRight = new MJButton((Icon)new ImageIcon(string + "TTE_right.gif"));
        this.btnRight.setMargin(insets);
        this.btnRight.addActionListener((ActionListener)this);
        this.btnRight.setToolTipText("Move selected column right.");
        this.btnRight.setEnabled(false);
        this.btnUp = new MJButton((Icon)new ImageIcon(string + "TTE_up.gif"));
        this.btnUp.setMargin(insets);
        this.btnUp.addActionListener((ActionListener)this);
        this.btnUp.setToolTipText("Move selected row up.");
        this.btnUp.setEnabled(false);
        this.btnDown = new MJButton((Icon)new ImageIcon(string + "TTE_down.gif"));
        this.btnDown.setMargin(insets);
        this.btnDown.addActionListener((ActionListener)this);
        this.btnDown.setToolTipText("Move selected row down.");
        this.btnDown.setEnabled(false);
        mJToolBar.add((Component)new JLabel(" Predicate Table: "));
        mJToolBar.addSeparator();
        mJToolBar.add((Component)this.btnAddRow);
        mJToolBar.add((Component)this.btnAddCol);
        mJToolBar.add((Component)this.btnDel);
        mJToolBar.addSeparator();
        mJToolBar.add((Component)this.btnLeft);
        mJToolBar.add((Component)this.btnRight);
        mJToolBar.add((Component)this.btnUp);
        mJToolBar.add((Component)this.btnDown);
        mJToolBar.addSeparator();
        mJToolBar.add((Component)this.btnCompact);
        this.editorPanel.add((Component)mJToolBar, "North");
        this.predTbl = new MJTable((TableModel)this.predTblMdl, this.predTblMdl.getColumnModel());
        this.predTbl.setAutoCreateColumnsFromModel(false);
        this.predTbl.setSelectionMode(0);
        this.predTbl.setAutoResizeMode(0);
        this.predTbl.setRowHeight(40);
        this.predTbl.setPreferredScrollableViewportSize(new Dimension(600, 200));
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.predTbl);
        this.editorPanel.add((Component)mJScrollPane, "Center");
        JTableHeader jTableHeader = this.predTbl.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                PredicateTableEditor.this.stopEditing();
                if (mouseEvent.getModifiers() == 16) {
                    PredicateTableEditor.this.clearSelection();
                    int n = PredicateTableEditor.this.predTbl.columnAtPoint(mouseEvent.getPoint());
                    if (n > 3) {
                        PredicateTableEditor.this.columnSelected(n);
                    }
                }
            }
        });
        this.editorPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                PredicateTableEditor.this.stopEditing();
            }
        });
        this.predTbl.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getModifiers() == 16) {
                    PredicateTableEditor.this.clearSelection();
                    int n = PredicateTableEditor.this.predTbl.rowAtPoint(mouseEvent.getPoint());
                    int n2 = PredicateTableEditor.this.predTbl.columnAtPoint(mouseEvent.getPoint());
                    if (n2 == 0 && n < PredicateTableEditor.this.predTbl.getRowCount() - 1) {
                        PredicateTableEditor.this.rowSelected(n);
                    } else {
                        PredicateTableEditor.this.predTbl.editCellAt(n, n2);
                    }
                }
            }
        });
        this.popupMenu = new PredicateTablePopupMenu(this);
    }

    public void stopEditing() {
        if (this.predTbl.isEditing()) {
            this.predTbl.getCellEditor().stopCellEditing();
        }
    }

    public void clearSelection() {
        this.predTbl.clearSelection();
        this.predTbl.setColumnSelectionAllowed(false);
        this.predTbl.setRowSelectionAllowed(false);
        this._selectedCol = -1;
        this._selectedRow = -1;
        this.btnDel.setEnabled(false);
        this.btnLeft.setEnabled(false);
        this.btnRight.setEnabled(false);
        this.btnUp.setEnabled(false);
        this.btnDown.setEnabled(false);
    }

    public void rowSelected(int n) {
        if (n < 0 || n >= this.predTblMdl.getRowCount() - 1) {
            return;
        }
        this.predTbl.setColumnSelectionAllowed(false);
        this.predTbl.setRowSelectionAllowed(true);
        this.predTbl.setRowSelectionInterval(n, n);
        this._selectedRow = n;
        this._selectedCol = -1;
        this.btnDel.setEnabled(true);
        this.btnLeft.setEnabled(false);
        this.btnRight.setEnabled(false);
        if (this._selectedRow > 0) {
            this.btnUp.setEnabled(true);
        } else {
            this.btnUp.setEnabled(false);
        }
        if (this._selectedRow < this.predTblMdl.getRowCount() - 2) {
            this.btnDown.setEnabled(true);
        } else {
            this.btnDown.setEnabled(false);
        }
    }

    public void columnSelected(int n) {
        if (n < 4 || n >= this.predTblMdl.getColumnCount()) {
            return;
        }
        this.predTbl.setRowSelectionAllowed(false);
        this.predTbl.setColumnSelectionAllowed(true);
        this.predTbl.setColumnSelectionInterval(n, n);
        this._selectedCol = this.predTbl.convertColumnIndexToModel(n);
        this._selectedRow = -1;
        this.btnDel.setEnabled(true);
        this.btnUp.setEnabled(false);
        this.btnDown.setEnabled(false);
        if (this._selectedCol > 4) {
            this.btnLeft.setEnabled(true);
        } else {
            this.btnLeft.setEnabled(false);
        }
        if (this._selectedCol < this.predTblMdl.getColumnCount() - 1) {
            this.btnRight.setEnabled(true);
        } else {
            this.btnRight.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.stopEditing();
        if (actionEvent.getSource() == this.btnAddCol) {
            if (this._selectedCol > 3) {
                this.predTblMdl.addColumn(this._selectedCol);
                this.columnSelected(this._selectedCol + 1);
            } else {
                this.predTblMdl.addColumn();
                this.rowSelected(this._selectedRow);
            }
        }
        if (actionEvent.getSource() == this.btnDel) {
            if (this._selectedCol >= 0) {
                this.predTblMdl.deleteColumn(this._selectedCol);
            }
            if (this._selectedRow >= 0) {
                this.predTblMdl.deleteRow(this._selectedRow);
            }
            this.clearSelection();
        }
        if (actionEvent.getSource() == this.btnAddRow) {
            if (this._selectedRow >= 0) {
                this.predTblMdl.addRow(this._selectedRow);
                this.rowSelected(this._selectedRow + 1);
            } else {
                this.predTblMdl.addRow();
                this.columnSelected(this._selectedCol);
            }
        }
        if (actionEvent.getSource() == this.btnLeft) {
            this.predTblMdl.switchColumn(this._selectedCol - 1, this._selectedCol);
            this.columnSelected(this._selectedCol - 1);
        }
        if (actionEvent.getSource() == this.btnRight) {
            this.predTblMdl.switchColumn(this._selectedCol, this._selectedCol + 1);
            this.columnSelected(this._selectedCol + 1);
        }
        if (actionEvent.getSource() == this.btnUp) {
            this.predTblMdl.switchRow(this._selectedRow - 1, this._selectedRow);
            this.rowSelected(this._selectedRow - 1);
        }
        if (actionEvent.getSource() == this.btnDown) {
            this.predTblMdl.switchRow(this._selectedRow, this._selectedRow + 1);
            this.rowSelected(this._selectedRow + 1);
        }
        if (actionEvent.getSource() == this.btnCompact) {
            this.predTblMdl.makeCompact();
            this.clearSelection();
        }
    }

    public String[][] getStringArray() {
        return this.predTblMdl.getStringArray();
    }

    public String getCellValue(int n, int n2) {
        return (String)this.predTblMdl.getValueAt(n, n2);
    }

    public JPanel getEditorPanel() {
        return this.editorPanel;
    }

    public MJTable getPredicateTable() {
        return this.predTbl;
    }

    public PredicateTableModel getPredicateTableModel() {
        return this.predTblMdl;
    }

    public int getSelectedRow() {
        return this._selectedRow;
    }

    public int getSelectedColumn() {
        return this._selectedCol;
    }
}

