/*
 * Decompiled with CFR 0.152.
 */
package net.jini.activation;

import java.rmi.RemoteException;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroupDesc;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.server.RMIClassLoader;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import net.jini.export.Exporter;
import net.jini.security.Security;

public abstract class ActivationGroup
extends java.rmi.activation.ActivationGroup {
    private static ActivationGroup currGroup;

    protected ActivationGroup(ActivationGroupID activationGroupID) throws RemoteException {
        super(activationGroupID);
    }

    public static synchronized java.rmi.activation.ActivationGroup createGroup(ActivationGroupID activationGroupID, ActivationGroupDesc activationGroupDesc, long l) throws ActivationException {
        String string = activationGroupDesc.getClassName();
        if (string == null || !ActivationGroup.isAssignableFrom(string, activationGroupDesc.getLocation())) {
            throw new ActivationException("group class not subclass");
        }
        currGroup = (ActivationGroup)java.rmi.activation.ActivationGroup.createGroup((ActivationGroupID)activationGroupID, (ActivationGroupDesc)activationGroupDesc, (long)l);
        return currGroup;
    }

    private static boolean isAssignableFrom(final String string, final String string2) throws ActivationException {
        try {
            Class clazz = (Class)Security.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return RMIClassLoader.loadClass(string2, string);
                }
            });
            return ActivationGroup.class.isAssignableFrom(clazz);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new ActivationException("unable to load group class", (Throwable)privilegedActionException.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean inactive(ActivationID activationID, Exporter exporter) throws ActivationException, RemoteException {
        ActivationGroup activationGroup;
        Class clazz = ActivationGroup.class;
        synchronized (clazz) {
            activationGroup = currGroup;
        }
        if (activationGroup == null) {
            throw new ActivationException("group is not active");
        }
        return activationGroup.inactiveObject(activationID, exporter);
    }

    public abstract boolean inactiveObject(ActivationID var1, Exporter var2) throws ActivationException, RemoteException;
}

