/*
 * Decompiled with CFR 0.152.
 */
package org.bluecove.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.UnknownServiceException;
import java.nio.channels.SocketChannel;
import org.bluecove.socket.Credentials;
import org.bluecove.socket.LocalSocketAddress;
import org.bluecove.socket.LocalSocketImpl;

public class LocalSocket
extends Socket {
    private LocalSocketImpl impl;
    private boolean shutdownIn = false;
    private boolean shutdownOut = false;

    public LocalSocket() throws IOException {
        super((SocketImpl)null);
        this.impl = new LocalSocketImpl();
        this.impl.create(true);
    }

    public LocalSocket(LocalSocketAddress address) throws IOException {
        this();
        this.connect(address);
    }

    LocalSocket(LocalSocketImpl impl) throws IOException {
        super((SocketImpl)null);
        this.impl = impl;
    }

    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is already closed");
        }
        if (this.isConnected()) {
            throw new SocketException("Socket is already connected");
        }
        this.impl.connect(endpoint, timeout);
    }

    public String toString() {
        if (this.isConnected()) {
            return "LocalSocket[" + this.getLocalSocketAddress() + "]";
        }
        return "LocalSocket[unconnected]";
    }

    public SocketAddress getRemoteSocketAddress() {
        if (!this.isConnected()) {
            return null;
        }
        return this.impl.getSocketAddress();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.impl.getSocketAddress();
    }

    public void bind(SocketAddress bindpoint) throws IOException {
        throw new UnknownServiceException();
    }

    public SocketChannel getChannel() {
        return null;
    }

    public InetAddress getInetAddress() {
        if (!this.isConnected()) {
            return null;
        }
        throw new IllegalArgumentException("Unsupported address type");
    }

    public InetAddress getLocalAddress() {
        if (!this.isConnected()) {
            return null;
        }
        throw new IllegalArgumentException("Unsupported address type");
    }

    public int getPort() {
        throw new IllegalArgumentException("Unsupported address type");
    }

    public int getLocalPort() {
        throw new IllegalArgumentException("Unsupported address type");
    }

    public void close() throws IOException {
        this.impl.close();
    }

    public boolean isConnected() {
        return this.impl.isConnected();
    }

    public boolean isBound() {
        return this.impl.isBound();
    }

    public Credentials getPeerCredentials() throws IOException {
        return this.impl.readPeerCredentials();
    }

    public static Credentials getProcessCredentials() {
        return LocalSocketImpl.readProcessCredentials();
    }

    public boolean isClosed() {
        return this.impl.isClosed();
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is already closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isOutputShutdown()) {
            throw new SocketException("Socket output is shutdown");
        }
        return this.impl.getOutputStream();
    }

    public InputStream getInputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is already closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isInputShutdown()) {
            throw new SocketException("Socket input is shutdown");
        }
        return this.impl.getInputStream();
    }

    public boolean isInputShutdown() {
        return this.shutdownIn;
    }

    public boolean isOutputShutdown() {
        return this.shutdownOut;
    }

    public void shutdownInput() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is already closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isInputShutdown()) {
            throw new SocketException("Socket input is already shutdown");
        }
        this.impl.shutdownInput();
        this.shutdownIn = true;
    }

    public void shutdownOutput() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is already closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isOutputShutdown()) {
            throw new SocketException("Socket output is already shutdown");
        }
        this.impl.shutdownOutput();
        this.shutdownOut = true;
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is already closed");
        }
        if (!on) {
            this.impl.setOption(1, (Object)on);
        } else {
            if (linger < 0) {
                throw new IllegalArgumentException("invalid value for SO_LINGER");
            }
            if (linger > 65535) {
                linger = 65535;
            }
            this.impl.setOption(1, (Object)linger);
        }
    }

    public int getSoLinger() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is already closed");
        }
        Object value = this.impl.getOption(1);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return -1;
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.impl.setOption(4, (Object)size);
    }

    public int getReceiveBufferSize() throws SocketException {
        return (Integer)this.impl.getOption(4);
    }

    public void setSendBufferSize(int n) throws SocketException {
        this.impl.setOption(3, (Object)n);
    }

    public int getSendBufferSize() throws SocketException {
        return (Integer)this.impl.getOption(3);
    }

    public void setSoTimeout(int n) throws SocketException {
        this.impl.setOption(5, (Object)n);
        this.impl.setOption(6, (Object)n);
    }

    public int getSoTimeout() throws SocketException {
        return (Integer)this.impl.getOption(6);
    }

    public void setSoReceiveTimeout(int n) throws SocketException {
        this.impl.setOption(5, (Object)n);
    }

    public int getSoReceiveTimeout() throws SocketException {
        return (Integer)this.impl.getOption(5);
    }

    public void setSoSendTimeout(int n) throws SocketException {
        this.impl.setOption(6, (Object)n);
    }

    public int getSoSendTimeout() throws SocketException {
        return (Integer)this.impl.getOption(6);
    }

    public void setReceiveCredentials(boolean on) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is already closed");
        }
        this.impl.setOption(2, (Object)(on ? 1 : 0));
    }

    public boolean getReceiveCredentials() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is already closed");
        }
        Object value = this.impl.getOption(2);
        if (value instanceof Integer) {
            return (Integer)value > 0;
        }
        return false;
    }
}

