/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.screener;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.screener.ScreenerScore;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.Timer;

public final class ScoreWidget {
    private final MJPanel fGraph;
    private final MJPanel fComponent;
    private final int fScore;
    private final boolean fProblematicFiles;
    private boolean fStarted;
    private int fCrunch;
    private double fMoveInterval;
    private Timer fTimer;
    private MJLabel fLabel;
    private static final int ORIGIN_X = -8;
    private static final Color GRID_COLOR = new Color(110, 110, 110);
    private static final Color LABEL_COLOR = new Color(35, 35, 35);
    private static final Color[] GRADIENT_INNER = new Color[]{null, new Color(0xB22222), new Color(16729344), new Color(16766720), new Color(8190976), new Color(65280)};
    private static final Color[] GRADIENT_OUTER = new Color[]{null, new Color(14423100), new Color(16747520), new Color(0xFFFF00), new Color(11403055), new Color(0x7FFF00)};

    public ScoreWidget(ScreenerScore screenerScore) {
        this.fScore = screenerScore.getScore();
        this.fProblematicFiles = screenerScore.getScore() < 4 && screenerScore.getLineScore() > 3 && screenerScore.getFileScore() > 0 && screenerScore.getFileScore() < 3;
        this.fGraph = new MJPanel(){

            public Dimension getPreferredSize() {
                return new Dimension(50, 24);
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            public void paintComponent(Graphics graphics) {
                ScoreWidget.this.paintBar((Graphics2D)graphics);
                ScoreWidget.this.paintGrid((Graphics2D)graphics);
                ScoreWidget.this.paintLabel((Graphics2D)graphics);
            }

            public void paint(Graphics graphics) {
                if (!ScoreWidget.this.fStarted && this.getWidth() > 10) {
                    this.start();
                }
                super.paint(graphics);
            }

            private void start() {
                ScoreWidget.this.fStarted = true;
                ScoreWidget.this.fMoveInterval = 3.0;
                int n = ScoreWidget.this.computeScoreInterval();
                ScoreWidget.this.fCrunch = n * ScoreWidget.this.fScore;
                ScoreWidget.this.fTimer = new Timer(25, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ScoreWidget.this.fCrunch = (int)((double)ScoreWidget.this.fCrunch - ScoreWidget.this.fMoveInterval);
                        ScoreWidget.this.fMoveInterval *= 1.2;
                        ScoreWidget.this.fCrunch = Math.max(0, ScoreWidget.this.fCrunch);
                        if (ScoreWidget.this.fCrunch == 0) {
                            ScoreWidget.this.fLabel.setForeground(new MJLabel().getForeground());
                            ScoreWidget.this.fTimer.stop();
                            ScoreWidget.this.fTimer = null;
                        }
                        this.revalidate();
                        this.repaint();
                    }
                });
                ScoreWidget.this.fTimer.start();
            }
        };
        this.fLabel = new MJLabel(CoderResources.getString("screener.score." + this.fScore + (this.fProblematicFiles ? ".files" : "")));
        this.fComponent = new MJPanel((LayoutManager)new FormLayout("fill:d:grow, fill:d", "fill:d, 3dlu, fill:d:grow"));
        if (!PlatformInfo.isMacintosh()) {
            this.fComponent.setOpaque(false);
            this.fGraph.setOpaque(false);
        }
        CellConstraints cellConstraints = new CellConstraints();
        this.fComponent.add((Component)this.fGraph, (Object)cellConstraints.xyw(1, 1, 2));
        this.fComponent.add((Component)this.fLabel, (Object)cellConstraints.xy(1, 3));
        this.fLabel.setForeground(this.fComponent.getBackground());
    }

    public static Color getScoreColor(int n) {
        return GRADIENT_INNER[n];
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    private int computeScoreInterval() {
        return (this.fGraph.getWidth() - 8) / 5;
    }

    private void paintBar(Graphics2D graphics2D) {
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D2.setColor(this.fComponent.getBackground());
        graphics2D2.fillRect(0, 0, this.fGraph.getWidth(), this.fGraph.getHeight());
        int n = this.computeScoreInterval();
        graphics2D2.setColor(Color.WHITE);
        graphics2D2.fill(new RoundRectangle2D.Double(-8.0, 1.0, n * 5 + 16, this.fGraph.getHeight() - 2, 16.0, 16.0));
        graphics2D2.setPaint(new GradientPaint(0.0f, 0.0f, GRADIENT_OUTER[this.fScore], 0.0f, this.fGraph.getHeight() / 2, GRADIENT_INNER[this.fScore], true));
        graphics2D2.fill(new RoundRectangle2D.Double(-8.0, 1.0, n * this.fScore + 16 - this.fCrunch, this.fGraph.getHeight() - 2, 16.0, 16.0));
        graphics2D2.dispose();
    }

    private void paintGrid(Graphics2D graphics2D) {
        BufferedImage bufferedImage = new BufferedImage(this.fGraph.getWidth(), this.fGraph.getHeight(), 2);
        Graphics2D graphics2D2 = bufferedImage.createGraphics();
        graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n = this.computeScoreInterval();
        for (int i = 4; i >= 0; --i) {
            int n2 = -8 + n * i;
            int n3 = n + 15;
            int n4 = this.fGraph.getHeight() - 1;
            graphics2D2.setColor(GRID_COLOR);
            graphics2D2.draw(new RoundRectangle2D.Double(n2, 0.0, n3, n4, 16.0, 16.0));
            graphics2D2.setBackground(new Color(255, 255, 255, 0));
            graphics2D2.clearRect(n2 + 1, 1, n3 - 15, n4 - 1);
        }
        graphics2D2.setColor(GRID_COLOR);
        graphics2D2.drawLine(0, 0, 0, this.fGraph.getHeight());
        graphics2D2.dispose();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
    }

    private void paintLabel(Graphics2D graphics2D) {
        if (this.fCrunch < 5) {
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            int n = this.computeScoreInterval();
            graphics2D2.setFont(new Font("Arial", 1, 12));
            FontMetrics fontMetrics = graphics2D2.getFontMetrics();
            int n2 = (int)Math.max((double)fontMetrics.getAscent() * 1.7, (double)fontMetrics.getWidths()[51] * 1.7);
            graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D2.setColor(Color.WHITE);
            graphics2D2.fill(new RoundRectangle2D.Double((int)(-8.0 + (double)n * ((double)this.fScore - 0.5) + 12.0 - (double)(n2 / 2)), this.fGraph.getHeight() / 2 - n2 / 2, n2, n2, n2, n2));
            for (int i = 0; i < 3; ++i) {
                graphics2D2.setColor(new Color(0, 0, 0, 135 - i * 55));
                graphics2D2.draw(new RoundRectangle2D.Double((int)(-8.0 + (double)n * ((double)this.fScore - 0.5) + 12.0 - (double)(n2 / 2)), this.fGraph.getHeight() / 2 - n2 / 2, n2, n2, n2, n2));
                n2 -= 2;
            }
            graphics2D2.setColor(LABEL_COLOR);
            graphics2D2.drawString(Integer.toString(this.fScore), (float)(-8.0 + (double)n * ((double)this.fScore - 0.5)) - (float)(fontMetrics.getWidths()[51] / 2) + 12.0f, (float)(this.fGraph.getHeight() / 2 + fontMetrics.getAscent() / 2));
            graphics2D2.dispose();
        }
    }
}

