/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin.workflow;

import com.mathworks.project.api.XmlApi;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.api.XmlWriter;
import com.mathworks.project.impl.model.Configuration;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public final class ProposedTypesModel {
    private final Map<String, FunctionData> fProposedTypesMap;
    private final Map<String, FunctionData> fAnnotationsMap;
    private final Object fLock;
    private ColumnNode fHead;
    private LinkedList<ColumnNode> fDerivedColumns = new LinkedList();
    private LinkedList<ColumnNode> fAcceptedRangeColumns = new LinkedList();
    private LinkedList<ColumnNode> fProposedTypeColumn = new LinkedList();
    private Collection<ColumnNode> fEditableColumns = new LinkedList<ColumnNode>();
    private ColumnNode[] fColumnNodes = null;
    private Configuration fConfiguration;

    private ColumnNode getNodeAt(int n) {
        int n2 = 0;
        for (ColumnNode columnNode = this.fHead; columnNode != null; columnNode = columnNode.getNext()) {
            if (n != n2++) continue;
            return columnNode;
        }
        return null;
    }

    public int getFieldCount() {
        return this.fColumnNodes.length;
    }

    public String getVariableFieldName(int n) {
        ColumnNode columnNode = this.fColumnNodes[n];
        if (columnNode != null) {
            return columnNode.getColumnName();
        }
        return null;
    }

    public String getColumnName(int n) {
        ColumnNode columnNode = this.getNodeAt(n);
        if (columnNode != null) {
            return columnNode.getColumnName();
        }
        return null;
    }

    public void setFieldTableColumn(int n, TableColumn tableColumn) {
        ColumnNode columnNode = this.fColumnNodes[n];
        if (columnNode != null) {
            columnNode.setColumn(tableColumn);
            String string = columnNode.getColumnName();
            if (string.contains("Derived")) {
                this.fDerivedColumns.add(columnNode);
            } else if (string.contains("Accepted")) {
                this.fAcceptedRangeColumns.add(columnNode);
            } else if (string.equals("ProposedType")) {
                this.fProposedTypeColumn.add(columnNode);
            } else if (!string.contains("Sim")) {
                this.fEditableColumns.add(columnNode);
            }
        }
    }

    private void addColumns(LinkedList<ColumnNode> linkedList) {
        ColumnNode columnNode = linkedList.getFirst();
        if (!columnNode.isVisible()) {
            ColumnNode columnNode2 = columnNode.getOriginalPrev();
            while (!columnNode2.isVisible()) {
                columnNode2 = columnNode2.getOriginalPrev();
            }
            ColumnNode columnNode3 = columnNode2.getNext();
            columnNode2.setNext(columnNode);
            columnNode.setPrev(columnNode2);
            linkedList.getLast().setNext(columnNode3);
            if (columnNode3 != null) {
                columnNode3.setPrev(linkedList.getLast());
            }
            for (ColumnNode columnNode4 : linkedList) {
                columnNode4.setVisible(true);
            }
        }
    }

    private void removeColumns(LinkedList<ColumnNode> linkedList) {
        ColumnNode columnNode = linkedList.getFirst();
        if (columnNode.isVisible()) {
            ColumnNode columnNode2 = columnNode.getPrev();
            columnNode2.setNext(linkedList.getLast().getNext());
            if (columnNode2.getNext() != null) {
                columnNode2.getNext().setPrev(columnNode2);
            }
            for (ColumnNode columnNode3 : linkedList) {
                columnNode3.setVisible(false);
            }
        }
    }

    public void processColumnVisibility(TableColumnModel tableColumnModel) {
        if (this.fColumnNodes == null) {
            return;
        }
        boolean bl = this.fConfiguration.getParamAsBoolean("param.fixptconv.useStaticAnalysis");
        if (bl) {
            this.addColumns(this.fDerivedColumns);
        } else {
            this.removeColumns(this.fDerivedColumns);
        }
        String string = this.fConfiguration.getParamAsString("param.fixptconv.OutputDisplayType");
        this.removeColumns(this.fProposedTypeColumn);
        this.removeColumns(this.fAcceptedRangeColumns);
        if (string.equals("option.fixptconv.OutputDisplayType.FixedPointNotation")) {
            this.addColumns(this.fProposedTypeColumn);
        } else if (string.equals("option.fixptconv.OutputDisplayType.Range")) {
            this.addColumns(this.fAcceptedRangeColumns);
        } else {
            this.addColumns(this.fAcceptedRangeColumns);
            this.addColumns(this.fProposedTypeColumn);
        }
        while (tableColumnModel.getColumnCount() > 0) {
            tableColumnModel.removeColumn(tableColumnModel.getColumn(0));
        }
        for (ColumnNode columnNode = this.fHead; columnNode != null; columnNode = columnNode.getNext()) {
            tableColumnModel.addColumn(columnNode.getColumn());
        }
    }

    public boolean isEditable(int n) {
        ColumnNode columnNode = this.fColumnNodes[n];
        if (this.fEditableColumns.contains(columnNode)) {
            return true;
        }
        return this.fProposedTypeColumn.contains(columnNode) && !this.fConfiguration.getParamAsBoolean("param.fixptconv.useStaticAnalysis.featureControl");
    }

    public void resetColumnVisibility() {
        this.fDerivedColumns.clear();
        this.fAcceptedRangeColumns.clear();
        this.fProposedTypeColumn.clear();
        this.fEditableColumns.clear();
    }

    public ProposedTypesModel(Configuration configuration) {
        this.fProposedTypesMap = new LinkedHashMap<String, FunctionData>();
        this.fAnnotationsMap = new LinkedHashMap<String, FunctionData>();
        this.fLock = new Object();
        this.fConfiguration = configuration;
        this.fHead = null;
    }

    public ProposedTypesModel(Configuration configuration, Object[] objectArray) {
        this(configuration);
        ColumnNode columnNode;
        this.fColumnNodes = new ColumnNode[objectArray.length];
        this.fColumnNodes[0] = columnNode = (this.fHead = new ColumnNode(objectArray[0].toString(), null));
        for (int i = 1; i < objectArray.length; ++i) {
            this.fColumnNodes[i] = columnNode = new ColumnNode(objectArray[i].toString(), columnNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProposedTypeData(String string, String string2, String string3, Object object) {
        Object object2 = this.fLock;
        synchronized (object2) {
            this.getFunction(this.fProposedTypesMap, string).set(string2, string3, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnnotationData(String string, String string2) {
        Object object = this.fLock;
        synchronized (object) {
            FunctionData functionData = this.getFunction(this.fAnnotationsMap, string);
            functionData.remove(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnnotationData(String string, String string2, String ... stringArray) {
        Object object = this.fLock;
        synchronized (object) {
            for (String string3 : stringArray) {
                this.getFunction(this.fAnnotationsMap, string).remove(string2, string3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAnnotationData(String string, String string2, String string3) {
        Object object = this.fLock;
        synchronized (object) {
            FunctionData functionData = this.getFunction(this.fAnnotationsMap, string);
            return functionData.get(string2, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasProposedData(String string, String string2) {
        Object object = this.fLock;
        synchronized (object) {
            FunctionData functionData = this.getFunction(this.fProposedTypesMap, string);
            return functionData.getVariables().containsKey(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getProposedData(String string, String string2) {
        Object object = this.fLock;
        synchronized (object) {
            FunctionData functionData = this.getFunction(this.fProposedTypesMap, string);
            return (Map)functionData.getVariables().get(string2).clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProposedData(String string, String string2, String string3) {
        Object object = this.fLock;
        synchronized (object) {
            FunctionData functionData = this.getFunction(this.fProposedTypesMap, string);
            return functionData.get(string2, string3);
        }
    }

    public Object getValue(String string, String string2, String string3) {
        if (this.hasAnnotationData(string, string2, string3)) {
            return this.getAnnotationData(string, string2, string3);
        }
        if (this.hasProposedData(string, string2)) {
            return this.getProposedData(string, string2, string3);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAnnotationData() {
        Object object = this.fLock;
        synchronized (object) {
            this.fAnnotationsMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAnnotationData(String string, String string2, String string3, Object object) {
        Object object2 = this.fLock;
        synchronized (object2) {
            FunctionData functionData = this.getFunction(this.fProposedTypesMap, string);
            Object object3 = functionData.get(string2, string3);
            if (object3 == object || object3 != null && object3.equals(object)) {
                this.removeAnnotationData(string, string2, string3);
                return;
            }
            if (string3.equals("ProposedType")) {
                this.removeAnnotationData(string, string2, "DesignMin", "DesignMax", "IsInteger");
            } else if (string3.equals("DesignMin") || string3.equals("DesignMax") || string3.equals("IsInteger")) {
                this.removeAnnotationData(string, string2, "ProposedType");
            }
            this.getFunction(this.fAnnotationsMap, string).set(string2, string3, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FunctionData getFunction(Map<String, FunctionData> map, String string) {
        Object object = this.fLock;
        synchronized (object) {
            FunctionData functionData = map.get(string);
            if (functionData == null) {
                functionData = new FunctionData();
                map.put(string, functionData);
            }
            return functionData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAnnotationData(String string) {
        Object object = this.fLock;
        synchronized (object) {
            return this.fAnnotationsMap.containsKey(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAnnotationData(String string, String string2, String string3) {
        Object object = this.fLock;
        synchronized (object) {
            FunctionData functionData = this.fAnnotationsMap.get(string);
            return functionData != null && functionData.hasField(string2, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getFunctionNames() {
        Object object = this.fLock;
        synchronized (object) {
            return new ArrayList<String>(this.fProposedTypesMap.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getVariableNames(String string) {
        Object object = this.fLock;
        synchronized (object) {
            ArrayList<String> arrayList = new ArrayList<String>();
            FunctionData functionData = this.fProposedTypesMap.get(string);
            if (functionData != null) {
                arrayList.addAll(functionData.getVariables().keySet());
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVariableName(String string, int n) {
        Object object = this.fLock;
        synchronized (object) {
            return this.getVariableNames(string).get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFunctionCount() {
        Object object = this.fLock;
        synchronized (object) {
            return this.fProposedTypesMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasFunction(String string) {
        Object object = this.fLock;
        synchronized (object) {
            return this.fProposedTypesMap.containsKey(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getFieldType(String string, String string2) {
        Object object = this.fLock;
        synchronized (object) {
            Object object2 = this.fProposedTypesMap.get(string).get(this.getVariableName(string, 0), string2);
            if ("".equals(object2)) {
                return Double.class;
            }
            return object2.getClass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProposedTypes(ProposedTypesModel proposedTypesModel) {
        Object object = this.fLock;
        synchronized (object) {
            this.fProposedTypesMap.clear();
            this.fProposedTypesMap.putAll(proposedTypesModel.fProposedTypesMap);
            this.fColumnNodes = proposedTypesModel.fColumnNodes;
            this.fHead = proposedTypesModel.fHead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deserializeAnnotations(XmlReader xmlReader) {
        Object object = this.fLock;
        synchronized (object) {
            this.fAnnotationsMap.clear();
            XmlReader xmlReader2 = xmlReader.getChild(new String[]{"Function"});
            while (xmlReader2.isPresent()) {
                String string = xmlReader2.readAttribute("name");
                XmlReader xmlReader3 = xmlReader2.getChild(new String[]{"Variable"});
                while (xmlReader3.isPresent()) {
                    String string2 = xmlReader3.readAttribute("name");
                    XmlReader xmlReader4 = xmlReader3.getChild(new String[]{"Column"});
                    while (xmlReader4.isPresent()) {
                        String string3 = xmlReader4.readAttribute("property");
                        String string4 = xmlReader4.readAttribute("index");
                        if (string3 == null && string4 != null) {
                            int n = Integer.parseInt(string4);
                            switch (n) {
                                case 1: {
                                    string3 = "DesignMin";
                                    break;
                                }
                                case 2: {
                                    string3 = "DesignMax";
                                    break;
                                }
                                case 3: {
                                    string3 = "IsInteger";
                                    break;
                                }
                                case 4: {
                                    string3 = "ProposedType";
                                    break;
                                }
                                case 5: {
                                    string3 = "RoundMode";
                                    break;
                                }
                                case 6: {
                                    string3 = "OverflowMode";
                                }
                            }
                        }
                        String string5 = xmlReader4.readAttribute("type");
                        String string6 = xmlReader4.readAttribute("value");
                        try {
                            Constructor<?> constructor = Class.forName("java.lang." + string5).getConstructor(String.class);
                            Object obj = constructor.newInstance(string6);
                            this.setAnnotationData(string, string2, string3, obj);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        xmlReader4 = xmlReader4.next();
                    }
                    xmlReader3 = xmlReader3.next();
                }
                xmlReader2 = xmlReader2.next();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlReader serializeAnnotations() {
        Object object = this.fLock;
        synchronized (object) {
            try {
                XmlWriter xmlWriter = XmlApi.getInstance().create("ProposedTypesTableAnnotations");
                for (Map.Entry<String, FunctionData> entry : this.fAnnotationsMap.entrySet()) {
                    XmlWriter xmlWriter2 = xmlWriter.createElement("Function");
                    xmlWriter2.writeAttribute("name", (Object)entry.getKey());
                    for (Map.Entry<String, LinkedHashMap<String, Object>> entry2 : entry.getValue().getVariables().entrySet()) {
                        XmlWriter xmlWriter3 = xmlWriter2.createElement("Variable");
                        xmlWriter3.writeAttribute("name", (Object)entry2.getKey());
                        Map map = entry2.getValue();
                        for (Map.Entry entry3 : map.entrySet()) {
                            Object v = entry3.getValue();
                            if (v == null) continue;
                            XmlWriter xmlWriter4 = xmlWriter3.createElement("Column");
                            String string = (String)entry3.getKey();
                            xmlWriter4.writeAttribute("property", (Object)string);
                            xmlWriter4.writeAttribute("value", (Object)v.toString());
                            xmlWriter4.writeAttribute("type", (Object)v.getClass().getSimpleName());
                        }
                    }
                }
                String string = xmlWriter.getXML();
                return XmlApi.getInstance().read(string);
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }

    private class FunctionData {
        private Map<String, LinkedHashMap<String, Object>> fVariables = new LinkedHashMap<String, LinkedHashMap<String, Object>>();

        private FunctionData() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasField(String string, String string2) {
            Object object = ProposedTypesModel.this.fLock;
            synchronized (object) {
                Map map = this.fVariables.get(string);
                return map != null && map.containsKey(string2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(String string, String string2, Object object) {
            Object object2 = ProposedTypesModel.this.fLock;
            synchronized (object2) {
                LinkedHashMap<String, Object> linkedHashMap = this.fVariables.get(string);
                if (linkedHashMap == null) {
                    linkedHashMap = new LinkedHashMap();
                    this.fVariables.put(string, linkedHashMap);
                }
                linkedHashMap.put(string2, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(String string, String string2) {
            Object object = ProposedTypesModel.this.fLock;
            synchronized (object) {
                Map map = this.fVariables.get(string);
                return map == null ? null : map.get(string2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, LinkedHashMap<String, Object>> getVariables() {
            Object object = ProposedTypesModel.this.fLock;
            synchronized (object) {
                LinkedHashMap<String, LinkedHashMap<String, Object>> linkedHashMap = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
                for (Map.Entry<String, LinkedHashMap<String, Object>> entry : this.fVariables.entrySet()) {
                    LinkedHashMap linkedHashMap2 = (LinkedHashMap)entry.getValue().clone();
                    linkedHashMap.put(entry.getKey(), linkedHashMap2);
                }
                return linkedHashMap;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(String string) {
            Object object = ProposedTypesModel.this.fLock;
            synchronized (object) {
                this.fVariables.remove(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(String string, String string2) {
            Object object = ProposedTypesModel.this.fLock;
            synchronized (object) {
                Map map = this.fVariables.get(string);
                if (map != null) {
                    map.remove(string2);
                }
            }
        }
    }

    private final class ColumnNode {
        private String fColumnName;
        private TableColumn fColumn;
        private ColumnNode fPrev;
        private ColumnNode fNext;
        private final ColumnNode fOriginalPrev;
        private boolean fVisible = true;

        private ColumnNode(String string, ColumnNode columnNode) {
            this.fColumnName = string;
            this.fColumn = null;
            this.fOriginalPrev = columnNode;
            this.fPrev = columnNode;
            this.fNext = null;
            if (this.fPrev != null) {
                this.fPrev.setNext(this);
            }
        }

        public String getColumnName() {
            return this.fColumnName;
        }

        public TableColumn getColumn() {
            return this.fColumn;
        }

        public void setColumn(TableColumn tableColumn) {
            this.fColumn = tableColumn;
        }

        public ColumnNode getPrev() {
            return this.fPrev;
        }

        public void setPrev(ColumnNode columnNode) {
            this.fPrev = columnNode;
        }

        public ColumnNode getNext() {
            return this.fNext;
        }

        public void setNext(ColumnNode columnNode) {
            this.fNext = columnNode;
        }

        public ColumnNode getOriginalPrev() {
            return this.fOriginalPrev;
        }

        public boolean isVisible() {
            return this.fVisible;
        }

        public void setVisible(boolean bl) {
            this.fVisible = bl;
        }
    }
}

