/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin.workflow;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTable;
import com.mathworks.project.api.ParamWidget;
import com.mathworks.project.api.ValidationMessage;
import com.mathworks.project.api.XmlApi;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.api.XmlWriter;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.WorkflowStepResult;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.util.MulticastChangeListener;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class FunctionReplacementsWidget
implements ParamWidget<XmlReader> {
    private static final Matlab MATLAB = new Matlab();
    private final MJTable fFunctionReplacementsTable;
    private final MJPanel fComponent = new MJPanel((LayoutManager)new FormLayout("4dlu, fill:d:grow, 4dlu", "3dlu, fill:d:grow, 3dlu, fill:d, 3dlu"));
    private final DefaultTableModel fTableModel;
    private final MulticastChangeListener fChangeListeners;
    private final DefaultComboBoxModel fFunctionList;
    private final Configuration fConfiguration;
    private final PropertyChangeListener fPriorStepListener;
    private final Map<String, String> fReplacementMap;
    private static final String QUERY = "emlhdlcoder.WorkFlow.Manager.instance.wfa_getAllReplaceableFunctions";

    public FunctionReplacementsWidget(Param param, Project project) {
        this.fComponent.setOpaque(false);
        this.fComponent.setBorder((Border)new TitledBorder(CoderResources.getString("fixptconv.functionReplacements")));
        this.fReplacementMap = new HashMap<String, String>();
        this.fChangeListeners = new MulticastChangeListener();
        this.fFunctionList = new DefaultComboBoxModel();
        this.fTableModel = new DefaultTableModel();
        MJComboBox mJComboBox = new MJComboBox((ComboBoxModel)this.fFunctionList);
        this.fFunctionReplacementsTable = new MJTable();
        this.fFunctionReplacementsTable.setAutoCreateRowSorter(true);
        this.fFunctionReplacementsTable.setAutoscrolls(true);
        this.fFunctionReplacementsTable.setName("functionReplacementsTable");
        this.fFunctionReplacementsTable.setModel((TableModel)this.fTableModel);
        MJButton mJButton = new MJButton(CoderResources.getString("fxp.generatefixedpointcode.function_replacements.addbuttontext"));
        mJButton.setName("addEntryButton");
        MJButton mJButton2 = new MJButton(CoderResources.getString("fxp.generatefixedpointcode.function_replacements.removebuttontext"));
        mJButton2.setName("removeEntryButton");
        MJPanel mJPanel = new MJPanel((LayoutManager)new FormLayout("fill:d, 3dlu, fill:d", "fill:d"));
        mJPanel.setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        mJPanel.add((Component)mJButton, (Object)cellConstraints.xy(1, 1));
        mJPanel.add((Component)mJButton2, (Object)cellConstraints.xy(3, 1));
        CellConstraints cellConstraints2 = new CellConstraints();
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.fFunctionReplacementsTable);
        this.fComponent.add((Component)mJScrollPane, (Object)cellConstraints2.xy(2, 2));
        this.fComponent.add((Component)mJPanel, (Object)cellConstraints2.xy(2, 4));
        this.fConfiguration = project.getConfiguration();
        this.fPriorStepListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getNewValue() == WorkflowStepResult.COMPLETED && propertyChangeEvent.getPropertyName().equals("__result:category.workflow.proposefixpttypes")) {
                    FunctionReplacementsWidget.this.populateComboBoxes();
                }
            }
        };
        this.fConfiguration.addPropertyChangeListener(this.fPriorStepListener);
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FunctionReplacementsWidget.this.removeSelection();
            }
        });
        mJButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = FunctionReplacementsWidget.this.fFunctionReplacementsTable.getSelectedRows();
                if (nArray == null && FunctionReplacementsWidget.this.fFunctionReplacementsTable.getEditingRow() != -1) {
                    nArray = new int[]{FunctionReplacementsWidget.this.fFunctionReplacementsTable.getEditingRow()};
                }
                if (nArray != null) {
                    for (int i = 0; i < nArray.length; ++i) {
                        FunctionReplacementsWidget.this.fTableModel.removeRow(nArray[i] - i);
                    }
                    FunctionReplacementsWidget.this.fChangeListeners.stateChanged(new ChangeEvent(FunctionReplacementsWidget.this));
                }
            }
        });
        this.fFunctionReplacementsTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127) {
                    FunctionReplacementsWidget.this.removeSelection();
                }
            }
        });
        this.fTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                TableModel tableModel = (TableModel)tableModelEvent.getSource();
                if (tableModel == null) {
                    return;
                }
                for (int i = tableModelEvent.getFirstRow(); i <= tableModelEvent.getLastRow(); ++i) {
                    FunctionReplacementsWidget.this.fChangeListeners.stateChanged(new ChangeEvent(FunctionReplacementsWidget.this));
                }
            }
        });
        this.fTableModel.addColumn(CoderResources.getString("fxp.generatefixedpointcode.function_replacements.column.1"));
        this.fTableModel.addColumn(CoderResources.getString("fxp.generatefixedpointcode.function_replacements.column.2"));
        mJComboBox.setEditable(true);
        mJComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    int n;
                    String string = (String)FunctionReplacementsWidget.this.fReplacementMap.get(itemEvent.getItem().toString());
                    if (string == null) {
                        string = "";
                    }
                    if ((n = FunctionReplacementsWidget.this.fFunctionReplacementsTable.getEditingRow()) >= 0) {
                        FunctionReplacementsWidget.this.fFunctionReplacementsTable.setValueAt((Object)string, n, 1);
                    }
                }
            }
        });
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor((JComboBox<?>)mJComboBox);
        this.fFunctionReplacementsTable.getColumnModel().getColumn(0).setCellEditor(defaultCellEditor);
        this.fFunctionReplacementsTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.fFunctionReplacementsTable.getColumnModel().getColumn(1).setPreferredWidth(400);
    }

    private void removeSelection() {
        Object[] objectArray = new Object[]{"", ""};
        if (this.fTableModel.getRowCount() == 0 || !this.fTableModel.getValueAt(this.fTableModel.getRowCount() - 1, 0).equals("")) {
            this.fFunctionReplacementsTable.clearSelection();
            this.fTableModel.addRow(objectArray);
            this.fFunctionReplacementsTable.scrollRectToVisible(this.fFunctionReplacementsTable.getCellRect(this.fTableModel.getRowCount() - 1, 0, true));
        }
    }

    private void populateComboBoxes() {
        MATLAB.feval("eval", new Object[]{QUERY}, 1, new MatlabListener(){

            public void matlabEvent(MatlabEvent matlabEvent) {
                if (Matlab.getExecutionStatus((int)matlabEvent.getStatus()) == 0) {
                    Object[] objectArray;
                    for (Object object : objectArray = (Object[])matlabEvent.getResult()) {
                        Object[] objectArray2 = (Object[])object;
                        if (FunctionReplacementsWidget.this.fFunctionList.getIndexOf(objectArray2[0]) < 0) {
                            FunctionReplacementsWidget.this.fFunctionList.addElement(objectArray2[0]);
                        }
                        if (!(objectArray2[1] instanceof String)) continue;
                        FunctionReplacementsWidget.this.fReplacementMap.put((String)objectArray2[0], (String)objectArray2[1]);
                    }
                }
            }
        });
    }

    public void setEnabled(boolean bl) {
    }

    public boolean isExternalLabelRequired() {
        return false;
    }

    public void setData(XmlReader xmlReader) {
        if (xmlReader != null) {
            this.fTableModel.setRowCount(0);
            XmlReader xmlReader2 = xmlReader.getChild(new String[]{"Function"});
            while (xmlReader2.isPresent()) {
                String string = xmlReader2.readAttribute("name");
                String string2 = xmlReader2.readAttribute("replacement");
                Object[] objectArray = new String[]{string, string2};
                if (this.fFunctionList.getIndexOf(objectArray) < 0) {
                    this.fFunctionList.addElement(objectArray[0]);
                }
                this.fTableModel.addRow(objectArray);
                xmlReader2 = xmlReader2.next();
            }
        } else {
            this.fTableModel.setRowCount(0);
        }
    }

    public XmlReader getData() {
        try {
            XmlWriter xmlWriter = XmlApi.getInstance().create("FunctionReplacements");
            for (int i = 0; i < this.fTableModel.getRowCount(); ++i) {
                XmlWriter xmlWriter2 = xmlWriter.createElement("Function");
                xmlWriter2.writeAttribute("name", this.fTableModel.getValueAt(i, 0));
                xmlWriter2.writeAttribute("replacement", this.fTableModel.getValueAt(i, 1));
            }
            String string = xmlWriter.getXML();
            return XmlApi.getInstance().read(string);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.removeChangeListener(changeListener);
    }

    public boolean showValidationMessage(ValidationMessage validationMessage) {
        return false;
    }

    public void clearValidationMessage() {
    }

    public Component getComponent() {
        return this.fComponent;
    }

    public void dispose() {
        this.fConfiguration.removePropertyChangeListener(this.fPriorStepListener);
        this.fFunctionReplacementsTable.getColumnModel().getColumn(0).setCellEditor(null);
    }
}

