/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin.inputtypes;

import com.mathworks.project.api.XmlApi;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.model.FileSetInstance;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.project.impl.table.PropertyTableColumn;
import com.mathworks.project.impl.table.PropertyTableModel;
import com.mathworks.project.impl.table.PropertyTableNode;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.TestBenchResult;
import com.mathworks.toolbox.coder.plugin.inputtypes.InputDataProperty;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class TypePropertyTableUtils {
    private TypePropertyTableUtils() {
    }

    private static void addToTree(PropertyTableNode<InputDataProperty> propertyTableNode, InputDataProperty inputDataProperty) {
        PropertyTableNode propertyTableNode2 = new PropertyTableNode(propertyTableNode, false, Arrays.asList(inputDataProperty));
        for (InputDataProperty inputDataProperty2 : inputDataProperty.getChildren()) {
            TypePropertyTableUtils.addToTree((PropertyTableNode<InputDataProperty>)propertyTableNode2, inputDataProperty2);
        }
    }

    public static PropertyTable<InputDataProperty> createInputDataPropertyTable(FileSetInstance fileSetInstance, TestBenchResult testBenchResult) {
        String string;
        XmlReader xmlReader;
        ArrayList<XmlReader> arrayList = new ArrayList<XmlReader>();
        LinkedHashMap<String, XmlReader> linkedHashMap = new LinkedHashMap<String, XmlReader>();
        for (File object2 : fileSetInstance.getFiles()) {
            linkedHashMap.put(object2.getName(), null);
        }
        for (String string2 : testBenchResult.getEntryPointTypes().values()) {
            try {
                xmlReader = XmlApi.getInstance().read(string2);
                string = xmlReader.readAttribute("fileName");
                linkedHashMap.put(string, xmlReader);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Test bench inference generated invalid XML result: " + string2, iOException);
            }
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            if (entry.getValue() == null) continue;
            xmlReader = new PropertyTableNode(null, true, (String)entry.getKey());
            arrayList.add(xmlReader);
            string = ((XmlReader)entry.getValue()).getChild(new String[]{"Input"});
            while (string.isPresent()) {
                InputDataProperty inputDataProperty = InputDataProperty.createInputDataProperty((XmlReader)string);
                TypePropertyTableUtils.addToTree((PropertyTableNode<InputDataProperty>)xmlReader, inputDataProperty);
                string = string.next();
            }
        }
        ArrayList arrayList2 = new ArrayList();
        arrayList2.add(new PropertyTableColumn<InputDataProperty>(){

            public String getText(InputDataProperty inputDataProperty) {
                return inputDataProperty.getName();
            }

            public HyperlinkTextLabel createLink(InputDataProperty inputDataProperty) {
                return null;
            }

            public String getName() {
                return CoderResources.getString("header.autoPopulateTypes.name");
            }

            public boolean isEditable() {
                return false;
            }
        });
        arrayList2.add(new PropertyTableColumn<InputDataProperty>(){

            public String getText(InputDataProperty inputDataProperty) {
                return inputDataProperty.getDefinition();
            }

            public HyperlinkTextLabel createLink(InputDataProperty inputDataProperty) {
                return null;
            }

            public String getName() {
                return CoderResources.getString("header.autoPopulateTypes.type");
            }

            public boolean isEditable() {
                return false;
            }
        });
        PropertyTableModel propertyTableModel = new PropertyTableModel((List)arrayList2, arrayList);
        propertyTableModel.expandAll();
        return new PropertyTable(propertyTableModel);
    }
}

