/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin.inputtypes;

import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPClassEnum;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPFimath;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPNumericType;
import com.mathworks.toolbox.coder.plugin.inputtypes.InputDataPropertyDimSize;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class IDPAttributes {
    private String fName;
    private String fClassName;
    private boolean fComplex;
    private boolean fHasComplexness;
    private boolean fConstant;
    private Vector<InputDataPropertyDimSize> fDimensions;
    private String fCStructNameTypeName;
    private boolean fCStructNameExtern;
    private String fCStructNameHeaderFile;
    private int fCStructNameAlignment;
    private static boolean sSupportsFixedPoint = false;
    private static boolean sSupportsFixedPointReported = false;
    private IDPNumericType fNumericType = null;
    private IDPFimath fFimath = null;

    public IDPAttributes(String string) {
        this.fName = string;
        boolean bl = this.isVarargin();
        this.fClassName = bl ? IDPClassEnum.CELL.getClassName() : (this.isTilde() ? IDPClassEnum.DOUBLE.getClassName() : IDPClassEnum.UNDEFINED.getClassName());
        this.fComplex = false;
        this.fHasComplexness = true;
        this.fConstant = false;
        this.fDimensions = new Vector(2);
        this.fDimensions.addElement(new InputDataPropertyDimSize());
        this.fDimensions.addElement(new InputDataPropertyDimSize(bl ? 0 : 1));
        this.fCStructNameTypeName = "";
        this.fCStructNameExtern = false;
        this.fCStructNameHeaderFile = "";
        this.fCStructNameAlignment = 0;
        if (IDPAttributes.supportsFixedPoint()) {
            this.fNumericType = new IDPNumericType();
            this.fFimath = new IDPFimath();
        }
    }

    public IDPAttributes(IDPAttributes iDPAttributes) {
        this.fName = iDPAttributes.getName();
        this.fClassName = iDPAttributes.getClassName();
        this.fComplex = iDPAttributes.isComplex();
        this.fHasComplexness = iDPAttributes.hasComplexness();
        this.fConstant = iDPAttributes.isConstant();
        this.fDimensions = new Vector<InputDataPropertyDimSize>(iDPAttributes.getDimensions());
        this.fCStructNameTypeName = iDPAttributes.getCStructNameTypeName();
        this.fCStructNameExtern = iDPAttributes.isCStructNameExtern();
        this.fCStructNameHeaderFile = iDPAttributes.getCStructNameHeaderFile();
        this.fCStructNameAlignment = iDPAttributes.getCStructNameAlignment();
        if (IDPAttributes.supportsFixedPoint()) {
            this.fNumericType = new IDPNumericType(iDPAttributes.getNumericType());
            this.fFimath = new IDPFimath(iDPAttributes.getFimath());
        } else {
            this.fNumericType = null;
            this.fFimath = null;
        }
    }

    private static boolean canSupportFixedPoint() {
        try {
            if (Class.forName("com.mathworks.toolbox.fixedpoint.NumericTypePanel") != null) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public static void setSupportsFixedPoint(boolean bl) {
        sSupportsFixedPoint = bl && IDPAttributes.canSupportFixedPoint();
        IDPAttributes.setSupportsFixedPointReported(false);
    }

    public static boolean supportsFixedPoint() {
        return sSupportsFixedPoint;
    }

    public static boolean supportsFixedPointReported() {
        return sSupportsFixedPointReported;
    }

    public static void setSupportsFixedPointReported(boolean bl) {
        sSupportsFixedPointReported = bl;
    }

    public static void reportUnsupportedFixedPoint() {
        if (!IDPAttributes.supportsFixedPoint() && !IDPAttributes.supportsFixedPointReported()) {
            IDPAttributes.setSupportsFixedPointReported(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MJOptionPane.showMessageDialog((Component)MLDesktop.getInstance().getMainFrame(), (Object)CoderResources.getString("msg.fixedPointTypeNotSupported"), (String)CoderResources.getString("msg.fixedPointTypeNotSupported.title"), (int)0);
                }
            });
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.hasComplexness() && this.isComplex()) {
            stringBuilder.append("complex ");
        } else {
            stringBuilder.append("real ");
        }
        if (this.isConstant()) {
            stringBuilder.append("constant ");
        }
        return stringBuilder.toString();
    }

    public void setName(String string) {
        this.fName = string;
        if (this.isTilde() && this.isUndefined()) {
            this.setClassName(IDPClassEnum.DOUBLE.getClassName());
        }
    }

    public String getName() {
        return this.fName;
    }

    public void setVarargName(int n) {
        this.fName = "varargin{" + n + "}";
    }

    public static boolean isTilde(String string) {
        return "~".equals(string);
    }

    public boolean isTilde() {
        return IDPAttributes.isTilde(this.getName());
    }

    public static boolean isVarargin(String string) {
        return "varargin".equals(string);
    }

    public boolean isVarargin() {
        return IDPAttributes.isVarargin(this.getName());
    }

    public void setClassName(String string) {
        this.fClassName = string;
        this.resetAttributes();
    }

    public String getClassName() {
        return this.fClassName;
    }

    public IDPClassEnum getClassID() {
        for (IDPClassEnum iDPClassEnum : IDPClassEnum.values()) {
            if (!iDPClassEnum.getClassName().equals(this.fClassName)) continue;
            return iDPClassEnum;
        }
        return IDPClassEnum.ENUM;
    }

    public boolean isUndefined() {
        return this.getClassID() == IDPClassEnum.UNDEFINED;
    }

    public boolean isStruct() {
        return this.getClassID() == IDPClassEnum.STRUCT;
    }

    public boolean isFixedPoint() {
        return this.getClassID() == IDPClassEnum.FI;
    }

    public boolean isChar() {
        return this.getClassID() == IDPClassEnum.CHAR;
    }

    public boolean isLogical() {
        return this.getClassID() == IDPClassEnum.LOGICAL;
    }

    public boolean isEnum() {
        return this.getClassID() == IDPClassEnum.ENUM;
    }

    public boolean isCell() {
        return this.getClassID() == IDPClassEnum.CELL;
    }

    private void resetAttributes() {
        this.setHasComplexness(!this.isStruct() && !this.isEnum() && !this.isCell() && !this.isChar() && !this.isLogical());
        this.setConstant(false);
    }

    public boolean isComplex() {
        return this.fComplex;
    }

    public void setComplex(boolean bl) {
        this.fComplex = bl;
    }

    public boolean hasComplexness() {
        return this.fHasComplexness;
    }

    public void setHasComplexness(boolean bl) {
        this.fHasComplexness = bl;
    }

    public boolean isConstant() {
        return this.fConstant;
    }

    public void setConstant(boolean bl) {
        this.fConstant = bl;
    }

    public boolean dimensionsEqual(Collection<InputDataPropertyDimSize> collection) {
        return this.fDimensions.equals(collection);
    }

    public void replaceDimensions(Collection<InputDataPropertyDimSize> collection) {
        this.fDimensions.removeAllElements();
        this.fDimensions.addAll(collection);
        if (this.fDimensions.size() < 2) {
            this.fDimensions.add(new InputDataPropertyDimSize());
        }
    }

    public List<InputDataPropertyDimSize> getDimensions() {
        return Collections.unmodifiableList(this.fDimensions);
    }

    public boolean isEmpty() {
        for (InputDataPropertyDimSize inputDataPropertyDimSize : this.fDimensions) {
            if (!inputDataPropertyDimSize.isZero()) continue;
            return true;
        }
        return false;
    }

    public String getSizeString() {
        return IDPAttributes.getSizeString(this.fDimensions);
    }

    public static String getSizeString(Iterable<InputDataPropertyDimSize> iterable) {
        StringBuilder stringBuilder = new StringBuilder();
        for (InputDataPropertyDimSize inputDataPropertyDimSize : iterable) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" x ");
            }
            if (inputDataPropertyDimSize.isDimDynamic()) {
                stringBuilder.append(":");
                if (inputDataPropertyDimSize.isDimUnbounded()) {
                    stringBuilder.append("inf");
                    continue;
                }
                stringBuilder.append(inputDataPropertyDimSize.getDim());
                continue;
            }
            stringBuilder.append(inputDataPropertyDimSize.getDim());
        }
        return stringBuilder.toString();
    }

    public IDPNumericType getNumericType() {
        return this.fNumericType;
    }

    public void setNumericType(IDPNumericType iDPNumericType) {
        this.fNumericType = iDPNumericType;
    }

    public IDPFimath getFimath() {
        return this.fFimath;
    }

    public void setFimath(IDPFimath iDPFimath) {
        this.fFimath = iDPFimath;
    }

    public String getCStructNameTypeName() {
        return this.fCStructNameTypeName;
    }

    public void setCStructNameTypeName(String string) {
        this.fCStructNameTypeName = string.trim();
    }

    public boolean hasCStructNameTypeName() {
        return this.fCStructNameTypeName != null && !this.fCStructNameTypeName.isEmpty();
    }

    public boolean isCStructNameExtern() {
        return this.fCStructNameExtern;
    }

    public void setCStructNameExtern(boolean bl) {
        this.fCStructNameExtern = bl;
    }

    public String getCStructNameHeaderFile() {
        return this.fCStructNameHeaderFile;
    }

    public void setCStructNameHeaderFile(String string) {
        this.fCStructNameHeaderFile = string.trim();
    }

    public int getCStructNameAlignment() {
        return this.fCStructNameAlignment;
    }

    public void setCStructNameAlignment(int n) {
        if (n < 0) {
            this.fCStructNameAlignment = 0;
        }
        this.fCStructNameAlignment = n > 128 ? 128 : n & 0xFFFFFFFE;
    }
}

