/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin;

import com.mathworks.project.api.ReadableConfiguration;
import com.mathworks.toolbox.coder.plugin.OutputFileType;

public enum WorkingDirectoryType {
    PROJECT("option.paths.working.project"),
    CURRENT("option.paths.working.current"),
    SPECIFIED("option.paths.working.specified");

    private String fKey;

    private WorkingDirectoryType(String string2) {
        this.fKey = string2;
    }

    String getKey() {
        return this.fKey;
    }

    String getKeyAsText(ReadableConfiguration readableConfiguration) {
        return readableConfiguration.getResourceString(this.fKey);
    }

    static String getKeyOf(int n) {
        for (OutputFileType outputFileType : OutputFileType.values()) {
            if (outputFileType.ordinal() != n) continue;
            return outputFileType.getKey();
        }
        return PROJECT.getKey();
    }

    static WorkingDirectoryType lookupKey(String string) {
        for (WorkingDirectoryType workingDirectoryType : WorkingDirectoryType.values()) {
            if (!string.equals(workingDirectoryType.getKey())) continue;
            return workingDirectoryType;
        }
        return PROJECT;
    }

    static boolean isSpecified(String string) {
        WorkingDirectoryType workingDirectoryType = WorkingDirectoryType.lookupKey(string);
        return workingDirectoryType == SPECIFIED;
    }
}

