/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.common.icons.DebuggingIcon;
import com.mathworks.common.icons.DialogIcon;
import com.mathworks.common.icons.MiscellaneousIcon;
import com.mathworks.mlwidgets.explorer.model.MatlabPathModel;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.DeploymentProcessMonitor;
import com.mathworks.project.api.ReadableConfiguration;
import com.mathworks.project.api.ReadableFileSet;
import com.mathworks.project.api.SectionComponentWithPropertySupport;
import com.mathworks.project.api.SubProcessType;
import com.mathworks.project.api.WritableConfiguration;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.desktop.BasicProjectClient;
import com.mathworks.project.impl.desktop.BuildAction;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.FileSetInstance;
import com.mathworks.project.impl.settingsui.ParamWidgetBinder;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.InstrumentationUtils;
import com.mathworks.toolbox.coder.plugin.TestBenchConfig;
import com.mathworks.toolbox.coder.plugin.TestBenchResult;
import com.mathworks.toolbox.coder.plugin.TestBenchRunMode;
import com.mathworks.toolbox.coder.plugin.TestBenchUtils;
import com.mathworks.toolbox.coder.plugin.TestFileSelectorPanel;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.widgets.BusyAffordance;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public final class VerificationSection
implements SectionComponentWithPropertySupport {
    private final Configuration fConfiguration;
    private final BasicProjectClient fClient;
    private final BuildAction fBuildAction;
    private final PropertyChangeListener fConfigurationListener;
    private final PropertyChangeListener fBuildActionListener;
    private final PropertyChangeListener fCurrentFolderChangeListener;
    private final PropertyChangeSupport fPropertySupport;
    private final MJPanel fComponent;
    private final TestFileSelectorPanel fTestFileSelector;
    private final MJPanel fButtonPanel;
    private final Component fMergeInstrumentationResultsCheckBox;
    private final Component fRebuildMexCheckBox;
    private final Component fInvokeMexCheckBox;
    private final MJLabel fWarningLabel;
    private final MJButton fRunButton;
    private final MJButton fClearInstrumentationResultsButton;
    private final ParamWidgetBinder fBinder;
    private final BusyAffordance fBusyAffordance;
    private String fHeaderText;
    private boolean fReloadedDefaultFile;
    private boolean fRunning;
    private boolean fCanceled;
    private boolean fOriginalGenCodeOnlyValue;

    public VerificationSection(WritableConfiguration writableConfiguration) {
        this.fConfiguration = (Configuration)writableConfiguration;
        this.fPropertySupport = new PropertyChangeSupport(this);
        this.fComponent = new MJPanel();
        this.fComponent.setOpaque(false);
        this.fClient = (BasicProjectClient)ProjectGUI.getInstance().getCurrentClient();
        this.fBuildAction = (BuildAction)this.fClient.getAction("BUILD");
        this.fTestFileSelector = new TestFileSelectorPanel((WritableConfiguration)this.fConfiguration, true);
        this.fBinder = new ParamWidgetBinder(this.fConfiguration.getProject(), true);
        this.fTestFileSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                File file = VerificationSection.this.fTestFileSelector.getSelectedFile();
                if (VerificationSection.this.fReloadedDefaultFile && file != null) {
                    VerificationSection.this.fConfiguration.setParamAsFile("param.DefaultTestFile", file);
                }
            }
        });
        this.fTestFileSelector.setQeNamePrefix("verification");
        ReadableFileSet readableFileSet = Utilities.getTestFileSet((ReadableConfiguration)this.fConfiguration);
        this.fMergeInstrumentationResultsCheckBox = this.fBinder.createAndRegister(this.fConfiguration.getTarget().getParam("param.MergeInstrumentationResults"));
        this.fRebuildMexCheckBox = this.fBinder.createAndRegister(this.fConfiguration.getTarget().getParam("param.RebuildBeforeTesting"));
        this.fInvokeMexCheckBox = this.fBinder.createAndRegister(this.fConfiguration.getTarget().getParam("param.CallGeneratedCodeFromTest"));
        this.fWarningLabel = new MJLabel(CoderResources.getString("verification.redirection.warning"));
        this.fWarningLabel.setIcon((Icon)DialogIcon.ERROR.getIcon());
        this.fRunButton = new MJButton();
        this.fRunButton.setName("testfile.button.runOrStop");
        this.configureRunButton();
        this.fClearInstrumentationResultsButton = new MJButton(CoderResources.getString("verification.clear.instrumentation"));
        this.fClearInstrumentationResultsButton.setName("testfile.button.clear.instrumentation");
        this.updateClearButton();
        this.fClearInstrumentationResultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InstrumentationUtils.clearResults(VerificationSection.this.fConfiguration);
            }
        });
        this.fBusyAffordance = new BusyAffordance(BusyAffordance.AffordanceSize.SIZE_16x16);
        this.fButtonPanel = new MJPanel((LayoutManager)new FormLayout("0dlu:grow, fill:d, 3dlu, fill:d", "fill:d"));
        this.fButtonPanel.setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        this.fBusyAffordance.getComponent().setVisible(false);
        this.fButtonPanel.add((Component)this.fBusyAffordance.getComponent(), (Object)cellConstraints.xy(2, 1));
        this.fButtonPanel.add((Component)this.fRunButton, (Object)cellConstraints.xy(4, 1));
        this.fConfigurationListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("files")) {
                    VerificationSection.this.updateWarning();
                } else if (propertyChangeEvent.getPropertyName().equals("param.artifact")) {
                    final String string = VerificationSection.this.fHeaderText;
                    VerificationSection.this.rebuild();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            VerificationSection.this.fPropertySupport.firePropertyChange("header-text", string, VerificationSection.this.fHeaderText);
                        }
                    });
                } else if (propertyChangeEvent.getPropertyName().equals("param.WorkingFolder") || propertyChangeEvent.getPropertyName().equals("param.SpecifiedWorkingFolder")) {
                    VerificationSection.this.configureRunButton();
                    VerificationSection.this.updateWarning();
                } else if (propertyChangeEvent.getPropertyName().equals("param.BuiltInstrumentedMex") || propertyChangeEvent.getPropertyName().equals("param.RanInstrumentedMex")) {
                    VerificationSection.this.updateClearButton();
                } else if (propertyChangeEvent.getPropertyName().equals("param.CallGeneratedCodeFromTest")) {
                    VerificationSection.this.configureRunButton();
                    VerificationSection.this.updateWarning();
                } else if (propertyChangeEvent.getPropertyName().equals("param.RebuildBeforeTesting")) {
                    VerificationSection.this.updateClearButton();
                    if (propertyChangeEvent.getNewValue().equals(Boolean.TRUE)) {
                        VerificationSection.this.fConfiguration.setParamAsBoolean("param.MergeInstrumentationResults", false);
                    }
                } else if (propertyChangeEvent.getPropertyName().equals("param.MergeInstrumentationResults")) {
                    VerificationSection.this.updateClearButton();
                }
            }
        };
        writableConfiguration.addPropertyChangeListener(this.fConfigurationListener);
        this.updateWarning();
        this.configureRunButton();
        this.fRunButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (VerificationSection.this.fRunning) {
                    VerificationSection.this.fCanceled = true;
                    TestBenchUtils.interruptTestBench();
                } else {
                    VerificationSection.this.buildIfRequestedAndRun();
                }
            }
        });
        this.fBuildActionListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!VerificationSection.this.fRunning && propertyChangeEvent.getPropertyName().equals("enabled")) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            VerificationSection.this.configureRunButton();
                        }
                    });
                }
            }
        };
        this.fCurrentFolderChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                VerificationSection.this.configureRunButton();
                VerificationSection.this.updateWarning();
            }
        };
        MatlabPathModel.getInstance().addPropertyChangeListener(this.fCurrentFolderChangeListener);
        this.fClient.getAction("BUILD").addPropertyChangeListener(this.fBuildActionListener);
        this.rebuild();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VerificationSection.this.fPropertySupport.firePropertyChange("header-text", null, VerificationSection.this.fHeaderText);
            }
        });
        File file = this.fConfiguration.getParamAsFile("param.DefaultTestFile");
        if (file != null && readableFileSet.getFiles().contains(file)) {
            this.fTestFileSelector.setSelectedFile(file);
        }
        this.fTestFileSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                VerificationSection.this.configureRunButton();
            }
        });
        this.fReloadedDefaultFile = true;
    }

    private void updateClearButton() {
        String string = this.fConfiguration.getParamAsString("param.artifact");
        final boolean bl = string.equals("option.target.artifact.mex.instrumented");
        final boolean bl2 = this.fConfiguration.getParamAsBoolean("param.RanInstrumentedMex");
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                VerificationSection.this.fClearInstrumentationResultsButton.setVisible(bl && bl2);
            }
        });
    }

    private void rebuild() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                VerificationSection.this.fComponent.removeAll();
                VerificationSection.this.fComponent.setLayout((LayoutManager)new GridBagLayout());
                String string = VerificationSection.this.fConfiguration.getParamAsString("param.artifact");
                boolean bl = string.equals("option.target.artifact.mex");
                boolean bl2 = string.equals("option.target.artifact.mex.instrumented");
                if (bl2) {
                    VerificationSection.this.fHeaderText = CoderResources.getString("verification.header.instrumented");
                } else {
                    VerificationSection.this.fHeaderText = CoderResources.getString("verification.header.normal");
                }
                if (bl || bl2) {
                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = 0;
                    gridBagConstraints.anchor = 17;
                    gridBagConstraints.insets = new Insets(6, 0, 3, 5);
                    if (bl2) {
                        gridBagConstraints.weightx = 1.0;
                        gridBagConstraints.fill = 2;
                        gridBagConstraints.gridwidth = 2;
                        VerificationSection.this.fComponent.add((Component)Utilities.createDescriptionComponent("verification.instrumented.desc"), (Object)gridBagConstraints);
                        ++gridBagConstraints.gridy;
                        gridBagConstraints.gridwidth = 1;
                        gridBagConstraints.weightx = 0.0;
                        gridBagConstraints.fill = 0;
                    }
                    VerificationSection.this.fComponent.add((Component)new MJLabel(CoderResources.getString("verification.testfile.name")), (Object)gridBagConstraints);
                    gridBagConstraints.insets.right = 2;
                    ++gridBagConstraints.gridx;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.weightx = 1.0;
                    VerificationSection.this.fComponent.add((Component)VerificationSection.this.fTestFileSelector.getComponent(), (Object)gridBagConstraints);
                    gridBagConstraints.insets.top = 3;
                    ++gridBagConstraints.gridy;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridwidth = 2;
                    if (bl2) {
                        VerificationSection.this.fComponent.add(VerificationSection.this.fMergeInstrumentationResultsCheckBox, (Object)gridBagConstraints);
                        ++gridBagConstraints.gridy;
                    } else {
                        VerificationSection.this.fComponent.add(VerificationSection.this.fRebuildMexCheckBox, (Object)gridBagConstraints);
                        ++gridBagConstraints.gridy;
                    }
                    VerificationSection.this.fComponent.add(VerificationSection.this.fInvokeMexCheckBox, (Object)gridBagConstraints);
                    ++gridBagConstraints.gridy;
                    VerificationSection.this.fComponent.add((Component)VerificationSection.this.fWarningLabel, (Object)gridBagConstraints);
                    ++gridBagConstraints.gridy;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    if (bl2) {
                        VerificationSection.this.fComponent.add((Component)VerificationSection.this.fClearInstrumentationResultsButton, (Object)gridBagConstraints);
                        ++gridBagConstraints.gridy;
                    }
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.fill = 2;
                    ++gridBagConstraints.gridy;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.anchor = 13;
                    gridBagConstraints.insets.right = 6;
                    gridBagConstraints.insets.bottom = 12;
                    VerificationSection.this.fComponent.add((Component)VerificationSection.this.fButtonPanel, (Object)gridBagConstraints);
                } else {
                    VerificationSection.this.fComponent.setLayout((LayoutManager)new BorderLayout());
                    VerificationSection.this.fComponent.add((Component)Utilities.createDescriptionComponent("verification.unavailable"), (Object)"Center");
                }
                VerificationSection.this.fComponent.revalidate();
                VerificationSection.this.fComponent.repaint();
            }
        });
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    public void dispose() {
        this.fConfiguration.removePropertyChangeListener(this.fConfigurationListener);
        this.fBuildAction.removePropertyChangeListener(this.fBuildActionListener);
        this.fTestFileSelector.dispose();
        this.fBinder.dispose();
        MatlabPathModel.getInstance().removePropertyChangeListener(this.fCurrentFolderChangeListener);
    }

    private void updateWarning() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (VerificationSection.this.hasRedirectionProblem()) {
                    VerificationSection.this.fWarningLabel.setVisible(true);
                } else {
                    VerificationSection.this.fWarningLabel.setVisible(false);
                }
            }
        });
    }

    private boolean hasFile() {
        return this.fTestFileSelector.getSelectedFile() != null;
    }

    private boolean hasRedirectionProblem() {
        return this.fConfiguration.getParamAsBoolean("param.CallGeneratedCodeFromTest") && this.hasEntryPointOutsideWorkingFolder();
    }

    private boolean hasEntryPointOutsideWorkingFolder() {
        FileSetInstance fileSetInstance = this.fConfiguration.getFileSet("fileset.entrypoints");
        File file = this.getAbsoluteWorkingFolder();
        if (file == null) {
            return false;
        }
        for (File file2 : fileSetInstance.getFiles()) {
            File file3 = file2.getParentFile();
            if (file3 != null && file3.equals(file)) continue;
            return true;
        }
        return false;
    }

    private void configureRunButton() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (VerificationSection.this.fRunning) {
                    VerificationSection.this.fRunButton.setEnabled(true);
                    VerificationSection.this.fRunButton.setIcon((Icon)MiscellaneousIcon.CANCEL_15x15.getIcon());
                    VerificationSection.this.fRunButton.setText(CoderResources.getString("verification.stop"));
                } else {
                    VerificationSection.this.fRunButton.setEnabled(VerificationSection.this.hasFile() && !VerificationSection.this.hasRedirectionProblem() && ProjectGUI.getInstance().getCurrentProcess() == null);
                    VerificationSection.this.fRunButton.setText(BuiltInResources.getString((String)"button.build"));
                    VerificationSection.this.fRunButton.setIcon((Icon)DebuggingIcon.PLAY.getIcon());
                    int n = (int)VerificationSection.this.fRunButton.getPreferredSize().getWidth();
                    VerificationSection.this.fRunButton.setText(CoderResources.getString("verification.run"));
                    n = Math.max((int)VerificationSection.this.fRunButton.getPreferredSize().getWidth(), n);
                    VerificationSection.this.fRunButton.setPreferredSize(new Dimension(n, (int)VerificationSection.this.fRunButton.getPreferredSize().getHeight()));
                }
            }
        });
    }

    private void buildIfRequestedAndRun() {
        final TestBenchConfig testBenchConfig = new TestBenchConfig(this.fConfiguration.getParamAsBoolean("param.CallGeneratedCodeFromTest") ? TestBenchRunMode.RUN_COMPILED : TestBenchRunMode.RUN_ORIGINAL);
        testBenchConfig.setTestBenchFile(this.fTestFileSelector.getSelectedFile());
        FileSetInstance fileSetInstance = this.fConfiguration.getFileSet("fileset.entrypoints");
        testBenchConfig.setEntryPointFiles(fileSetInstance.getFiles());
        testBenchConfig.setMexFunctionName(this.fConfiguration.getParamAsString("param.mex.outputfile"));
        testBenchConfig.setWorkingFolder(this.getProjectWorkingFolder());
        this.fRunning = true;
        this.fCanceled = false;
        this.fBuildAction.setEnabled(false);
        this.fTestFileSelector.setEnabled(false);
        this.fRebuildMexCheckBox.setEnabled(false);
        this.fRebuildMexCheckBox.setName("param.RebuildBeforeTesting.check");
        this.fInvokeMexCheckBox.setEnabled(false);
        this.fInvokeMexCheckBox.setName("param.CallGeneratedCodeFromTest.check");
        this.fRunButton.setEnabled(false);
        this.fClearInstrumentationResultsButton.setEnabled(false);
        this.fBusyAffordance.getComponent().setVisible(true);
        this.fBusyAffordance.start();
        this.fConfiguration.setForcedDisabled("param.mex.outputfile", true);
        this.fConfiguration.setForcedDisabled("param.artifact", true);
        this.fConfiguration.setForcedDisabled("param.mex.GenCodeOnly", true);
        this.fOriginalGenCodeOnlyValue = this.fConfiguration.getParamAsBoolean("param.mex.GenCodeOnly");
        this.fConfiguration.setParamAsBoolean("param.mex.GenCodeOnly", false);
        String string = this.fConfiguration.getParamAsString("param.artifact");
        boolean bl = string.equals("option.target.artifact.mex.instrumented");
        if (!bl && this.fConfiguration.getParamAsBoolean("param.RebuildBeforeTesting")) {
            this.fBuildAction.startBuild(new DeploymentProcessMonitor(){

                public void subProcessStarted(SubProcessType subProcessType) {
                }

                public void commandStarted(String string) {
                }

                public void commandOutput(String string) {
                }

                public void commandError(String string) {
                }

                public void finished() {
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            VerificationSection.this.fClient.disposeBuildProgressDialog();
                            VerificationSection.this.startRunning(testBenchConfig);
                        }
                    });
                }

                public void failed() {
                    this.canceled();
                }

                public void canceled() {
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            VerificationSection.this.runningStopped();
                        }
                    });
                }
            });
        } else {
            if (!this.fConfiguration.getParamAsBoolean("param.MergeInstrumentationResults") && string.equals("option.target.artifact.mex.instrumented")) {
                InstrumentationUtils.clearResults(this.fConfiguration);
            }
            this.startRunning(testBenchConfig);
        }
    }

    private void startRunning(TestBenchConfig testBenchConfig) {
        this.configureRunButton();
        TestBenchUtils.runTestBench(testBenchConfig, new ParameterRunnable<TestBenchResult>(){

            public void run(TestBenchResult testBenchResult) {
                boolean bl;
                VerificationSection.this.runningStopped();
                String string = VerificationSection.this.fConfiguration.getParamAsString("param.artifact");
                boolean bl2 = string.equals("option.target.artifact.mex.instrumented");
                boolean bl3 = bl = bl2 && VerificationSection.this.fConfiguration.getParamAsBoolean("param.LaunchInstrumentationReport");
                if (!VerificationSection.this.fCanceled && !testBenchResult.getMessage().isEmpty()) {
                    TestBenchUtils.showTestBenchError((Component)VerificationSection.this.fComponent, VerificationSection.getHeader(), testBenchResult);
                } else if (!VerificationSection.this.fCanceled && bl) {
                    InstrumentationUtils.showReport(VerificationSection.this.fConfiguration, VerificationSection.this.fBusyAffordance, new String[0]);
                }
                if (!VerificationSection.this.fCanceled && testBenchResult.getMessage().isEmpty() && InstrumentationUtils.isInstrumentedMex(VerificationSection.this.fConfiguration)) {
                    VerificationSection.this.fConfiguration.setParamAsBoolean("param.RanInstrumentedMex", true);
                }
            }
        });
    }

    private void runningStopped() {
        this.fRunning = false;
        this.fTestFileSelector.setEnabled(true);
        this.fRebuildMexCheckBox.setEnabled(true);
        this.fInvokeMexCheckBox.setEnabled(true);
        this.fClearInstrumentationResultsButton.setEnabled(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VerificationSection.this.fBuildAction.setEnabled(true);
            }
        });
        this.configureRunButton();
        this.fBusyAffordance.stop();
        this.fBusyAffordance.getComponent().setVisible(false);
        this.fConfiguration.setParamAsBoolean("param.mex.GenCodeOnly", this.fOriginalGenCodeOnlyValue);
        this.fConfiguration.setForcedDisabled("param.artifact", false);
        this.fConfiguration.setForcedDisabled("param.mex.outputfile", false);
        this.fConfiguration.setForcedDisabled("param.mex.GenCodeOnly", false);
    }

    private String getProjectWorkingFolder() {
        String string = this.fConfiguration.getParamAsString("param.WorkingFolder");
        if (string.equals("option.WorkingFolder.Specified")) {
            return this.fConfiguration.getParamAsString("param.SpecifiedWorkingFolder");
        }
        if (string.equals("option.WorkingFolder.Project")) {
            return this.fConfiguration.getFile().getParent();
        }
        return "";
    }

    private File getAbsoluteWorkingFolder() {
        String string = this.fConfiguration.getParamAsString("param.WorkingFolder");
        if (string.equals("option.WorkingFolder.Specified")) {
            String string2 = this.fConfiguration.getParamAsString("param.SpecifiedWorkingFolder");
            if (string2 == null) {
                return null;
            }
            if (new File(string2).isAbsolute()) {
                return new File(string2);
            }
            return new File(MatlabPathModel.getInstance().getCurrentFolder().toFile(), string2);
        }
        if (string.equals("option.WorkingFolder.Project")) {
            return new File(this.fConfiguration.getFile().getParent());
        }
        return MatlabPathModel.getInstance().getCurrentFolder().toFile();
    }

    private static String getHeader() {
        return CoderResources.getString("verification.dialog.title");
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public String getHeaderToolTipText() {
        return null;
    }
}

