/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin;

import com.mathworks.project.api.ReadableConfiguration;

enum TargetType {
    MEX_CODE("option.target.mex.code", "CoderOutput.png"),
    EMBEDDED_PROTOTYPE("option.target.embedded.prototype", "CoderOutput.png"),
    EMBEDDED_PRODUCTION("option.target.embedded.production", "CoderOutput.png");

    private String fKey;
    private String fIconName;

    private TargetType(String string2, String string3) {
        this.fKey = string2;
        this.fIconName = string3;
    }

    String getKeyAsText(ReadableConfiguration readableConfiguration) {
        return readableConfiguration.getResourceString(this.fKey);
    }

    String getKey() {
        return this.fKey;
    }

    String getIconName() {
        return this.fIconName;
    }

    static TargetType lookupKey(String string) {
        for (TargetType targetType : TargetType.values()) {
            if (!string.equals(targetType.getKey())) continue;
            return targetType;
        }
        return MEX_CODE;
    }

    static boolean isMexTarget(String string) {
        TargetType targetType = TargetType.lookupKey(string);
        return targetType == MEX_CODE;
    }

    static String getKeyOf(int n) {
        for (TargetType targetType : TargetType.values()) {
            if (targetType.ordinal() != n) continue;
            return targetType.getKey();
        }
        return MEX_CODE.getKey();
    }
}

