/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin;

import com.mathworks.toolbox.coder.plugin.CoderResources;

public enum TargetArtifact {
    MEX("target.artifact.mex", "option.target.artifact.mex", "target.artifact.mex.desc"),
    LIB("target.artifact.lib", "option.target.artifact.lib", "target.artifact.lib.desc"),
    DLL("target.artifact.dll", "option.target.artifact.dll", "target.artifact.dll.desc"),
    EXE("target.artifact.exe", "option.target.artifact.exe", "target.artifact.exe.desc");

    private String fKey;
    private String fParamValue;
    private String fToolTipKey;

    private TargetArtifact(String string2, String string3, String string4) {
        this.fKey = string2;
        this.fParamValue = string3;
        this.fToolTipKey = string4;
    }

    String getKey() {
        return this.fKey;
    }

    String getKeyAsText() {
        return CoderResources.getString(this.fKey);
    }

    String getParamValue() {
        return this.fParamValue;
    }

    String getToolTipText() {
        return CoderResources.getString(this.fToolTipKey);
    }

    static TargetArtifact lookupParamValue(String string) {
        for (TargetArtifact targetArtifact : TargetArtifact.values()) {
            if (!string.equals(targetArtifact.getParamValue())) continue;
            return targetArtifact;
        }
        return LIB;
    }

    static String getKeyAsTextOf(String string) {
        return TargetArtifact.lookupParamValue(string).getKeyAsText();
    }

    static boolean isMexTarget(String string) {
        TargetArtifact targetArtifact = TargetArtifact.lookupParamValue(string);
        return targetArtifact == MEX;
    }

    static boolean isExeTarget(String string) {
        TargetArtifact targetArtifact = TargetArtifact.lookupParamValue(string);
        return targetArtifact == EXE;
    }
}

