/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin;

import com.jidesoft.swing.MultilineLabel;
import com.mathworks.jmi.MatlabException;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Param;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.MatlabResult;
import com.mathworks.widgets.BusyAffordance;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;

public final class InstrumentationUtils {
    private static final String PROPOSE_FIXED_POINT_DATA_TYPES_KEY = "param.ProposeFixedPointDataTypes";
    private static final String FIXED_POINT_TYPE_PROPOSAL_MODE_KEY = "param.FixedPointTypeProposalMode";
    private static final String DEFAULT_PROPOSED_FIXED_POINT_TYPE_KEY = "param.DefaultProposedFixedPointType";
    private static final String MIN_MAX_SAFETY_MARGIN_KEY = "param.MinMaxSafetyMargin";
    private static final String OPTIMIZE_WHOLE_NUMBERS_KEY = "param.OptimizeWholeNumbers";
    private static final String WORD_LENGTH_OPTION_KEY = "option.FixedPointTypeProposalMode.ProposeWordLengths";

    private InstrumentationUtils() {
    }

    public static Param getProposeFixedPointDataTypesParam(Configuration configuration) {
        return configuration.getTarget().getParam(PROPOSE_FIXED_POINT_DATA_TYPES_KEY);
    }

    public static Param getFixedPointTypeProposalModeParam(Configuration configuration) {
        return configuration.getTarget().getParam(FIXED_POINT_TYPE_PROPOSAL_MODE_KEY);
    }

    public static Param getDefaultProposedFixedPointTypeParam(Configuration configuration) {
        return configuration.getTarget().getParam(DEFAULT_PROPOSED_FIXED_POINT_TYPE_KEY);
    }

    public static Param getMinMaxSafetyMarginParam(Configuration configuration) {
        return configuration.getTarget().getParam(MIN_MAX_SAFETY_MARGIN_KEY);
    }

    public static Param getOptimizeWholeNumbersParam(Configuration configuration) {
        return configuration.getTarget().getParam(OPTIMIZE_WHOLE_NUMBERS_KEY);
    }

    public static List<String> convertSettingsToFlags(Configuration configuration) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (configuration.getParamAsBoolean(PROPOSE_FIXED_POINT_DATA_TYPES_KEY)) {
            if (configuration.getParamAsString(FIXED_POINT_TYPE_PROPOSAL_MODE_KEY).equals(WORD_LENGTH_OPTION_KEY)) {
                linkedList.add("-proposeWL");
            } else {
                linkedList.add("-proposeFL");
            }
            String string = configuration.getParamAsString(DEFAULT_PROPOSED_FIXED_POINT_TYPE_KEY);
            if (!string.equals("Remain floating-point")) {
                linkedList.add("-defaultDT");
                linkedList.add(string);
            }
            linkedList.add("-percentSafetyMargin");
            linkedList.add(Integer.toString(configuration.getParamAsInt(MIN_MAX_SAFETY_MARGIN_KEY)));
            if (configuration.getParamAsBoolean(OPTIMIZE_WHOLE_NUMBERS_KEY)) {
                linkedList.add("-optimizeWholeNumbers");
            }
        }
        if (configuration.getParamAsBoolean("param.OpenInstrumentationReportInBrowser")) {
            linkedList.add("-browser");
        }
        if (configuration.getParamAsBoolean("param.CreatePrintableInstrumentationReport")) {
            linkedList.add("-printable");
        }
        return linkedList;
    }

    public static void clearResults(final Configuration configuration) {
        MatlabWorker<MatlabResult> matlabWorker = new MatlabWorker<MatlabResult>(){

            public MatlabResult runOnMatlabThread() throws Exception {
                try {
                    return (MatlabResult)1.feval((String)"clearInstrumentationResults", (Object[])new String[]{configuration.getParamAsString("param.mex.outputfile")}, (int)0, (boolean)false);
                }
                catch (MatlabException matlabException) {
                    InstrumentationUtils.showError(matlabException);
                    return null;
                }
            }

            public void runOnAWTEventDispatchThread(MatlabResult matlabResult) {
            }
        };
        matlabWorker.start();
    }

    public static boolean isInstrumentedMex(Configuration configuration) {
        String string = configuration.getParamAsString("param.artifact");
        return string.equals("option.target.artifact.mex.instrumented");
    }

    public static void showReport(Configuration configuration, final BusyAffordance busyAffordance, String ... stringArray) {
        final LinkedList<String> linkedList = new LinkedList<String>();
        busyAffordance.start();
        busyAffordance.getComponent().setVisible(true);
        linkedList.add(configuration.getParamAsString("param.mex.outputfile"));
        linkedList.addAll(Arrays.asList(stringArray));
        linkedList.addAll(InstrumentationUtils.convertSettingsToFlags(configuration));
        MatlabWorker<MatlabResult> matlabWorker = new MatlabWorker<MatlabResult>(){

            public MatlabResult runOnMatlabThread() throws Exception {
                try {
                    return (MatlabResult)2.feval((String)"showInstrumentationResults", (Object[])linkedList.toArray(new String[linkedList.size()]), (int)0, (boolean)false);
                }
                catch (MatlabException matlabException) {
                    InstrumentationUtils.showError(matlabException);
                    return null;
                }
            }

            public void runOnAWTEventDispatchThread(MatlabResult matlabResult) {
                busyAffordance.stop();
                busyAffordance.getComponent().setVisible(false);
            }
        };
        matlabWorker.start();
    }

    private static void showError(final MatlabException matlabException) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MJOptionPane.showMessageDialog((Component)MLDesktop.getInstance().getMainFrame(), (Object)((Object)new WrappingMessage(matlabException.getLocalizedMessage())), (String)CoderResources.getString("instrumentation.report.error.title"), (int)0);
            }
        });
    }

    private static class WrappingMessage
    extends MJPanel {
        WrappingMessage(String string) {
            this.setLayout(new BorderLayout());
            this.add((Component)new MultilineLabel(string));
        }

        public Dimension getPreferredSize() {
            return new Dimension(375, 100);
        }
    }
}

