/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.net.HttpMessage;
import java.io.Serializable;

public class HttpResponse
extends HttpMessage
implements Cloneable,
Serializable {
    public static final int CONTINUE = 100;
    public static final int SWITCHING_PROTOCOLS = 101;
    public static final int OK = 200;
    public static final int CREATED = 201;
    public static final int ACCEPTED = 202;
    public static final int NON_AUTHORITATIVE_INFORMATION = 203;
    public static final int NO_CONTENT = 204;
    public static final int RESET_CONTENT = 205;
    public static final int PARTIAL_CONTENT = 206;
    public static final int MULTIPLE_CHOICES = 300;
    public static final int MOVED_PERMANENTLY = 301;
    public static final int MOVED_TEMPORARILY = 302;
    public static final int FOUND = 302;
    public static final int SEE_OTHER = 303;
    public static final int NOT_MODIFIED = 304;
    public static final int USE_PROXY = 305;
    public static final int UNUSED = 306;
    public static final int TEMPORARY_REDIRECT = 307;
    public static final int BAD_REQUEST = 400;
    public static final int UNAUTHORIZED = 401;
    public static final int PAYMENT_REQUIRED = 402;
    public static final int FORBIDDEN = 403;
    public static final int NOT_FOUND = 404;
    public static final int METHOD_NOT_ALLOWED = 405;
    public static final int NOT_ACCEPTABLE = 406;
    public static final int PROXY_AUTHENTICATION_REQUIRED = 407;
    public static final int REQUEST_TIMEOUT = 408;
    public static final int CONFLICT = 409;
    public static final int GONE = 410;
    public static final int LENGTH_REQUIRED = 411;
    public static final int PRECONDITION_FAILED = 412;
    public static final int REQUEST_ENTITY_TOO_LARGE = 413;
    public static final int REQUEST_URI_TOO_LONG = 414;
    public static final int UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int REQUESTED_RANGE_NOT_SATISFIABLE = 416;
    public static final int EXPECTATION_FAILED = 417;
    public static final int INTERNAL_SERVER_ERROR = 500;
    public static final int NOT_IMPLEMENTED = 501;
    public static final int BAD_GATEWAY = 502;
    public static final int SERVICE_UNAVAILABLE = 503;
    public static final int GATEWAY_TIMEOUT = 504;
    public static final int HTTP_VERSION_NOT_SUPPORTED = 505;
    public static final String ACCEPT_RANGES = "Accept-Ranges";
    public static final String AGE = "Age";
    public static final String ETAG = "ETag";
    public static final String LOCATION = "Location";
    public static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
    public static final String PUBLIC = "Public";
    public static final String RETRY_AFTER = "Retry-After";
    public static final String SERVER = "Server";
    public static final String TITLE = "Title";
    public static final String VARY = "Vary";
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String REFRESH = "Refresh";
    public static final String SET_COOKIE = "Set-Cookie";
    public static final String SET_COOKIE2 = "Set-Cookie2";
    public static final String PRIVATE = "private";
    public static final String NO_CACHE = "no-cache";
    public static final String NO_STORE = "no-store";
    public static final String NO_TRANSFORM = "no-transform";
    public static final String MUST_REVALIDATE = "must-revalidate";
    public static final String PROXY_REVALIDATE = "proxy-revalidate";
    public static final String MAX_AGE = "max-age";
    public static final String S_MAX_AGE = "s-maxage";
    private int statusCode;
    private String reasonPhrase;

    public HttpResponse(String string, int n, String string2) throws IllegalArgumentException {
        super(string);
        this.setStatusCode(n);
        this.setReasonPhrase(string2);
    }

    public Object clone() {
        HttpResponse httpResponse = (HttpResponse)super.clone();
        return httpResponse;
    }

    public boolean equals(Object object) {
        return object instanceof HttpResponse && ((HttpResponse)object).reasonPhrase.equalsIgnoreCase(this.reasonPhrase) && ((HttpResponse)object).statusCode == this.statusCode && super.equals(object);
    }

    public String getMessage(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getStatusLine() + "\r\n");
        int n = this.headerMap.getSize();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(this.headerMap.getFieldName(n2) + ":" + " " + this.headerMap.getFieldValue(n2) + "\r\n");
            ++n2;
        }
        stringBuffer.append("\r\n");
        if (bl && this.entityBody != null) {
            stringBuffer.append(this.entityBody.toString());
        }
        return stringBuffer.toString();
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusLine() {
        return this.httpVersion + " " + this.statusCode + " " + this.reasonPhrase;
    }

    public void setReasonPhrase(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("reasonPhrase is null");
        }
        this.reasonPhrase = string;
    }

    public void setStatusCode(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("statusCode < 0");
        }
        this.statusCode = n;
    }

    public String toString() {
        return "HttpResponse [" + this.getStatusLine() + "]";
    }
}

