/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.debug.Debug;
import ice.net.HeaderMap;
import ice.util.io.LazyCachedInputStream;
import ice.util.io.MarkerInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

public abstract class HttpMessage
implements Cloneable,
Serializable {
    public static final String CACHE_CONTROL = "Cache-Control";
    public static final String CONNECTION = "Connection";
    public static final String DATE = "Date";
    public static final String PRAGMA = "Pragma";
    public static final String TRAILER = "Trailer";
    public static final String TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String UPGRADE = "Upgrade";
    public static final String VIA = "Via";
    public static final String WARNING = "Warning";
    public static final String KEEP_ALIVE = "Keep-Alive";
    public static final String PROXY_CONNECTION = "Proxy-Connection";
    public static final String HTTP_10 = "HTTP/1.0";
    public static final String HTTP_11 = "HTTP/1.1";
    protected static final String CR_LF = "\r\n";
    protected static final String COLON = ":";
    protected static final String SPACE = " ";
    protected EntityBody entityBody;
    protected HeaderMap headerMap = new HeaderMap();
    protected String httpVersion;

    protected HttpMessage(String string) throws IllegalArgumentException {
        this.setHttpVersion(string);
    }

    public void clearHeaders() {
        this.headerMap.clear();
    }

    public Object clone() {
        try {
            HttpMessage httpMessage = (HttpMessage)super.clone();
            if (this.entityBody != null) {
                httpMessage.entityBody = (EntityBody)this.entityBody.clone();
            }
            httpMessage.headerMap = (HeaderMap)this.headerMap.clone();
            return httpMessage;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean containsHeader(String string) {
        return this.headerMap.containsFieldName(string);
    }

    public void dispose() {
        if (this.entityBody != null) {
            this.entityBody.dispose();
        }
    }

    public boolean equals(Object object) {
        return object instanceof HttpMessage && ((HttpMessage)object).httpVersion.equalsIgnoreCase(this.httpVersion) && ((HttpMessage)object).headerMap.equals(this.headerMap) && ((HttpMessage)object).entityBody == null ? this.entityBody == null : ((HttpMessage)object).entityBody.equals(this.entityBody);
    }

    public byte[] getBytes() {
        byte[] byArray = this.getMessage(false).getBytes();
        if (this.entityBody != null) {
            byte[] byArray2 = this.entityBody.getBytes();
            byte[] byArray3 = byArray;
            byArray = new byte[byArray3.length + byArray2.length];
            System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
            System.arraycopy(byArray2, 0, byArray, byArray3.length, byArray2.length);
        }
        return byArray;
    }

    public EntityBody getEntityBody() {
        return this.entityBody;
    }

    public HeaderMap.Header getHeader(int n) {
        return this.headerMap.get(n);
    }

    public int getHeaderCount() {
        return this.headerMap.getSize();
    }

    public String getFieldName(int n) {
        return this.headerMap.getFieldName(n);
    }

    public String getFieldValue(int n) {
        return this.headerMap.getFieldValue(n);
    }

    public String[] getFieldValues(String string) {
        return this.headerMap.getFieldValues(string);
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public int getLength() {
        return this.getBytes().length;
    }

    public String getMessage() {
        return this.getMessage(false);
    }

    public abstract String getMessage(boolean var1);

    public void putHeader(String string, String string2) {
        this.headerMap.putHeader(string, string2);
    }

    public void removeHeader(int n) {
        this.headerMap.removeHeader(n);
    }

    public void removeHeaders(String string) {
        this.headerMap.removeHeaders(string);
    }

    public void setEntityBody(EntityBody entityBody) {
        this.entityBody = entityBody;
    }

    public void setHttpVersion(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("httpVersion is null");
        }
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException("httpVersion is empty");
        }
        this.httpVersion = string;
    }

    public static class EntityBody
    implements Cloneable,
    Serializable {
        public static final String ALLOW = "Allow";
        public static final String CONTENT_BASE = "Content-Base";
        public static final String CONTENT_ENCODING = "Content-Encoding";
        public static final String CONTENT_LANGUAGE = "Content-Language";
        public static final String CONTENT_LENGTH = "Content-Length";
        public static final String CONTENT_LOCATION = "Content-Location";
        public static final String CONTENT_MD5 = "Content-MD5";
        public static final String CONTENT_RANGE = "Content-Range";
        public static final String CONTENT_TYPE = "Content-Type";
        public static final String EXPIRES = "Expires";
        public static final String LAST_MODIFIED = "Last-Modified";
        protected byte[] bytes;
        protected InputStream inputStream;

        public EntityBody(byte[] byArray) throws IllegalArgumentException {
            if (byArray == null) {
                throw new IllegalArgumentException("bytes is null");
            }
            this.bytes = byArray;
        }

        public EntityBody(InputStream inputStream) throws IllegalArgumentException {
            if (inputStream == null) {
                throw new IllegalArgumentException("inputStream is null");
            }
            this.inputStream = new LazyCachedInputStream(inputStream);
        }

        public Object clone() {
            try {
                EntityBody entityBody = (EntityBody)super.clone();
                return entityBody;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }

        public void dispose() {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                }
                catch (IOException iOException) {
                    Debug.ex((Throwable)iOException);
                }
            }
        }

        public boolean equals(Object object) {
            return true;
        }

        public byte[] getBytes() {
            if (this.bytes == null) {
                try {
                    byte by;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    InputStream inputStream = this.getInputStream();
                    while ((by = (byte)inputStream.read()) != -1) {
                        byteArrayOutputStream.write(by);
                    }
                    this.bytes = byteArrayOutputStream.toByteArray();
                }
                catch (IOException iOException) {
                    Debug.ex((Throwable)iOException);
                }
            }
            return this.bytes;
        }

        public InputStream getInputStream() {
            if (this.inputStream == null) {
                this.inputStream = new LazyCachedInputStream((InputStream)new ByteArrayInputStream(this.bytes));
            }
            return new MarkerInputStream((LazyCachedInputStream)this.inputStream);
        }

        public String toString() {
            return new String(this.getBytes());
        }
    }
}

