/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.net.ConnectionManager;
import ice.util.Defs;
import ice.util.Settings;
import java.io.Serializable;

public class ConnectionManagerSettings
implements Serializable,
Settings {
    private int maxPersistentConnections;
    private boolean nagleEnabled;
    private boolean persistentConnectionsEnabled;
    private int persistentConnectionTimeout;
    private int readBufferSize;
    private int soTimeout;
    Object instancesLock = new Object();
    int instancesInUse = 0;

    public ConnectionManagerSettings() {
        this.OEAB();
    }

    public static boolean areDefaultPersistentConnectionsEnabled() {
        return Defs.sysPropertyBoolean((String)"ice.net.persistentConnectionsEnabled", (boolean)true);
    }

    public boolean arePersistentConnectionsEnabled() {
        return this.persistentConnectionsEnabled;
    }

    public boolean equals(Object object) {
        return object instanceof ConnectionManagerSettings && ((ConnectionManagerSettings)object).maxPersistentConnections == this.maxPersistentConnections && ((ConnectionManagerSettings)object).nagleEnabled == this.nagleEnabled && ((ConnectionManagerSettings)object).persistentConnectionsEnabled == this.persistentConnectionsEnabled && ((ConnectionManagerSettings)object).persistentConnectionTimeout == this.persistentConnectionTimeout && ((ConnectionManagerSettings)object).readBufferSize == this.readBufferSize && ((ConnectionManagerSettings)object).soTimeout == this.soTimeout;
    }

    public static int getDefaultMaxPersistentConnections() {
        return Defs.sysPropertyInt((String)"ice.net.maxPersistentConnections", (int)4);
    }

    public static int getDefaultPersistentConnectionTimeout() {
        return Defs.sysPropertyInt((String)"ice.net.persistentConnectionTimeout", (int)15);
    }

    public static int getDefaultReadBufferSize() {
        return Defs.sysPropertyInt((String)"ice.net.readBufferSize", (int)4096);
    }

    public static int getDefaultSoTimeout() {
        return Defs.sysPropertyInt((String)"ice.net.soTimeout", (int)0);
    }

    public int getMaxPersistentConnections() {
        return this.maxPersistentConnections;
    }

    public int getPersistentConnectionTimeout() {
        return this.persistentConnectionTimeout;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public static boolean isDefaultNagleEnabled() {
        return Defs.sysPropertyBoolean((String)"ice.net.nagleEnabled", (boolean)true);
    }

    public boolean isNagleEnabled() {
        return this.nagleEnabled;
    }

    public void resetToDefault() {
        this.OEAB();
    }

    public static void setDefaultMaxPersistentConnections(int n) throws IllegalArgumentException {
        ConnectionManager.checkMaxPersistentConnections(n);
        Defs.setSystemProperty((String)"ice.net.maxPersistentConnections", (String)Integer.toString(n));
    }

    public static void setDefaultNagleEnabled(boolean bl) {
        Defs.setSystemProperty((String)"ice.net.nagleEnabled", (String)new Boolean(bl).toString());
    }

    public static void setDefaultPersistentConnectionsEnabled(boolean bl) {
        Defs.setSystemProperty((String)"ice.net.persistentConnectionsEnabled", (String)new Boolean(bl).toString());
    }

    public static void setDefaultPersistentConnectionTimeout(int n) throws IllegalArgumentException {
        ConnectionManager.checkPersistentConnectionTimeout(n);
        Defs.setSystemProperty((String)"ice.net.persistentConnectionTimeout", (String)Integer.toString(n));
    }

    public static void setDefaultReadBufferSize(int n) throws IllegalArgumentException {
        ConnectionManager.checkReadBufferSize(n);
        Defs.setSystemProperty((String)"ice.net.readBufferSize", (String)Integer.toString(n));
    }

    public static void setDefaultSoTimeout(int n) throws IllegalArgumentException {
        ConnectionManager.checkSoTimeout(n);
        Defs.setSystemProperty((String)"ice.net.soTimeout", (String)Integer.toString(0));
    }

    public void setMaxPersistentConnections(int n) throws IllegalArgumentException {
        ConnectionManager.checkMaxPersistentConnections(n);
        this.maxPersistentConnections = n;
    }

    public void setNagleEnabled(boolean bl) {
        this.nagleEnabled = bl;
    }

    public void setPersistentConnectionsEnabled(boolean bl) {
        this.persistentConnectionsEnabled = bl;
    }

    public void setPersistentConnectionTimeout(int n) throws IllegalArgumentException {
        ConnectionManager.checkPersistentConnectionTimeout(n);
        this.persistentConnectionTimeout = n;
    }

    public void setReadBufferSize(int n) throws IllegalArgumentException {
        ConnectionManager.checkReadBufferSize(n);
        this.readBufferSize = n;
    }

    public void setSoTimeout(int n) throws IllegalArgumentException {
        ConnectionManager.checkSoTimeout(n);
        this.soTimeout = n;
    }

    public String toString() {
        return "ConnectionManagerSettings [maxPersistentConnections: " + this.maxPersistentConnections + ", " + "nagleEnabled: " + this.nagleEnabled + ", " + "persistentConnectionsEnabled: " + this.persistentConnectionsEnabled + ", " + "persistentConnectionTimeout: " + this.persistentConnectionTimeout + ", " + "readBufferSize: " + this.readBufferSize + ", " + "soTimeout: " + this.soTimeout + "]";
    }

    private void OEAB() {
        this.maxPersistentConnections = ConnectionManagerSettings.getDefaultMaxPersistentConnections();
        this.nagleEnabled = ConnectionManagerSettings.isDefaultNagleEnabled();
        this.persistentConnectionsEnabled = ConnectionManagerSettings.areDefaultPersistentConnectionsEnabled();
        this.persistentConnectionTimeout = ConnectionManagerSettings.getDefaultPersistentConnectionTimeout();
        this.readBufferSize = ConnectionManagerSettings.getDefaultReadBufferSize();
        this.soTimeout = ConnectionManagerSettings.getDefaultSoTimeout();
    }
}

