/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.FontUtils;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.StyleRange;
import com.jidesoft.swing.StyledLabel;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.View;

public class BasicStyledLabelUI
extends BasicLabelUI
implements SwingConstants {
    public static Comparator<StyleRange> _comparator;
    protected static BasicStyledLabelUI styledLabelUI;
    private final List<StyledText> _styledTexts = new ArrayList<StyledText>();

    public static ComponentUI createUI(JComponent jComponent) {
        return styledLabelUI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        if ("styleRange".equals(propertyChangeEvent.getPropertyName())) {
            List<StyledText> list = this._styledTexts;
            synchronized (list) {
                this._styledTexts.clear();
            }
            if (propertyChangeEvent.getSource() instanceof StyledLabel) {
                ((StyledLabel)propertyChangeEvent.getSource()).revalidate();
                ((StyledLabel)propertyChangeEvent.getSource()).repaint();
            }
        } else if ("ignoreColorSettings".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getSource() instanceof StyledLabel) {
            ((StyledLabel)propertyChangeEvent.getSource()).repaint();
        }
    }

    protected void paintEnabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        View view;
        View view2 = view = jLabel != null ? (View)jLabel.getClientProperty("html") : null;
        if (view != null) {
            super.paintEnabledText(jLabel, graphics, string, n, n2);
        } else {
            this.paintStyledText((StyledLabel)jLabel, graphics, n, n2);
        }
    }

    protected void paintDisabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        View view;
        View view2 = view = jLabel != null ? (View)jLabel.getClientProperty("html") : null;
        if (view != null) {
            super.paintDisabledText(jLabel, graphics, string, n, n2);
        } else {
            this.paintStyledText((StyledLabel)jLabel, graphics, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildStyledText(StyledLabel styledLabel) {
        List<StyledText> list = this._styledTexts;
        synchronized (list) {
            this._styledTexts.clear();
            StyleRange[] styleRangeArray = styledLabel.getStyleRanges();
            if (_comparator == null) {
                _comparator = new Comparator<StyleRange>(){

                    @Override
                    public int compare(StyleRange styleRange, StyleRange styleRange2) {
                        if (styleRange.getStart() < styleRange2.getStart()) {
                            return -1;
                        }
                        if (styleRange.getStart() > styleRange2.getStart()) {
                            return 1;
                        }
                        return 0;
                    }
                };
            }
            Arrays.sort(styleRangeArray, _comparator);
            String string = styledLabel.getText();
            if (string != null && string.length() > 0) {
                int n = 0;
                for (StyleRange styleRange : styleRangeArray) {
                    if (styleRange.getStart() > n) {
                        this._styledTexts.add(new StyledText(string.substring(n, styleRange.getStart())));
                        n = styleRange.getStart();
                    }
                    if (styleRange.getStart() == n) {
                        if (styleRange.getLength() == -1) {
                            this._styledTexts.add(new StyledText(string.substring(n), styleRange));
                            n = string.length();
                            continue;
                        }
                        this._styledTexts.add(new StyledText(string.substring(n, Math.min(n + styleRange.getLength(), string.length())), styleRange));
                        n += styleRange.getLength();
                        continue;
                    }
                    if (styleRange.getStart() >= n) continue;
                }
                if (n < string.length()) {
                    this._styledTexts.add(new StyledText(string.substring(n, string.length())));
                }
            }
        }
    }

    protected String layoutCL(JLabel jLabel, FontMetrics fontMetrics, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        Dimension dimension = this.getPreferredSize((StyledLabel)jLabel);
        rectangle3.width = dimension.width;
        rectangle3.height = dimension.height;
        return BasicStyledLabelUI.layoutCompoundLabel(jLabel, fontMetrics, string, icon, jLabel.getVerticalAlignment(), jLabel.getHorizontalAlignment(), jLabel.getVerticalTextPosition(), jLabel.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, jLabel.getIconTextGap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dimension getPreferredSize(StyledLabel styledLabel) {
        this.buildStyledText(styledLabel);
        int n = 0;
        Font font = this.getFont(styledLabel);
        FontMetrics fontMetrics = styledLabel.getFontMetrics(font);
        int n2 = 0;
        int n3 = font.getSize();
        List<StyledText> list = this._styledTexts;
        synchronized (list) {
            StyledText[] styledTextArray = this._styledTexts.toArray(new StyledText[this._styledTexts.size()]);
            for (int i = styledTextArray.length - 1; i >= 0; --i) {
                StyledText styledText = styledTextArray[i];
                StyleRange styleRange = styledText.styleRange;
                int n4 = styleRange != null && (styleRange.isSuperscript() || styleRange.isSubscript()) ? Math.round((float)n3 / styleRange.getFontShrinkRatio()) : n3;
                font = this.getFont(styledLabel);
                if (styleRange != null && (styleRange.getFontStyle() != -1 && font.getStyle() != styleRange.getFontStyle() || font.getSize() != n4)) {
                    font = FontUtils.getCachedDerivedFont(font, styleRange.getFontStyle() == -1 ? font.getStyle() : styleRange.getFontStyle(), n4);
                    FontMetrics fontMetrics2 = styledLabel.getFontMetrics(font);
                    n += fontMetrics2.stringWidth(styledText.text);
                } else {
                    n += fontMetrics.stringWidth(styledText.text);
                }
                if (styleRange == null) continue;
                if (styleRange.isUnderlined() && n2 < 2) {
                    n2 = 2;
                }
                if (styleRange.isDotted() && n2 < 3) {
                    n2 = 3;
                }
                if (!styleRange.isWaved() || n2 >= 4) continue;
                n2 = 4;
            }
        }
        int n5 = fontMetrics.getHeight();
        return new Dimension(n, n5 + n2);
    }

    protected Font getFont(StyledLabel styledLabel) {
        Font font = styledLabel.getFont();
        if (font == null) {
            font = UIDefaultsLookup.getFont("Label.font");
        }
        return font;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintStyledText(StyledLabel styledLabel, Graphics graphics, int n, int n2) {
        int n3 = n < styledLabel.getInsets().left ? styledLabel.getInsets().left : n;
        int n4 = styledLabel.getDisplayedMnemonicIndex();
        if (UIManager.getLookAndFeel() instanceof WindowsLookAndFeel && WindowsLookAndFeel.isMnemonicHidden()) {
            n4 = -1;
        }
        this.buildStyledText(styledLabel);
        Color color = graphics.getColor();
        int n5 = 0;
        int n6 = 0;
        Font font = this.getFont(styledLabel);
        FontMetrics fontMetrics = styledLabel.getFontMetrics(font);
        FontMetrics fontMetrics2 = null;
        int n7 = font.getSize();
        List<StyledText> list = this._styledTexts;
        synchronized (list) {
            for (int i = 0; i < this._styledTexts.size(); ++i) {
                int n8;
                Object object;
                Object object2;
                FontMetrics fontMetrics3;
                boolean bl;
                StyledText styledText = this._styledTexts.get(i);
                StyleRange styleRange = styledText.styleRange;
                if (n4 >= 0 && styledText.text.length() > n4 - n5) {
                    bl = true;
                    n6 = n4 - n5;
                } else {
                    bl = false;
                }
                n5 += styledText.text.length();
                int n9 = n2;
                if (fontMetrics2 == null) {
                    int n10 = styleRange != null && (styleRange.isSuperscript() || styleRange.isSubscript()) ? Math.round((float)n7 / styleRange.getFontShrinkRatio()) : n7;
                    font = this.getFont(styledLabel);
                    if (styleRange != null && (styleRange.getFontStyle() != -1 && font.getStyle() != styleRange.getFontStyle() || font.getSize() != n10)) {
                        font = FontUtils.getCachedDerivedFont(font, styleRange.getFontStyle() == -1 ? font.getStyle() : styleRange.getFontStyle(), n10);
                        fontMetrics3 = styledLabel.getFontMetrics(font);
                    } else {
                        fontMetrics3 = fontMetrics;
                    }
                } else {
                    fontMetrics3 = fontMetrics2;
                }
                graphics.setFont(font);
                String string = styledText.text;
                int n11 = fontMetrics3.stringWidth(string);
                boolean bl2 = false;
                int n12 = styledLabel.getWidth() - n3;
                if (n12 < n11) {
                    string = SwingUtilities.layoutCompoundLabel(styledLabel, fontMetrics3, string, null, styledLabel.getVerticalAlignment(), styledLabel.getHorizontalAlignment(), styledLabel.getVerticalTextPosition(), styledLabel.getHorizontalTextPosition(), new Rectangle(n3, n9, n12, styledLabel.getHeight()), new Rectangle(), new Rectangle(), 0);
                    n11 = fontMetrics3.stringWidth(string);
                    bl2 = true;
                } else if (i < this._styledTexts.size() - 1) {
                    String string2;
                    object2 = this._styledTexts.get(i + 1);
                    object = ((StyledText)object2).text;
                    StyleRange styleRange2 = ((StyledText)object2).styleRange;
                    n8 = styleRange2 != null && (styleRange2.isSuperscript() || styleRange2.isSubscript()) ? Math.round((float)n7 / styleRange2.getFontShrinkRatio()) : n7;
                    font = this.getFont(styledLabel);
                    if (styleRange2 != null && (styleRange2.getFontStyle() != -1 && font.getStyle() != styleRange2.getFontStyle() || font.getSize() != n8)) {
                        font = FontUtils.getCachedDerivedFont(font, styleRange2.getFontStyle() == -1 ? font.getStyle() : styleRange2.getFontStyle(), n8);
                        fontMetrics2 = styledLabel.getFontMetrics(font);
                    } else {
                        fontMetrics2 = fontMetrics;
                    }
                    if (fontMetrics2.stringWidth((String)object) > n12 - n11 && fontMetrics2.stringWidth(string2 = SwingUtilities.layoutCompoundLabel(styledLabel, fontMetrics2, (String)object, null, styledLabel.getVerticalAlignment(), styledLabel.getHorizontalAlignment(), styledLabel.getVerticalTextPosition(), styledLabel.getHorizontalTextPosition(), new Rectangle(n3 + n11, n9, n12 - n11, styledLabel.getHeight()), new Rectangle(), new Rectangle(), 0)) > n12 - n11) {
                        string = SwingUtilities.layoutCompoundLabel(styledLabel, fontMetrics3, string, null, styledLabel.getVerticalAlignment(), styledLabel.getHorizontalAlignment(), styledLabel.getVerticalTextPosition(), styledLabel.getHorizontalTextPosition(), new Rectangle(n3, n9, n11 - 1, styledLabel.getHeight()), new Rectangle(), new Rectangle(), 0);
                        n11 = fontMetrics3.stringWidth(string);
                        bl2 = true;
                    }
                }
                if (styleRange != null && styleRange.isSuperscript()) {
                    n9 -= fontMetrics.getHeight() - fontMetrics3.getHeight();
                }
                if (styleRange != null && styleRange.getBackgroundColor() != null) {
                    graphics.setColor(styleRange.getBackgroundColor());
                    graphics.fillRect(n3, n9 - fontMetrics3.getHeight(), n11, fontMetrics3.getHeight() + 4);
                }
                Object object3 = object2 = styleRange != null && !styledLabel.isIgnoreColorSettings() && styleRange.getFontColor() != null ? styleRange.getFontColor() : styledLabel.getForeground();
                if (!styledLabel.isEnabled()) {
                    object2 = UIDefaultsLookup.getColor("Label.disabledForeground");
                }
                graphics.setColor((Color)object2);
                if (bl) {
                    JideSwingUtilities.drawStringUnderlineCharAt(styledLabel, graphics, string, n6, n3, n9);
                } else {
                    JideSwingUtilities.drawString(styledLabel, graphics, string, n3, n9);
                }
                if (styleRange != null) {
                    object = ((Graphics2D)graphics).getStroke();
                    if (styleRange.getLineStroke() != null) {
                        ((Graphics2D)graphics).setStroke(styleRange.getLineStroke());
                    }
                    if (!styledLabel.isIgnoreColorSettings() && styleRange.getLineColor() != null) {
                        graphics.setColor(styleRange.getLineColor());
                    }
                    if (styleRange.isStrikethrough()) {
                        int n13 = n9 + (fontMetrics3.getDescent() - fontMetrics3.getAscent()) / 2;
                        graphics.drawLine(n3, n13, n3 + n11 - 1, n13);
                    }
                    if (styleRange.isDoublestrikethrough()) {
                        int n14 = n9 + (fontMetrics3.getDescent() - fontMetrics3.getAscent()) / 2;
                        graphics.drawLine(n3, n14 - 1, n3 + n11 - 1, n14 - 1);
                        graphics.drawLine(n3, n14 + 1, n3 + n11 - 1, n14 + 1);
                    }
                    if (styleRange.isUnderlined()) {
                        int n15 = n9 + 1;
                        graphics.drawLine(n3, n15, n3 + n11 - 1, n15);
                    }
                    if (styleRange.isDotted()) {
                        int n16 = n9 + 1;
                        for (n8 = n3; n8 < n3 + n11; n8 += 4) {
                            graphics.drawRect(n8, n16, 1, 1);
                        }
                    }
                    if (styleRange.isWaved()) {
                        int n17 = n9 + 1;
                        for (n8 = n3; n8 < n3 + n11; n8 += 4) {
                            if (n8 + 2 <= n3 + n11 - 1) {
                                graphics.drawLine(n8, n17 + 2, n8 + 2, n17);
                            }
                            if (n8 + 4 > n3 + n11 - 1) continue;
                            graphics.drawLine(n8 + 3, n17 + 1, n8 + 4, n17 + 2);
                        }
                    }
                    if (styleRange.getLineStroke() != null) {
                        ((Graphics2D)graphics).setStroke((Stroke)object);
                    }
                }
                if (bl2) break;
                n3 += n11;
            }
        }
        graphics.setColor(color);
    }

    public static String layoutCompoundLabel(JComponent jComponent, FontMetrics fontMetrics, String string, Icon icon, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        boolean bl = true;
        int n6 = n2;
        int n7 = n4;
        if (jComponent != null && !jComponent.getComponentOrientation().isLeftToRight()) {
            bl = false;
        }
        switch (n2) {
            case 10: {
                n6 = bl ? 2 : 4;
                break;
            }
            case 11: {
                n6 = bl ? 4 : 2;
            }
        }
        switch (n4) {
            case 10: {
                n7 = bl ? 2 : 4;
                break;
            }
            case 11: {
                n7 = bl ? 4 : 2;
            }
        }
        return BasicStyledLabelUI.layoutCompoundLabelImpl(jComponent, fontMetrics, string, icon, n, n6, n3, n7, rectangle, rectangle2, rectangle3, n5);
    }

    public static String layoutCompoundLabel(FontMetrics fontMetrics, String string, Icon icon, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        return BasicStyledLabelUI.layoutCompoundLabelImpl(null, fontMetrics, string, icon, n, n2, n3, n4, rectangle, rectangle2, rectangle3, n5);
    }

    private static String layoutCompoundLabelImpl(JComponent jComponent, FontMetrics fontMetrics, String string, Icon icon, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        int n6;
        int n7;
        if (icon != null) {
            rectangle2.width = icon.getIconWidth();
            rectangle2.height = icon.getIconHeight();
        } else {
            rectangle2.height = 0;
            rectangle2.width = 0;
        }
        boolean bl = string == null || string.equals("");
        int n8 = 0;
        if (bl) {
            rectangle3.height = 0;
            rectangle3.width = 0;
            string = "";
            n7 = 0;
        } else {
            View view;
            n7 = icon == null ? 0 : n5;
            n6 = n4 == 0 ? rectangle.width : rectangle.width - (rectangle2.width + n7);
            View view2 = view = jComponent != null ? (View)jComponent.getClientProperty("html") : null;
            if (view != null) {
                rectangle3.width = Math.min(n6, (int)view.getPreferredSpan(0));
                rectangle3.height = (int)view.getPreferredSpan(1);
            }
        }
        rectangle3.y = n3 == 1 ? (n4 != 0 ? 0 : -(rectangle3.height + n7)) : (n3 == 0 ? rectangle2.height / 2 - rectangle3.height / 2 : (n4 != 0 ? rectangle2.height - rectangle3.height : rectangle2.height + n7));
        rectangle3.x = n4 == 2 ? -(rectangle3.width + n7) : (n4 == 0 ? rectangle2.width / 2 - rectangle3.width / 2 : rectangle2.width + n7);
        n6 = Math.min(rectangle2.x, rectangle3.x);
        int n9 = Math.max(rectangle2.x + rectangle2.width, rectangle3.x + rectangle3.width) - n6;
        int n10 = Math.min(rectangle2.y, rectangle3.y);
        int n11 = Math.max(rectangle2.y + rectangle2.height, rectangle3.y + rectangle3.height) - n10;
        int n12 = n == 1 ? rectangle.y - n10 : (n == 0 ? rectangle.y + rectangle.height / 2 - (n10 + n11 / 2) : rectangle.y + rectangle.height - (n10 + n11));
        int n13 = n2 == 2 ? rectangle.x - n6 : (n2 == 4 ? rectangle.x + rectangle.width - (n6 + n9) : rectangle.x + rectangle.width / 2 - (n6 + n9 / 2));
        rectangle3.x += n13;
        rectangle3.y += n12;
        rectangle2.x += n13;
        rectangle2.y += n12;
        if (n8 < 0) {
            rectangle3.x -= n8;
        }
        return string;
    }

    static {
        styledLabelUI = new BasicStyledLabelUI();
    }

    class StyledText {
        StyleRange styleRange;
        String text;

        public StyledText(String string) {
            this.text = string;
        }

        public StyledText(String string, StyleRange styleRange) {
            this.text = string;
            this.styleRange = styleRange;
        }
    }
}

