/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicJideButtonUI;
import com.jidesoft.plaf.basic.LazyActionMap;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.plaf.basic.UIAction;
import com.jidesoft.plaf.vsnet.VsnetMenuUI;
import com.jidesoft.swing.ComponentStateSupport;
import com.jidesoft.swing.DefaultSplitButtonModel;
import com.jidesoft.swing.JideSplitButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.SplitButtonModel;
import com.jidesoft.utils.SecurityUtils;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.View;

public class BasicJideSplitButtonUI
extends VsnetMenuUI {
    protected ThemePainter _painter;
    protected Color _shadowColor;
    protected Color _darkShadowColor;
    protected Color _highlight;
    protected Color _lightHighlightColor;
    protected int _splitButtonMargin = 12;
    protected int _splitButtonMarginOnMenu = 20;
    protected boolean _isFloatingIcon = false;
    private FocusListener _focusListener;
    private static final String propertyPrefix = "JideSplitButton";

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicJideSplitButtonUI();
    }

    protected String getPropertyPrefix() {
        return propertyPrefix;
    }

    protected void installDefaults() {
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        this._isFloatingIcon = UIDefaultsLookup.getBoolean("Icon.floating");
        this._shadowColor = UIDefaultsLookup.getColor("JideButton.shadow");
        this._darkShadowColor = UIDefaultsLookup.getColor("JideButton.darkShadow");
        this._highlight = UIDefaultsLookup.getColor("JideButton.highlight");
        this._lightHighlightColor = UIDefaultsLookup.getColor("JideButton.light");
        this.menuItem.setRolloverEnabled(true);
        super.installDefaults();
    }

    protected void uninstallDefaults() {
        this._painter = null;
        this._shadowColor = null;
        this._highlight = null;
        this._lightHighlightColor = null;
        this._darkShadowColor = null;
        super.uninstallDefaults();
    }

    protected void installListeners() {
        super.installListeners();
        if (this._focusListener == null) {
            this._focusListener = new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    BasicJideSplitButtonUI.this.menuItem.repaint();
                }

                public void focusLost(FocusEvent focusEvent) {
                    BasicJideSplitButtonUI.this.menuItem.repaint();
                }
            };
        }
        this.menuItem.addFocusListener(this._focusListener);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this._focusListener != null) {
            this.menuItem.removeFocusListener(this._focusListener);
        }
    }

    static Object getUIOfType(ComponentUI componentUI, Class clazz) {
        if (clazz.isInstance(componentUI)) {
            return componentUI;
        }
        return null;
    }

    public InputMap getInputMap(int n, JComponent jComponent) {
        BasicJideSplitButtonUI basicJideSplitButtonUI;
        if (n == 0 && (basicJideSplitButtonUI = (BasicJideSplitButtonUI)BasicJideSplitButtonUI.getUIOfType(((JideSplitButton)jComponent).getUI(), BasicJideSplitButtonUI.class)) != null) {
            return (InputMap)UIDefaultsLookup.get(basicJideSplitButtonUI.getPropertyPrefix() + ".focusInputMap");
        }
        return null;
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        JMenuItem jMenuItem = this.menuItem;
        LazyActionMap.installLazyActionMap(jMenuItem, BasicJideSplitButtonUI.class, "JideSplitButton.actionMap");
        InputMap inputMap = this.getInputMap(0, jMenuItem);
        SwingUtilities.replaceUIInputMap(jMenuItem, 0, inputMap);
    }

    protected void uninstallKeyboardActions() {
        JMenuItem jMenuItem = this.menuItem;
        SwingUtilities.replaceUIInputMap(jMenuItem, 2, null);
        SwingUtilities.replaceUIInputMap(jMenuItem, 0, null);
        SwingUtilities.replaceUIActionMap(jMenuItem, null);
        super.uninstallKeyboardActions();
    }

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new MouseInputHandler();
    }

    protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color) {
        JideSplitButton jideSplitButton;
        int n;
        int n2;
        ButtonModel buttonModel = jMenuItem.getModel();
        int n3 = JideSwingUtilities.getOrientationOf(jMenuItem);
        if (n3 == 0) {
            n2 = jMenuItem.getWidth();
            n = jMenuItem.getHeight();
        } else {
            n2 = jMenuItem.getHeight();
            n = jMenuItem.getWidth();
        }
        n3 = 0;
        Object object = jMenuItem.getClientProperty("JideSplitButton.alwaysPaintBackground");
        boolean bl = object instanceof Boolean ? ((Boolean)object).booleanValue() : jMenuItem.isOpaque();
        if (!((JMenu)jMenuItem).isTopLevelMenu()) {
            super.paintBackground(graphics, jMenuItem, color);
            if (jMenuItem.isEnabled()) {
                if (buttonModel.isArmed() || buttonModel.isPressed() || this.isMouseOver()) {
                    graphics.setColor(this.selectionForeground);
                    graphics.drawLine(n2 - this._splitButtonMarginOnMenu, 0, n2 - this._splitButtonMarginOnMenu, n - 2);
                    JideSwingUtilities.paintArrow(graphics, this.selectionForeground, n2 - this._splitButtonMarginOnMenu / 2 - 2, n / 2 - 3, 7, 1);
                } else {
                    graphics.setColor(this.getForegroundOfState(jMenuItem));
                    graphics.drawLine(n2 - this._splitButtonMarginOnMenu, 0, n2 - this._splitButtonMarginOnMenu, n - 2);
                    JideSwingUtilities.paintArrow(graphics, this.getForegroundOfState(jMenuItem), n2 - this._splitButtonMarginOnMenu / 2 - 2, n / 2 - 3, 7, 1);
                }
            } else {
                graphics.setColor(UIDefaultsLookup.getColor("controlDkShadow"));
                graphics.drawLine(n2 - this._splitButtonMarginOnMenu, 0, n2 - this._splitButtonMarginOnMenu, n - 2);
                JideSwingUtilities.paintArrow(graphics, UIDefaultsLookup.getColor("controlDkShadow"), n2 - this._splitButtonMarginOnMenu / 2 - 2, n / 2 - 3, 7, 1);
            }
            return;
        }
        if (bl) {
            if (jMenuItem.getParent() != null) {
                graphics.setColor(jMenuItem.getParent().getBackground());
            } else {
                graphics.setColor(jMenuItem.getBackground());
            }
            graphics.fillRect(0, 0, n2, n);
        }
        if ((jideSplitButton = (JideSplitButton)jMenuItem).getButtonStyle() == 0) {
            if (buttonModel.isSelected()) {
                if (this.isAlwaysDropdown(jideSplitButton)) {
                    Rectangle rectangle = new Rectangle(0, 0, n2, n);
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n3, 2);
                } else if (jideSplitButton.getClientProperty("JButton.segmentPosition") != null) {
                    Rectangle rectangle = this.getButtonRect(jideSplitButton, n3, n2, n);
                    if (jideSplitButton.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n3, 2);
                    } else if (bl) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n3, 6);
                    }
                    rectangle = this.getDropDownRect(jideSplitButton, n3, n2, n);
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n3, 1);
                } else {
                    Rectangle rectangle = this.getButtonRect(jideSplitButton, n3, n2, n);
                    if (jideSplitButton.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n3, 3);
                    } else if (bl) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n3, 5);
                    }
                    rectangle = this.getDropDownRect(jideSplitButton, n3, n2, n);
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n3, 3);
                    this.getPainter().paintSelectedMenu(jideSplitButton, graphics, new Rectangle(0, 0, n2, n), n3, 3);
                }
            } else if (buttonModel.isArmed() || buttonModel.isPressed()) {
                Rectangle rectangle = this.getButtonRect(jideSplitButton, n3, n2, n);
                if (jideSplitButton.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n3, 1);
                } else if (bl) {
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n3, 4);
                }
                rectangle = this.getDropDownRect(jideSplitButton, n3, n2, n);
                this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n3, 2);
            } else if (buttonModel instanceof SplitButtonModel && ((DefaultSplitButtonModel)buttonModel).isButtonSelected()) {
                if ((this.isMouseOver() || jideSplitButton.hasFocus()) && buttonModel.isEnabled()) {
                    Rectangle rectangle = this.getDropDownRect(jideSplitButton, n3, n2, n);
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n3, 2);
                    rectangle = this.getButtonRect(jideSplitButton, n3, n2, n);
                    if (jideSplitButton.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n3, 1);
                    } else if (bl) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n3, 4);
                    }
                } else {
                    Rectangle rectangle = this.getDropDownRect(jideSplitButton, n3, n2, n);
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n3, 0);
                    rectangle = this.getButtonRect(jideSplitButton, n3, n2, n);
                    if (jideSplitButton.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n3, 3);
                    } else if (bl) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n3, 5);
                    }
                }
            } else if ((jideSplitButton.isRolloverEnabled() && this.isMouseOver() || jideSplitButton.hasFocus()) && buttonModel.isEnabled()) {
                if (this.isAlwaysDropdown(jideSplitButton)) {
                    Rectangle rectangle = new Rectangle(0, 0, n2, n);
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n3, 2);
                } else {
                    Rectangle rectangle = this.getButtonRect(jideSplitButton, n3, n2, n);
                    if (jideSplitButton.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n3, 2);
                    } else if (bl) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n3, 6);
                    }
                    rectangle = this.getDropDownRect(jideSplitButton, n3, n2, n);
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n3, 2);
                }
            } else if (bl) {
                Rectangle rectangle = this.getButtonRect(jideSplitButton, n3, n2, n);
                if (jideSplitButton.isEnabled() && jideSplitButton.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, 0, 0);
                } else {
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, 0, 4);
                }
                if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                    JideSwingUtilities.fillGradient(graphics, rectangle, 0);
                }
                rectangle = this.getDropDownRect(jideSplitButton, n3, n2, n);
                if (jideSplitButton.isEnabled()) {
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, 0, 0);
                } else {
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, 0, 4);
                }
                if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                    JideSwingUtilities.fillGradient(graphics, rectangle, 0);
                }
            }
        } else if (jideSplitButton.getButtonStyle() == 2) {
            if (buttonModel.isSelected()) {
                this.getPainter().paintSelectedMenu(jideSplitButton, graphics, new Rectangle(0, 0, n2, n), n3, 3);
            } else if (buttonModel.isArmed() || buttonModel.isPressed()) {
                Rectangle rectangle = this.getButtonRect(jideSplitButton, n3, n2, n);
                if (jideSplitButton.isButtonEnabled()) {
                    JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                }
                rectangle = this.getDropDownRect(jideSplitButton, n3, n2, n);
                JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                if (!jideSplitButton.isOpaque()) {
                    rectangle = this.getButtonRect(jideSplitButton, n3, n2, n);
                    this.paintSunkenBorder(graphics, rectangle);
                    rectangle = this.getDropDownRect(jideSplitButton, n3, n2, n);
                    this.paintRaisedBorder(graphics, rectangle);
                }
            } else if (buttonModel instanceof SplitButtonModel && ((DefaultSplitButtonModel)buttonModel).isButtonSelected()) {
                if ((this.isMouseOver() || jideSplitButton.hasFocus()) && buttonModel.isEnabled()) {
                    Rectangle rectangle = this.getDropDownRect(jideSplitButton, n3, n2, n);
                    JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                    rectangle = this.getButtonRect(jideSplitButton, n3, n2, n);
                    if (jideSplitButton.isButtonEnabled()) {
                        JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                    }
                    if (!jideSplitButton.isOpaque()) {
                        rectangle = this.getButtonRect(jideSplitButton, n3, n2, n);
                        this.paintSunkenBorder(graphics, rectangle);
                        rectangle = this.getDropDownRect(jideSplitButton, n3, n2, n);
                        this.paintRaisedBorder(graphics, rectangle);
                    }
                } else {
                    Rectangle rectangle;
                    if (jideSplitButton.isOpaque()) {
                        rectangle = this.getDropDownRect(jideSplitButton, n3, n2, n);
                        JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                    }
                    rectangle = this.getButtonRect(jideSplitButton, n3, n2, n);
                    JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                    if (!jideSplitButton.isOpaque()) {
                        rectangle = this.getButtonRect(jideSplitButton, n3, n2, n);
                        this.paintSunkenBorder(graphics, rectangle);
                    }
                }
            } else if ((jideSplitButton.isRolloverEnabled() && this.isMouseOver() || jideSplitButton.hasFocus()) && buttonModel.isEnabled()) {
                Rectangle rectangle = this.getButtonRect(jideSplitButton, n3, n2, n);
                if (jideSplitButton.isButtonEnabled()) {
                    JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                }
                rectangle = this.getDropDownRect(jideSplitButton, n3, n2, n);
                JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                if (this.isAlwaysDropdown(jideSplitButton)) {
                    rectangle = new Rectangle(0, 0, n2, n);
                    this.paintRaisedBorder(graphics, rectangle);
                } else {
                    rectangle = this.getButtonRect(jideSplitButton, n3, n2, n);
                    this.paintRaisedBorder(graphics, rectangle);
                    rectangle = this.getDropDownRect(jideSplitButton, n3, n2, n);
                    this.paintRaisedBorder(graphics, rectangle);
                }
            } else if (jideSplitButton.isOpaque()) {
                Rectangle rectangle = this.getButtonRect(jideSplitButton, n3, n2, n);
                if (jideSplitButton.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n3, 0);
                }
                rectangle = this.getDropDownRect(jideSplitButton, n3, n2, n);
                this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n3, 0);
            }
        } else if (jideSplitButton.getButtonStyle() == 1) {
            if (buttonModel.isSelected()) {
                this.getPainter().paintSelectedMenu(jideSplitButton, graphics, new Rectangle(0, 0, n2, n), n3, 3);
            } else if (buttonModel.isArmed() || buttonModel.isPressed()) {
                Rectangle rectangle = this.getButtonRect(jideSplitButton, n3, n2, n);
                if (jideSplitButton.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n3, 1);
                }
                rectangle = this.getDropDownRect(jideSplitButton, n3, n2, n);
                this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n3, 2);
                if (!jideSplitButton.isOpaque()) {
                    rectangle = this.getButtonRect(jideSplitButton, n3, n2, n);
                    this.paintSunken2Border(graphics, rectangle);
                    rectangle = this.getDropDownRect(jideSplitButton, n3, n2, n);
                    this.paintRaisedBorder(graphics, rectangle);
                }
            } else if (buttonModel instanceof SplitButtonModel && ((DefaultSplitButtonModel)buttonModel).isButtonSelected()) {
                if (this.isMouseOver() && buttonModel.isEnabled()) {
                    Rectangle rectangle = this.getDropDownRect(jideSplitButton, n3, n2, n);
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n3, 2);
                    rectangle = this.getButtonRect(jideSplitButton, n3, n2, n);
                    if (jideSplitButton.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n3, 1);
                    }
                    if (!jideSplitButton.isOpaque()) {
                        rectangle = this.getButtonRect(jideSplitButton, n3, n2, n);
                        this.paintSunken2Border(graphics, rectangle);
                        rectangle = this.getDropDownRect(jideSplitButton, n3, n2, n);
                        this.paintRaisedBorder(graphics, rectangle);
                    }
                } else {
                    Rectangle rectangle;
                    if (jideSplitButton.isOpaque()) {
                        rectangle = this.getDropDownRect(jideSplitButton, n3, n2, n);
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n3, 0);
                    }
                    rectangle = this.getButtonRect(jideSplitButton, n3, n2, n);
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n3, 3);
                    if (!jideSplitButton.isOpaque()) {
                        rectangle = this.getButtonRect(jideSplitButton, n3, n2, n);
                        this.paintSunken2Border(graphics, rectangle);
                        rectangle = this.getDropDownRect(jideSplitButton, n3, n2, n);
                        this.paintRaisedBorder(graphics, rectangle);
                    }
                }
            } else if (jideSplitButton.isRolloverEnabled() && this.isMouseOver() && buttonModel.isEnabled()) {
                if (this.isAlwaysDropdown(jideSplitButton)) {
                    Rectangle rectangle = new Rectangle(0, 0, n2, n);
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n3, 2);
                    this.paintRaised2Border(graphics, rectangle);
                } else {
                    Rectangle rectangle = this.getButtonRect(jideSplitButton, n3, n2, n);
                    if (jideSplitButton.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n3, 2);
                    }
                    rectangle = this.getDropDownRect(jideSplitButton, n3, n2, n);
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n3, 2);
                    rectangle = this.getButtonRect(jideSplitButton, n3, n2, n);
                    this.paintRaised2Border(graphics, rectangle);
                    rectangle = this.getDropDownRect(jideSplitButton, n3, n2, n);
                    this.paintRaised2Border(graphics, rectangle);
                }
            } else if (jideSplitButton.isOpaque()) {
                Rectangle rectangle = this.getButtonRect(jideSplitButton, n3, n2, n);
                if (jideSplitButton.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n3, 0);
                }
                rectangle = this.getDropDownRect(jideSplitButton, n3, n2, n);
                this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n3, 0);
            } else if (this.isAlwaysDropdown(jideSplitButton)) {
                Rectangle rectangle = new Rectangle(0, 0, n2, n);
                this.paintRaisedBorder(graphics, rectangle);
            } else {
                Rectangle rectangle = this.getButtonRect(jideSplitButton, n3, n2, n);
                this.paintRaisedBorder(graphics, rectangle);
                rectangle = this.getDropDownRect(jideSplitButton, n3, n2, n);
                this.paintRaisedBorder(graphics, rectangle);
            }
        }
        this.paintArrow(jMenuItem, graphics);
    }

    protected void paintArrow(JMenuItem jMenuItem, Graphics graphics) {
        int n;
        int n2;
        int n3 = JideSwingUtilities.getOrientationOf(jMenuItem);
        if (n3 == 0) {
            n2 = jMenuItem.getWidth();
            n = jMenuItem.getHeight();
        } else {
            n2 = jMenuItem.getHeight();
            n = jMenuItem.getWidth();
        }
        int n4 = jMenuItem.getComponentOrientation().isLeftToRight() ? n2 - 9 : 4;
        if (jMenuItem.isEnabled()) {
            JideSwingUtilities.paintArrow(graphics, this.getForegroundOfState(jMenuItem), n4, n / 2 - 1, 5, 0);
        } else {
            JideSwingUtilities.paintArrow(graphics, UIDefaultsLookup.getColor("controlShadow"), n4, n / 2 - 1, 5, 0);
        }
    }

    protected Rectangle getDropDownRect(JComponent jComponent, int n, int n2, int n3) {
        Object object = jComponent.getClientProperty("JButton.segmentPosition");
        Rectangle rectangle = jComponent.getComponentOrientation().isLeftToRight() ? new Rectangle(n2 - this._splitButtonMargin - 1 + this.getOffset(), 0, this._splitButtonMargin - this.getOffset(), n3) : new Rectangle(0, 0, this._splitButtonMargin - this.getOffset(), n3);
        if (object != null && !"only".equals(object)) {
            if ("first".equals(object)) {
                if (n == 0) {
                    ++rectangle.width;
                } else {
                    ++rectangle.height;
                }
            } else if ("middle".equals(object)) {
                if (n == 0) {
                    ++rectangle.width;
                } else {
                    ++rectangle.height;
                }
            } else if ("last".equals(object)) {
                // empty if block
            }
        }
        return rectangle;
    }

    protected Rectangle getButtonRect(JComponent jComponent, int n, int n2, int n3) {
        Rectangle rectangle = n == 0 && jComponent.getComponentOrientation().isLeftToRight() ? new Rectangle(0, 0, n2 - this._splitButtonMargin, n3) : new Rectangle(this._splitButtonMargin - 1, 0, n2 - this._splitButtonMargin, n3);
        return rectangle;
    }

    protected void paintSunkenBorder(Graphics graphics, Rectangle rectangle) {
        Color color = graphics.getColor();
        graphics.setColor(this._shadowColor);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
        graphics.setColor(this._lightHighlightColor);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.setColor(color);
    }

    protected void paintSunken2Border(Graphics graphics, Rectangle rectangle) {
        Color color = graphics.getColor();
        graphics.setColor(this._darkShadowColor);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 2, rectangle.y);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 2);
        graphics.setColor(this._shadowColor);
        graphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + rectangle.width - 3, rectangle.y + 1);
        graphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + 1, rectangle.y + rectangle.height - 3);
        graphics.setColor(this._lightHighlightColor);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.x, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.setColor(color);
    }

    protected void paintRaised2Border(Graphics graphics, Rectangle rectangle) {
        Color color = graphics.getColor();
        graphics.setColor(this._lightHighlightColor);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
        graphics.setColor(this._shadowColor);
        graphics.drawLine(rectangle.x + 1, rectangle.y + rectangle.height - 2, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
        graphics.drawLine(rectangle.x + rectangle.width - 2, 1, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
        graphics.setColor(this._darkShadowColor);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.setColor(color);
    }

    protected void paintRaisedBorder(Graphics graphics, Rectangle rectangle) {
        Color color = graphics.getColor();
        graphics.setColor(this._lightHighlightColor);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
        graphics.setColor(this._shadowColor);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.setColor(color);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if (!(jComponent instanceof JMenu) || !((JMenu)jComponent).isTopLevelMenu()) {
            return super.getPreferredSize(jComponent);
        }
        AbstractButton abstractButton = (AbstractButton)jComponent;
        boolean bl = JideSwingUtilities.getOrientationOf(jComponent) == 0;
        Dimension dimension = JideSwingUtilities.getPreferredButtonSize(abstractButton, this.defaultTextIconGap, true);
        if (BasicJideButtonUI.shouldWrapText(jComponent)) {
            if (jComponent instanceof JideSplitButton) {
                dimension.width += BasicJideSplitButtonUI.getAdjustExtraWidth(abstractButton, abstractButton.getText(), 8);
            }
        } else {
            dimension.width += this.getRightMargin();
            if (this.isDownArrowVisible(abstractButton.getParent())) {
                ++dimension.width;
            }
        }
        if (bl) {
            return dimension;
        }
        return new Dimension(dimension.height, dimension.width);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (!(jComponent instanceof JMenu) || !((JMenu)jComponent).isTopLevelMenu()) {
            return super.getMinimumSize(jComponent);
        }
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            if (JideSwingUtilities.getOrientationOf(jComponent) == 0) {
                dimension.width = (int)((float)dimension.width - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
            } else {
                dimension.height = (int)((float)dimension.height - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
            }
        }
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        if (!(jComponent instanceof JMenu) || !((JMenu)jComponent).isTopLevelMenu()) {
            return super.getMaximumSize(jComponent);
        }
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            if (JideSwingUtilities.getOrientationOf(jComponent) == 0) {
                dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
            } else {
                dimension.height = (int)((float)dimension.height + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
            }
        }
        return dimension;
    }

    protected void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
        int n;
        ButtonModel buttonModel = jMenuItem.getModel();
        if (!(jMenuItem instanceof JMenu && ((JMenu)jMenuItem).isTopLevelMenu() || !jMenuItem.getComponentOrientation().isLeftToRight())) {
            int n2 = UIDefaultsLookup.getInt("MenuItem.textIconGap");
            n = UIDefaultsLookup.getInt("MenuItem.shadowWidth");
            rectangle.x = n + n2;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        n = jMenuItem.getDisplayedMnemonicIndex();
        if (WindowsLookAndFeel.isMnemonicHidden()) {
            n = -1;
        }
        Color color = graphics.getColor();
        if (!buttonModel.isEnabled() || jMenuItem instanceof JideSplitButton && !((JideSplitButton)jMenuItem).isButtonEnabled()) {
            if (jMenuItem.getParent() != null) {
                graphics.setColor(jMenuItem.getParent().getBackground().brighter());
                this.drawStringUnderlineCharAt(jMenuItem, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
                graphics.setColor(jMenuItem.getParent().getBackground().darker());
            }
            this.drawStringUnderlineCharAt(jMenuItem, graphics, string, n, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
        } else {
            if (buttonModel.isSelected()) {
                graphics.setColor(this.selectionForeground);
            } else {
                graphics.setColor(this.getForegroundOfState(jMenuItem));
            }
            this.drawStringUnderlineCharAt(jMenuItem, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
        }
        graphics.setColor(color);
    }

    private Color getForegroundOfState(JMenuItem jMenuItem) {
        int n = JideSwingUtilities.getButtonState(jMenuItem);
        Color color = null;
        if (jMenuItem instanceof ComponentStateSupport) {
            color = ((ComponentStateSupport)((Object)jMenuItem)).getForegroundOfState(n);
        }
        if (color == null || color instanceof UIResource) {
            color = jMenuItem.getForeground();
        }
        return color;
    }

    protected void drawStringUnderlineCharAt(JComponent jComponent, Graphics graphics, String string, int n, int n2, int n3) {
        JideSwingUtilities.drawStringUnderlineCharAt(jComponent, graphics, string, n, n2, n3);
    }

    protected void paintIcon(JMenuItem jMenuItem, Graphics graphics) {
        Icon icon;
        ButtonModel buttonModel = jMenuItem.getModel();
        if (jMenuItem.getIcon() != null && (icon = this.getIcon(jMenuItem)) != null) {
            boolean bl;
            boolean bl2 = bl = buttonModel.isEnabled() && (!(buttonModel instanceof SplitButtonModel) || ((SplitButtonModel)buttonModel).isButtonEnabled());
            if (this.isFloatingIcon() && bl) {
                if (buttonModel.isRollover() && !buttonModel.isPressed() && !buttonModel.isSelected()) {
                    if (!"true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                        if (icon instanceof ImageIcon) {
                            ImageIcon imageIcon = IconsFactory.createGrayImage(((ImageIcon)icon).getImage());
                            imageIcon.paintIcon(jMenuItem, graphics, BasicJideSplitButtonUI.iconRect.x + 1, BasicJideSplitButtonUI.iconRect.y + 1);
                        } else {
                            ImageIcon imageIcon = IconsFactory.createGrayImage(jMenuItem, icon);
                            imageIcon.paintIcon(jMenuItem, graphics, BasicJideSplitButtonUI.iconRect.x + 1, BasicJideSplitButtonUI.iconRect.y + 1);
                        }
                        icon.paintIcon(jMenuItem, graphics, BasicJideSplitButtonUI.iconRect.x - 1, BasicJideSplitButtonUI.iconRect.y - 1);
                    } else {
                        icon.paintIcon(jMenuItem, graphics, BasicJideSplitButtonUI.iconRect.x, BasicJideSplitButtonUI.iconRect.y);
                    }
                } else {
                    icon.paintIcon(jMenuItem, graphics, BasicJideSplitButtonUI.iconRect.x, BasicJideSplitButtonUI.iconRect.y);
                }
            } else {
                icon.paintIcon(jMenuItem, graphics, BasicJideSplitButtonUI.iconRect.x, BasicJideSplitButtonUI.iconRect.y);
            }
        }
    }

    protected boolean isFloatingIcon() {
        return this._isFloatingIcon;
    }

    protected Icon getIcon(AbstractButton abstractButton) {
        ButtonModel buttonModel = abstractButton.getModel();
        Icon icon = abstractButton.getIcon();
        Icon icon2 = null;
        if (!buttonModel.isEnabled() || !((JideSplitButton)this.menuItem).isButtonEnabled()) {
            icon2 = buttonModel.isSelected() ? abstractButton.getDisabledSelectedIcon() : abstractButton.getDisabledIcon();
            if (icon2 == null) {
                icon = icon instanceof ImageIcon ? IconsFactory.createGrayImage(((ImageIcon)icon).getImage()) : IconsFactory.createGrayImage(abstractButton, icon);
            }
        } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
            icon2 = abstractButton.getPressedIcon();
            if (icon2 != null) {
                // empty if block
            }
        } else if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
            icon2 = buttonModel.isSelected() ? abstractButton.getRolloverSelectedIcon() : abstractButton.getRolloverIcon();
        } else if (buttonModel.isSelected()) {
            icon2 = abstractButton.getSelectedIcon();
        }
        if (icon2 != null) {
            icon = icon2;
        }
        return icon;
    }

    protected int getOffset() {
        return 0;
    }

    protected boolean isAlwaysDropdown(JMenuItem jMenuItem) {
        return jMenuItem instanceof JideSplitButton && ((JideSplitButton)jMenuItem).isAlwaysDropdown();
    }

    protected int getRightMargin() {
        return this._splitButtonMargin - 1;
    }

    public static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions("pressed"));
        lazyActionMap.put(new Actions("released"));
        lazyActionMap.put(new Actions("downPressed"));
        lazyActionMap.put(new Actions("downReleased"));
    }

    protected void updateMnemonicBinding() {
        super.updateMnemonicBinding();
        int n = this.menuItem.getModel().getMnemonic();
        if (n != 0 && this.windowInputMap != null) {
            int[] nArray = (int[])UIDefaultsLookup.get("Menu.shortcutKeys");
            if (nArray == null) {
                nArray = new int[]{8};
            }
            for (int n2 : nArray) {
                this.windowInputMap.put(KeyStroke.getKeyStroke(n, n2, false), "pressed");
                this.windowInputMap.put(KeyStroke.getKeyStroke(n, n2, true), "released");
            }
        }
    }

    protected static void downButtonPressed(JMenu jMenu) {
        Object object;
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        if (jMenu.isTopLevelMenu()) {
            if (jMenu.isSelected()) {
                menuSelectionManager.clearSelectedPath();
            } else {
                object = BasicJideSplitButtonUI.getFirstParentMenuElement(jMenu);
                if (object != null && object instanceof MenuElement) {
                    ArrayList<MenuElement[]> arrayList = new ArrayList<MenuElement[]>();
                    while (object instanceof MenuElement) {
                        arrayList.add(0, (MenuElement[])object);
                        if (object instanceof JPopupMenu) {
                            object = (Container)((JPopupMenu)object).getInvoker();
                            continue;
                        }
                        object = BasicJideSplitButtonUI.getFirstParentMenuElement((Component)object);
                    }
                    MenuElement[] menuElementArray = new MenuElement[arrayList.size() + 1];
                    for (int i = 0; i < arrayList.size(); ++i) {
                        Container container = (Container)arrayList.get(i);
                        menuElementArray[i] = (MenuElement)((Object)container);
                    }
                    menuElementArray[arrayList.size()] = jMenu;
                    menuSelectionManager.setSelectedPath(menuElementArray);
                } else {
                    MenuElement[] menuElementArray = new MenuElement[]{jMenu};
                    menuSelectionManager.setSelectedPath(menuElementArray);
                }
            }
        }
        if (((MenuElement[])(object = menuSelectionManager.getSelectedPath())).length > 0 && object[((MenuElement[])object).length - 1] != jMenu.getPopupMenu()) {
            if (jMenu.isTopLevelMenu() || jMenu.getDelay() == 0) {
                BasicJideSplitButtonUI.appendPath(object, jMenu.getPopupMenu());
            } else {
                BasicJideSplitButtonUI.setupPostTimer(jMenu);
            }
        }
    }

    protected static Container getFirstParentMenuElement(Component component) {
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof MenuElement)) continue;
            return container;
        }
        return null;
    }

    public static int getAdjustExtraWidth(Component component, String string, int n) {
        String[] stringArray = BasicJideSplitButtonUI.getWrappedText(string);
        Font font = component.getFont();
        FontMetrics fontMetrics = component.getFontMetrics(font);
        int n2 = fontMetrics.stringWidth(stringArray[0]);
        int n3 = stringArray.length <= 1 ? 0 : fontMetrics.stringWidth(stringArray[1]);
        int n4 = Math.max(n2, n3);
        int n5 = Math.max(n2, n3 += n);
        return n5 - n4;
    }

    public static String getMaxLengthWord(String string) {
        if (string.indexOf(32) == -1) {
            return string;
        }
        int n = string.length();
        int n2 = -1;
        int n3 = string.length() / 2;
        int n4 = -1;
        while ((n4 = string.indexOf(32, n4 + 1)) != -1) {
            int n5 = Math.abs(n4 - n3);
            if (n5 >= n) continue;
            n = n5;
            n2 = n4;
        }
        return n2 >= n3 ? string.substring(0, n2) : string.substring(n2 + 1);
    }

    public static String[] getWrappedText(String string) {
        String[] stringArray = string.split(" ");
        if (stringArray.length <= 2) {
            return stringArray;
        }
        if (stringArray.length >= 3) {
            int n = string.length();
            int n2 = -1;
            int n3 = -1;
            int n4 = string.length() / 2;
            while ((n3 = string.indexOf(32, n3 + 1)) != -1) {
                int n5 = Math.abs(n3 - n4);
                if (n5 >= n) continue;
                n = n5;
                n2 = n3;
            }
            return new String[]{string.substring(0, n2), string.substring(n2 + 1)};
        }
        return stringArray;
    }

    private static class Actions
    extends UIAction {
        private static final String PRESS = "pressed";
        private static final String RELEASE = "released";
        private static final String DOWN_PRESS = "downPressed";
        private static final String DOWN_RELEASE = "downReleased";

        Actions(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            String string = this.getName();
            if (PRESS.equals(string) && ((JideSplitButton)abstractButton).isAlwaysDropdown()) {
                string = DOWN_PRESS;
            }
            if (PRESS.equals(string)) {
                ButtonModel buttonModel = abstractButton.getModel();
                buttonModel.setArmed(true);
                buttonModel.setPressed(true);
                if (!abstractButton.hasFocus()) {
                    abstractButton.requestFocus();
                }
            } else if (RELEASE.equals(string)) {
                ButtonModel buttonModel = abstractButton.getModel();
                buttonModel.setPressed(false);
                buttonModel.setArmed(false);
            } else if (DOWN_PRESS.equals(string)) {
                BasicJideSplitButtonUI.downButtonPressed((JMenu)abstractButton);
            } else if (DOWN_RELEASE.equals(string)) {
                // empty if block
            }
        }

        public boolean isEnabled(Object object) {
            return object == null || !(object instanceof AbstractButton) || ((AbstractButton)object).getModel().isEnabled();
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.cancelMenuIfNecessary(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)BasicJideSplitButtonUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            BasicJideSplitButtonUI.this.setMouseOver(true);
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (this.isClickOnButton(mouseEvent, jMenu)) {
                if (((JideSplitButton)BasicJideSplitButtonUI.this.menuItem).isButtonEnabled()) {
                    jMenu.getModel().setArmed(true);
                    jMenu.getModel().setPressed(true);
                }
                if (!jMenu.hasFocus() && jMenu.isRequestFocusEnabled()) {
                    jMenu.requestFocus();
                }
            } else {
                BasicJideSplitButtonUI.downButtonPressed(jMenu);
            }
        }

        private boolean isClickOnButton(MouseEvent mouseEvent, JMenu jMenu) {
            if (((JideSplitButton)jMenu).isAlwaysDropdown()) {
                return false;
            }
            boolean bl = false;
            if (BasicJideButtonUI.shouldWrapText(BasicJideSplitButtonUI.this.menuItem)) {
                int n = 27;
                if (JideSwingUtilities.getOrientationOf(BasicJideSplitButtonUI.this.menuItem) == 0) {
                    if (mouseEvent.getPoint().getY() < (double)(jMenu.getHeight() - n)) {
                        bl = true;
                    }
                } else if (mouseEvent.getPoint().getY() < (double)(jMenu.getHeight() - n)) {
                    bl = true;
                }
            } else {
                int n;
                int n2 = n = ((JMenu)BasicJideSplitButtonUI.this.menuItem).isTopLevelMenu() ? BasicJideSplitButtonUI.this._splitButtonMargin : BasicJideSplitButtonUI.this._splitButtonMarginOnMenu;
                if (JideSwingUtilities.getOrientationOf(BasicJideSplitButtonUI.this.menuItem) == 0) {
                    if (jMenu.getComponentOrientation().isLeftToRight()) {
                        if (mouseEvent.getPoint().getX() < (double)(jMenu.getWidth() - n)) {
                            bl = true;
                        }
                    } else if (mouseEvent.getPoint().getX() >= (double)n) {
                        bl = true;
                    }
                } else if (mouseEvent.getPoint().getY() < (double)(jMenu.getHeight() - n)) {
                    bl = true;
                }
            }
            return bl;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)BasicJideSplitButtonUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            if (!this.isClickOnButton(mouseEvent, jMenu)) {
                BasicJideSplitButtonUI.this.menuItem.getModel().setArmed(false);
                BasicJideSplitButtonUI.this.menuItem.getModel().setPressed(false);
            }
            this.cancelMenuIfNecessary(mouseEvent);
        }

        private void cancelMenuIfNecessary(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)BasicJideSplitButtonUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            if (this.isClickOnButton(mouseEvent, jMenu) && ((JideSplitButton)BasicJideSplitButtonUI.this.menuItem).isButtonEnabled()) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    jMenu.getModel().setPressed(false);
                    jMenu.getModel().setArmed(false);
                } else {
                    jMenu.getModel().setArmed(false);
                    jMenu.getModel().setPressed(false);
                }
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
                for (int i = menuElementArray.length - 1; i >= 0; --i) {
                    MenuElement menuElement = menuElementArray[i];
                    if (!(menuElement instanceof JPopupMenu) || !((JPopupMenu)menuElement).isAncestorOf(jMenu)) continue;
                    jMenu.getModel().setRollover(false);
                    BasicJideSplitButtonUI.this.setMouseOver(false);
                    menuSelectionManager.clearSelectedPath();
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)BasicJideSplitButtonUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (!jMenu.isTopLevelMenu()) {
                if (menuElementArray.length <= 0 || menuElementArray[menuElementArray.length - 1] != jMenu.getPopupMenu()) {
                    if (jMenu.getDelay() == 0) {
                        BasicJideSplitButtonUI.appendPath(BasicJideSplitButtonUI.this.getPath(), jMenu.getPopupMenu());
                    } else {
                        menuSelectionManager.setSelectedPath(BasicJideSplitButtonUI.this.getPath());
                        BasicJideSplitButtonUI.setupPostTimer(jMenu);
                    }
                }
            } else if (menuElementArray.length > 0 && menuElementArray[0] == jMenu.getParent()) {
                MenuElement[] menuElementArray2 = new MenuElement[]{(MenuElement)((Object)jMenu.getParent()), jMenu, jMenu.getPopupMenu()};
                menuSelectionManager.setSelectedPath(menuElementArray2);
            }
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                BasicJideSplitButtonUI.this.setMouseOver(true);
            }
            BasicJideSplitButtonUI.this.menuItem.repaint();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            BasicJideSplitButtonUI.this.setMouseOver(false);
            BasicJideSplitButtonUI.this.menuItem.repaint();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)BasicJideSplitButtonUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)BasicJideSplitButtonUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            if (BasicJideSplitButtonUI.this.menuItem instanceof JideSplitButton) {
                if (this.isClickOnButton(mouseEvent, (JMenu)BasicJideSplitButtonUI.this.menuItem)) {
                    ((SplitButtonModel)((JideSplitButton)BasicJideSplitButtonUI.this.menuItem).getModel()).setButtonRollover(true);
                } else {
                    ((SplitButtonModel)((JideSplitButton)BasicJideSplitButtonUI.this.menuItem).getModel()).setButtonRollover(false);
                }
            }
        }
    }
}

