/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.ssl;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.Endpoint;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.ssl.SslServerEndpointImpl;
import net.jini.jeri.ssl.Utilities;

public final class SslServerEndpoint
implements ServerEndpoint {
    static final Logger logger = Utilities.serverLogger;
    final SslServerEndpointImpl impl;

    public static SslServerEndpoint getInstance(int n) {
        return new SslServerEndpoint(null, null, null, n, null, null);
    }

    public static SslServerEndpoint getInstance(String string, int n) {
        return new SslServerEndpoint(null, null, string, n, null, null);
    }

    public static SslServerEndpoint getInstance(String string, int n, SocketFactory socketFactory, ServerSocketFactory serverSocketFactory) {
        return new SslServerEndpoint(null, null, string, n, socketFactory, serverSocketFactory);
    }

    public static SslServerEndpoint getInstance(Subject subject, X500Principal[] x500PrincipalArray, String string, int n) {
        return new SslServerEndpoint(subject, x500PrincipalArray, string, n, null, null);
    }

    public static SslServerEndpoint getInstance(Subject subject, X500Principal[] x500PrincipalArray, String string, int n, SocketFactory socketFactory, ServerSocketFactory serverSocketFactory) {
        return new SslServerEndpoint(subject, x500PrincipalArray, string, n, socketFactory, serverSocketFactory);
    }

    private SslServerEndpoint(Subject subject, X500Principal[] x500PrincipalArray, String string, int n, SocketFactory socketFactory, ServerSocketFactory serverSocketFactory) {
        this.impl = new SslServerEndpointImpl(this, subject, x500PrincipalArray, string, n, socketFactory, serverSocketFactory);
        logger.log(Level.FINE, "created {0}", this);
    }

    public String getHost() {
        return this.impl.serverHost;
    }

    public int getPort() {
        return this.impl.port;
    }

    public Set getPrincipals() {
        return this.impl.serverPrincipals == null ? null : Collections.unmodifiableSet(this.impl.serverPrincipals);
    }

    public SocketFactory getSocketFactory() {
        return this.impl.socketFactory;
    }

    public ServerSocketFactory getServerSocketFactory() {
        return this.impl.serverSocketFactory;
    }

    public String toString() {
        return "SslServerEndpoint" + this.impl.fieldsToString();
    }

    public InvocationConstraints checkConstraints(InvocationConstraints invocationConstraints) throws UnsupportedConstraintException {
        return this.impl.checkConstraints(invocationConstraints);
    }

    public int hashCode() {
        return this.impl.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof SslServerEndpoint && this.impl.equals(((SslServerEndpoint)object).impl);
    }

    public Endpoint enumerateListenEndpoints(ServerEndpoint.ListenContext listenContext) throws IOException {
        return this.impl.enumerateListenEndpoints(listenContext);
    }
}

