/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.http;

import com.sun.jini.jeri.internal.http.ConnectionTimer;
import com.sun.jini.jeri.internal.http.HttpClientConnection;
import com.sun.jini.jeri.internal.http.HttpClientManager;
import com.sun.jini.jeri.internal.http.HttpClientSocketFactory;
import com.sun.jini.jeri.internal.http.HttpSettings;
import com.sun.jini.jeri.internal.runtime.Util;
import com.sun.jini.logging.Levels;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.jeri.Endpoint;
import net.jini.jeri.OutboundRequest;
import net.jini.jeri.OutboundRequestIterator;
import net.jini.jeri.http.Constraints;
import net.jini.security.proxytrust.TrustEquivalence;

public final class HttpEndpoint
implements Endpoint,
TrustEquivalence,
Serializable {
    private static final long serialVersionUID = -7094180943307123931L;
    private static final Map internTable = new WeakHashMap();
    private static final HttpClientManager clientManager;
    private static final ConnectionTimer connTimer;
    private static final Logger logger;
    private final String host;
    private final int port;
    private final SocketFactory sf;
    private transient Set connections;
    private transient String proxyHost;
    private transient int proxyPort;
    static /* synthetic */ Class class$net$jini$jeri$http$HttpEndpoint;

    public static HttpEndpoint getInstance(String string, int n) {
        return HttpEndpoint.intern(new HttpEndpoint(string, n, null));
    }

    public static HttpEndpoint getInstance(String string, int n, SocketFactory socketFactory) {
        return HttpEndpoint.intern(new HttpEndpoint(string, n, socketFactory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpEndpoint intern(HttpEndpoint httpEndpoint) {
        Map map = internTable;
        synchronized (map) {
            HttpEndpoint httpEndpoint2;
            SoftReference softReference = (SoftReference)internTable.get(httpEndpoint);
            if (softReference != null && (httpEndpoint2 = (HttpEndpoint)((Reference)softReference).get()) != null) {
                return httpEndpoint2;
            }
            httpEndpoint.init();
            internTable.put(httpEndpoint, new SoftReference<HttpEndpoint>(httpEndpoint));
            return httpEndpoint;
        }
    }

    private HttpEndpoint(String string, int n, SocketFactory socketFactory) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (n < 1 || n > 65535) {
            throw new IllegalArgumentException("port number out of range: " + n);
        }
        this.host = string;
        this.port = n;
        this.sf = socketFactory;
    }

    private Object readResolve() {
        return HttpEndpoint.intern(this);
    }

    private void init() {
        this.connections = new HashSet(5);
        this.proxyHost = "";
        this.proxyPort = -1;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public SocketFactory getSocketFactory() {
        return this.sf;
    }

    public OutboundRequestIterator newRequest(final InvocationConstraints invocationConstraints) {
        if (invocationConstraints == null) {
            throw new NullPointerException();
        }
        return new OutboundRequestIterator(){
            private boolean nextCalled = false;
            private OutboundRequest currentRequest;

            public OutboundRequest next() throws IOException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.nextCalled = true;
                this.currentRequest = HttpEndpoint.this.nextRequest(invocationConstraints);
                return this.currentRequest;
            }

            public boolean hasNext() {
                return !this.nextCalled;
            }
        };
    }

    private OutboundRequest nextRequest(InvocationConstraints invocationConstraints) throws IOException {
        final Constraints.Distilled distilled = Constraints.distill(invocationConstraints, false);
        final OutboundRequest outboundRequest = this.nextRequest(distilled);
        return new OutboundRequest(){

            public void populateContext(Collection collection) {
                outboundRequest.populateContext(collection);
            }

            public InvocationConstraints getUnfulfilledConstraints() {
                return distilled.getUnfulfilledConstraints();
            }

            public OutputStream getRequestOutputStream() {
                return outboundRequest.getRequestOutputStream();
            }

            public InputStream getResponseInputStream() {
                return outboundRequest.getResponseInputStream();
            }

            public boolean getDeliveryStatus() {
                return outboundRequest.getDeliveryStatus();
            }

            public void abort() {
                outboundRequest.abort();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OutboundRequest nextRequest(final Constraints.Distilled distilled) throws IOException {
        Connection connection;
        HttpSettings httpSettings;
        String string;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(this.host, this.port);
        }
        if (!(string = (httpSettings = HttpEndpoint.getHttpSettings()).getHttpProxyHost("")).equals("") && httpSettings.nonProxied(this.host, false)) {
            string = "";
        }
        int n = string.equals("") ? -1 : httpSettings.getHttpProxyPort(80);
        Set set = this.connections;
        synchronized (set) {
            if (!this.proxyHost.equals(string) || this.proxyPort != n) {
                this.proxyHost = string;
                this.proxyPort = n;
                this.shedConnections();
            }
            while (!this.connections.isEmpty()) {
                block12: {
                    connection = (Connection)this.connections.iterator().next();
                    this.connections.remove(connection);
                    if (connTimer.cancelTimeout(connection)) {
                        try {
                            return connection.newRequest();
                        }
                        catch (IOException iOException) {
                            if (!logger.isLoggable(Levels.HANDLED)) break block12;
                            LogRecord logRecord = new LogRecord(Levels.HANDLED, "newRequest on {0} throws");
                            logRecord.setLoggerName(logger.getName());
                            logRecord.setSourceClassName(this.getClass().getName());
                            logRecord.setSourceMethodName("newRequest");
                            logRecord.setParameters(new Object[]{this});
                            logRecord.setThrown(iOException);
                            logger.log(logRecord);
                        }
                    }
                }
                connection.shutdown(true);
            }
        }
        try {
            connection = (Connection)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return HttpEndpoint.this.proxyHost.equals("") ? new Connection(HttpEndpoint.this.host, HttpEndpoint.this.port, distilled) : new Connection(HttpEndpoint.this.host, HttpEndpoint.this.port, HttpEndpoint.this.proxyHost, HttpEndpoint.this.proxyPort, distilled);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
        return connection.newRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shedConnections() {
        Set set = this.connections;
        synchronized (set) {
            Object[] objectArray = this.connections.toArray();
            this.connections.clear();
            for (int i = 0; i < objectArray.length; ++i) {
                ((Connection)objectArray[i]).shutdown(true);
            }
        }
    }

    public int hashCode() {
        return this.host.hashCode() ^ this.port ^ (this.sf != null ? this.sf.hashCode() : 0);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HttpEndpoint)) {
            return false;
        }
        HttpEndpoint httpEndpoint = (HttpEndpoint)object;
        return this.host.equals(httpEndpoint.host) && this.port == httpEndpoint.port && Util.sameClassAndEquals(this.sf, httpEndpoint.sf);
    }

    public boolean checkTrustEquivalence(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HttpEndpoint)) {
            return false;
        }
        HttpEndpoint httpEndpoint = (HttpEndpoint)object;
        return this.host.equals(httpEndpoint.host) && this.port == httpEndpoint.port && Util.sameClassAndEquals(this.sf, httpEndpoint.sf);
    }

    public String toString() {
        return "HttpEndpoint[" + this.host + ":" + this.port + (this.sf != null ? "," + this.sf : "") + "]";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.host == null) {
            throw new InvalidObjectException("null host");
        }
        if (this.port < 1 || this.port > 65535) {
            throw new InvalidObjectException("port number out of range: " + this.port);
        }
    }

    static HttpSettings getHttpSettings() {
        return (HttpSettings)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return HttpSettings.getHttpSettings();
            }
        });
    }

    static {
        HttpSettings httpSettings = HttpEndpoint.getHttpSettings();
        clientManager = new HttpClientManager(httpSettings.getResponseAckTimeout(15000L));
        connTimer = new ConnectionTimer(httpSettings.getConnectionTimeout(15000L));
        logger = Logger.getLogger("net.jini.jeri.http.client");
    }

    private final class Connection
    extends HttpClientConnection {
        private final String proxyHost;
        private final int proxyPort;

        Connection(String string, int n, Constraints.Distilled distilled) throws IOException {
            super(string, n, new SocketFactoryAdapter(HttpEndpoint.this.sf, distilled), clientManager);
            this.proxyHost = "";
            this.proxyPort = -1;
        }

        Connection(String string, int n, String string2, int n2, Constraints.Distilled distilled) throws IOException {
            super(string, n, string2, n2, false, new SocketFactoryAdapter(HttpEndpoint.this.sf, distilled), clientManager);
            this.proxyHost = string2;
            this.proxyPort = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void idle() {
            Set set = HttpEndpoint.this.connections;
            synchronized (set) {
                if (this.proxyHost.equals(HttpEndpoint.this.proxyHost) && this.proxyPort == HttpEndpoint.this.proxyPort) {
                    HttpEndpoint.this.connections.add(this);
                    connTimer.scheduleTimeout(this, false);
                } else {
                    super.shutdown(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean shutdown(boolean bl) {
            Socket socket = this.getSocket();
            if (super.shutdown(bl)) {
                Set set = HttpEndpoint.this.connections;
                synchronized (set) {
                    HttpEndpoint.this.connections.remove(this);
                    connTimer.cancelTimeout(this);
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "closed socket {0}", new Object[]{socket});
                }
                return true;
            }
            return false;
        }
    }

    private static final class SocketFactoryAdapter
    implements HttpClientSocketFactory {
        private final SocketFactory sf;
        private final Constraints.Distilled distilled;
        static final /* synthetic */ boolean $assertionsDisabled;

        SocketFactoryAdapter(SocketFactory socketFactory, Constraints.Distilled distilled) {
            this.sf = socketFactory;
            this.distilled = distilled;
        }

        public Socket createSocket(String string, int n) throws IOException {
            Socket socket;
            block10: {
                LogRecord logRecord;
                block9: {
                    int n2;
                    socket = this.sf != null ? this.sf.createSocket() : new Socket();
                    if (this.distilled.hasConnectDeadline()) {
                        long l = System.currentTimeMillis();
                        long l2 = this.distilled.getConnectDeadline();
                        if (l2 <= l) {
                            throw new SocketTimeoutException("deadline past before connect attempt");
                        }
                        if (!$assertionsDisabled && l <= 0L) {
                            throw new AssertionError();
                        }
                        long l3 = l2 - l;
                        n2 = l3 > Integer.MAX_VALUE ? 0 : (int)l3;
                    } else {
                        n2 = 0;
                    }
                    socket.connect(new InetSocketAddress(string, n), n2);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "created socket {0}" + (this.sf != null ? " using factory {1}" : ""), new Object[]{socket, this.sf});
                    }
                    try {
                        socket.setTcpNoDelay(true);
                    }
                    catch (SocketException socketException) {
                        if (!logger.isLoggable(Levels.HANDLED)) break block9;
                        logRecord = new LogRecord(Levels.HANDLED, "exception setting TCP_NODELAY on socket {0}");
                        logRecord.setLoggerName(logger.getName());
                        logRecord.setSourceClassName(this.getClass().getName());
                        logRecord.setSourceMethodName("connect");
                        logRecord.setParameters(new Object[]{socket});
                        logRecord.setThrown(socketException);
                        logger.log(logRecord);
                    }
                }
                try {
                    socket.setKeepAlive(true);
                }
                catch (SocketException socketException) {
                    if (!logger.isLoggable(Levels.HANDLED)) break block10;
                    logRecord = new LogRecord(Levels.HANDLED, "exception setting SO_KEEPALIVE on socket {0}");
                    logRecord.setLoggerName(logger.getName());
                    logRecord.setSourceClassName(this.getClass().getName());
                    logRecord.setSourceMethodName("connect");
                    logRecord.setParameters(new Object[]{socket});
                    logRecord.setThrown(socketException);
                    logger.log(logRecord);
                }
            }
            return socket;
        }

        public Socket createTunnelSocket(Socket socket) throws IOException {
            throw new UnsupportedOperationException();
        }

        static {
            $assertionsDisabled = !(class$net$jini$jeri$http$HttpEndpoint == null ? (class$net$jini$jeri$http$HttpEndpoint = HttpEndpoint.class$("net.jini.jeri.http.HttpEndpoint")) : class$net$jini$jeri$http$HttpEndpoint).desiredAssertionStatus();
        }
    }
}

