/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri;

import com.sun.jini.jeri.internal.runtime.Util;
import com.sun.jini.logging.Levels;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.ProtocolException;
import java.net.UnknownHostException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalException;
import java.rmi.RemoteException;
import java.rmi.UnexpectedException;
import java.rmi.UnmarshalException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.jini.core.constraint.Integrity;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.io.MarshalInputStream;
import net.jini.io.MarshalOutputStream;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.ObjectEndpoint;
import net.jini.jeri.OutboundRequest;
import net.jini.jeri.OutboundRequestIterator;
import net.jini.security.proxytrust.TrustEquivalence;

public class BasicInvocationHandler
implements InvocationHandler,
TrustEquivalence,
Serializable {
    private static final long serialVersionUID = -783920361025791412L;
    private static final Logger logger = Logger.getLogger("net.jini.jeri.BasicInvocationHandler");
    private static final int CACHE_SIZE = 3;
    private final ObjectEndpoint oe;
    private final MethodConstraints clientConstraints;
    private final MethodConstraints serverConstraints;
    private transient Object cacheLock = new Object();
    private transient int cacheIndex;
    private transient Method[] methodCache;
    private transient InvocationConstraints[] constraintCache;

    public BasicInvocationHandler(ObjectEndpoint objectEndpoint, MethodConstraints methodConstraints) {
        if (objectEndpoint == null) {
            throw new NullPointerException();
        }
        this.oe = objectEndpoint;
        this.clientConstraints = null;
        this.serverConstraints = methodConstraints;
    }

    public BasicInvocationHandler(BasicInvocationHandler basicInvocationHandler, MethodConstraints methodConstraints) {
        this.oe = basicInvocationHandler.oe;
        this.clientConstraints = methodConstraints;
        this.serverConstraints = basicInvocationHandler.serverConstraints;
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            return this.invokeObjectMethod(object, method, objectArray);
        }
        if (method.getDeclaringClass() == RemoteMethodControl.class) {
            return this.invokeRemoteMethodControlMethod(object, method, objectArray);
        }
        if (method.getDeclaringClass() == TrustEquivalence.class) {
            return this.invokeTrustEquivalenceMethod(object, method, objectArray);
        }
        return this.invokeRemoteMethod(object, method, objectArray);
    }

    private Object invokeObjectMethod(Object object, Method method, Object[] objectArray) {
        String string = method.getName();
        if (string.equals("hashCode")) {
            return new Integer(this.hashCode());
        }
        if (string.equals("equals")) {
            Object object2 = objectArray[0];
            boolean bl = object == object2 || object2 != null && Util.sameProxyClass(object, object2) && this.equals(Proxy.getInvocationHandler(object2));
            return bl;
        }
        if (string.equals("toString")) {
            return this.proxyToString(object);
        }
        throw new IllegalArgumentException("unexpected Object method: " + method);
    }

    private Object invokeRemoteMethodControlMethod(Object object, Method method, Object[] objectArray) {
        String string = method.getName();
        if (string.equals("setConstraints")) {
            if (Proxy.getInvocationHandler(object) != this) {
                throw new IllegalArgumentException("not proxy for this");
            }
            Class<?> clazz = object.getClass();
            return Proxy.newProxyInstance(BasicInvocationHandler.getProxyLoader(clazz), clazz.getInterfaces(), this.setClientConstraints((MethodConstraints)objectArray[0]));
        }
        if (string.equals("getConstraints")) {
            return this.clientConstraints;
        }
        throw new AssertionError(method);
    }

    private Object invokeTrustEquivalenceMethod(Object object, Method method, Object[] objectArray) {
        String string = method.getName();
        if (string.equals("checkTrustEquivalence")) {
            Object object2 = objectArray[0];
            boolean bl = object == object2 || object2 != null && Util.sameProxyClass(object, object2) && this.checkTrustEquivalence(Proxy.getInvocationHandler(object2));
            return bl;
        }
        throw new AssertionError(method);
    }

    private Object invokeRemoteMethod(Object object, Method method, Object[] objectArray) throws Throwable {
        OutboundRequestIterator outboundRequestIterator;
        InvocationConstraints invocationConstraints = this.getConstraints(method);
        if (logger.isLoggable(Level.FINE)) {
            this.logCall(method, objectArray, invocationConstraints);
        }
        if (!(outboundRequestIterator = this.oe.newCall(invocationConstraints)).hasNext()) {
            throw new ConnectIOException("iterator produced no requests", new IOException("iterator produced no requests"));
        }
        Failure failure = null;
        do {
            Object object2;
            if (logger.isLoggable(Levels.HANDLED) && failure != null) {
                this.logThrow(Levels.HANDLED, method, failure.exception, false);
            }
            if (!((object2 = this.invokeRemoteMethodOnce(object, method, objectArray, outboundRequestIterator, invocationConstraints)) instanceof Failure)) {
                return object2;
            }
            failure = (Failure)object2;
        } while (failure.retry && outboundRequestIterator.hasNext());
        if (logger.isLoggable(Levels.FAILED) && failure != null) {
            this.logThrow(Levels.FAILED, method, failure.exception, false);
        }
        throw failure.exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeRemoteMethodOnce(Object object, Method method, Object[] objectArray, OutboundRequestIterator outboundRequestIterator, InvocationConstraints invocationConstraints) throws Throwable {
        ArrayList arrayList;
        Object object2;
        Object object3;
        OutboundRequest outboundRequest;
        try {
            outboundRequest = outboundRequestIterator.next();
        }
        catch (Exception exception) {
            RemoteException remoteException;
            if (exception instanceof IOException) {
                remoteException = BasicInvocationHandler.wrapSafeIOException((IOException)exception, this.oe);
            }
            return new Failure(remoteException, true);
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            InvocationConstraints invocationConstraints2 = outboundRequest.getUnfulfilledConstraints();
            object3 = invocationConstraints2.requirements().iterator();
            while (object3.hasNext()) {
                object2 = (InvocationConstraint)object3.next();
                if (object2 == Integrity.YES) {
                    bl2 = true;
                    continue;
                }
                if (object2 instanceof Integrity) continue;
                throw new UnsupportedConstraintException("cannot satisfy unfulfilled constraint: " + object2);
            }
            if (!bl2) {
                object3 = invocationConstraints2.preferences().iterator();
                while (object3.hasNext()) {
                    object2 = (InvocationConstraint)object3.next();
                    if (object2 != Integrity.YES) continue;
                    bl2 = true;
                    break;
                }
            }
            object3 = outboundRequest.getRequestOutputStream();
            ((OutputStream)object3).write(0);
            ((OutputStream)object3).write(bl2 ? 1 : 0);
            arrayList = new ArrayList(1);
            Util.populateContext(arrayList, bl2);
            object2 = this.createMarshalOutputStream(object, method, outboundRequest, arrayList);
            bl3 = true;
            this.marshalMethod(object, method, (ObjectOutputStream)object2, arrayList);
            objectArray = objectArray == null ? new Object[]{} : objectArray;
            this.marshalArguments(object, method, objectArray, (ObjectOutputStream)object2, arrayList);
            ((ObjectOutputStream)object2).close();
            bl = true;
        }
        catch (Exception exception) {
            RemoteException remoteException;
            if (exception instanceof IOException) {
                remoteException = bl3 && outboundRequest.getDeliveryStatus() ? new MarshalException("error marshalling arguments", exception) : BasicInvocationHandler.wrapSafeIOException((IOException)exception, this.oe);
            }
            Failure failure = new Failure(remoteException, !bl3 || !outboundRequest.getDeliveryStatus());
            return failure;
        }
        finally {
            if (!bl) {
                outboundRequest.abort();
            }
        }
        bl = false;
        boolean bl4 = false;
        object3 = null;
        object2 = null;
        try {
            object2 = this.oe.executeCall(outboundRequest);
            if (object2 == null) {
                InputStream inputStream = outboundRequest.getResponseInputStream();
                int n = inputStream.read();
                if (n == -1) {
                    throw new EOFException("connection closed by server");
                }
                if (n == 0) {
                    bl4 = true;
                    throw new ProtocolException("marshalling protocol version mismatch");
                }
                ObjectInputStream objectInputStream = this.createMarshalInputStream(object, method, outboundRequest, bl2, arrayList);
                switch (n) {
                    case 1: {
                        object3 = this.unmarshalReturn(object, method, objectInputStream, arrayList);
                        if (!logger.isLoggable(Level.FINE)) break;
                        this.logReturn(method, object3);
                        break;
                    }
                    case 2: {
                        object2 = this.unmarshalThrow(object, method, objectInputStream, arrayList);
                        break;
                    }
                    default: {
                        throw new ProtocolException("invalid response code " + n);
                    }
                }
                objectInputStream.close();
            }
            bl = true;
        }
        catch (Exception exception) {
            RemoteException remoteException;
            boolean bl5 = false;
            if (exception instanceof IOException) {
                if (!bl4 && outboundRequest.getDeliveryStatus()) {
                    remoteException = new UnmarshalException("exception unmarshalling response", exception);
                } else {
                    remoteException = BasicInvocationHandler.wrapSafeIOException((IOException)exception, this.oe);
                    bl5 = !bl4;
                }
            } else if (exception instanceof ClassNotFoundException) {
                remoteException = new UnmarshalException("error unmarshalling response", exception);
            }
            Failure failure = new Failure(remoteException, !bl4 || !outboundRequest.getDeliveryStatus());
            return failure;
        }
        finally {
            if (!bl) {
                outboundRequest.abort();
            }
        }
        if (object2 != null) {
            if (logger.isLoggable(Levels.FAILED)) {
                this.logThrow(Levels.FAILED, method, (Throwable)object2, true);
            }
            throw object2;
        }
        return object3;
    }

    private static RemoteException wrapSafeIOException(IOException iOException, ObjectEndpoint objectEndpoint) {
        if (iOException instanceof UnknownHostException) {
            return new java.rmi.UnknownHostException("unknown host in " + objectEndpoint, iOException);
        }
        if (iOException instanceof ConnectException) {
            return new java.rmi.ConnectException("connection refused or timed out to " + objectEndpoint, iOException);
        }
        return new ConnectIOException("I/O exception connecting to " + objectEndpoint, iOException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InvocationConstraints getConstraints(Method method) {
        if (this.clientConstraints == null && this.serverConstraints == null) {
            return InvocationConstraints.EMPTY;
        }
        Object object = this.cacheLock;
        synchronized (object) {
            if (this.methodCache == null) {
                this.methodCache = new Method[3];
                this.constraintCache = new InvocationConstraints[3];
                this.cacheIndex = 2;
            } else {
                int n = 3;
                while (--n >= 0) {
                    if (this.methodCache[n] != method) continue;
                    return this.constraintCache[n].makeAbsolute();
                }
            }
            InvocationConstraints invocationConstraints = InvocationConstraints.combine(this.clientConstraints == null ? null : this.clientConstraints.getConstraints(method), this.serverConstraints == null ? null : this.serverConstraints.getConstraints(method));
            this.methodCache[this.cacheIndex] = method;
            this.constraintCache[this.cacheIndex] = invocationConstraints;
            this.cacheIndex = this.cacheIndex == 0 ? 2 : this.cacheIndex - 1;
            return invocationConstraints.makeAbsolute();
        }
    }

    protected InvocationHandler setClientConstraints(MethodConstraints methodConstraints) {
        Class<?> clazz = this.getClass();
        try {
            Constructor<?> constructor = clazz.getConstructor(clazz, MethodConstraints.class);
            return (BasicInvocationHandler)constructor.newInstance(this, methodConstraints);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new UndeclaredThrowableException(exception, "exception constructing invocation handler");
        }
    }

    protected ObjectOutputStream createMarshalOutputStream(Object object, Method method, OutboundRequest outboundRequest, Collection collection) throws IOException {
        if (object == null || method == null) {
            throw new NullPointerException();
        }
        OutputStream outputStream = outboundRequest.getRequestOutputStream();
        Collection collection2 = Collections.unmodifiableCollection(collection);
        return new MarshalOutputStream(outputStream, collection2);
    }

    protected ObjectInputStream createMarshalInputStream(Object object, Method method, OutboundRequest outboundRequest, boolean bl, Collection collection) throws IOException {
        if (method == null) {
            throw new NullPointerException();
        }
        if (Proxy.getInvocationHandler(object) != this) {
            throw new IllegalArgumentException("not proxy for this");
        }
        ClassLoader classLoader = BasicInvocationHandler.getProxyLoader(object.getClass());
        Collection collection2 = Collections.unmodifiableCollection(collection);
        MarshalInputStream marshalInputStream = new MarshalInputStream(outboundRequest.getResponseInputStream(), classLoader, bl, classLoader, collection2);
        marshalInputStream.useCodebaseAnnotations();
        return marshalInputStream;
    }

    private static ClassLoader getProxyLoader(final Class clazz) {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getClassLoader();
            }
        });
    }

    protected void marshalMethod(Object object, Method method, ObjectOutputStream objectOutputStream, Collection collection) throws IOException {
        if (object == null || method == null || collection == null) {
            throw new NullPointerException();
        }
        objectOutputStream.writeLong(Util.getMethodHash(method));
    }

    protected void marshalArguments(Object object, Method method, Object[] objectArray, ObjectOutputStream objectOutputStream, Collection collection) throws IOException {
        if (object == null || objectArray == null || objectOutputStream == null || collection == null) {
            throw new NullPointerException();
        }
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            Util.marshalValue(classArray[i], objectArray[i], objectOutputStream);
        }
    }

    protected Object unmarshalReturn(Object object, Method method, ObjectInputStream objectInputStream, Collection collection) throws IOException, ClassNotFoundException {
        if (object == null || objectInputStream == null || collection == null) {
            throw new NullPointerException();
        }
        Class<?> clazz = method.getReturnType();
        Object object2 = null;
        if (clazz != Void.TYPE) {
            object2 = Util.unmarshalValue(clazz, objectInputStream);
        }
        return object2;
    }

    protected Throwable unmarshalThrow(Object object, Method method, ObjectInputStream objectInputStream, Collection collection) throws IOException, ClassNotFoundException {
        if (object == null || method == null || collection == null) {
            throw new NullPointerException();
        }
        Throwable throwable = (Throwable)objectInputStream.readObject();
        Util.exceptionReceivedFromServer(throwable);
        if (!(throwable instanceof RuntimeException) && !(throwable instanceof Error)) {
            Class<?> clazz = object.getClass();
            try {
                method = clazz.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw (IllegalArgumentException)new IllegalArgumentException().initCause(noSuchMethodException);
            }
            Class<?>[] classArray = method.getExceptionTypes();
            Class<?> clazz2 = throwable.getClass();
            for (int i = 0; i < classArray.length; ++i) {
                if (!classArray[i].isAssignableFrom(clazz2)) continue;
                return throwable;
            }
            UnexpectedException unexpectedException = new UnexpectedException("unexpected exception");
            unexpectedException.detail = throwable;
            throwable = unexpectedException;
        }
        return throwable;
    }

    private void logCall(Method method, Object[] objectArray, InvocationConstraints invocationConstraints) {
        String string = "outbound call {0}.{1} to {2}\n{3}";
        if (logger.isLoggable(Level.FINEST)) {
            string = "outbound call {0}.{1} to {2}\nargs {4}\n{3}";
        }
        List<Object> list = objectArray == null ? Collections.EMPTY_LIST : Arrays.asList(objectArray);
        logger.logp(Level.FINE, this.getClass().getName(), "invoke", string, new Object[]{method.getDeclaringClass().getName(), method.getName(), this.oe, invocationConstraints, list});
    }

    private void logReturn(Method method, Object object) {
        String string = "outbound call {0}.{1} returns";
        if (logger.isLoggable(Level.FINEST) && method.getReturnType() != Void.TYPE) {
            string = "outbound call {0}.{1} returns {2}";
        }
        logger.logp(Level.FINE, this.getClass().getName(), "invoke", string, new Object[]{method.getDeclaringClass().getName(), method.getName(), object});
    }

    private void logThrow(Level level, Method method, Throwable throwable, boolean bl) {
        LogRecord logRecord = new LogRecord(level, bl ? "outbound call {0}.{1} remotely throws" : "outbound call {0}.{1} locally throws");
        logRecord.setLoggerName(logger.getName());
        logRecord.setSourceClassName(this.getClass().getName());
        logRecord.setSourceMethodName("invoke");
        logRecord.setParameters(new Object[]{method.getDeclaringClass().getName(), method.getName()});
        logRecord.setThrown(throwable);
        logger.log(logRecord);
    }

    public final ObjectEndpoint getObjectEndpoint() {
        return this.oe;
    }

    public final MethodConstraints getClientConstraints() {
        return this.clientConstraints;
    }

    public final MethodConstraints getServerConstraints() {
        return this.serverConstraints;
    }

    public int hashCode() {
        return this.oe.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BasicInvocationHandler basicInvocationHandler = (BasicInvocationHandler)object;
        return Util.sameClassAndEquals(this.oe, basicInvocationHandler.oe) && Util.equals(this.clientConstraints, basicInvocationHandler.clientConstraints) && Util.equals(this.serverConstraints, basicInvocationHandler.serverConstraints);
    }

    public boolean checkTrustEquivalence(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BasicInvocationHandler basicInvocationHandler = (BasicInvocationHandler)object;
        return Util.checkTrustEquivalence(this.oe, basicInvocationHandler.oe) && Util.equals(this.clientConstraints, basicInvocationHandler.clientConstraints) && Util.equals(this.serverConstraints, basicInvocationHandler.serverConstraints);
    }

    public String toString() {
        return Util.getUnqualifiedName(this.getClass()) + "[" + this.oe + "]";
    }

    private String proxyToString(Object object) {
        Class<?>[] classArray = object.getClass().getInterfaces();
        if (classArray.length == 0) {
            return "Proxy[" + this + "]";
        }
        String string = classArray[0].getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return "Proxy[" + string + "," + this + "]";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.oe == null) {
            throw new InvalidObjectException("null object endpoint");
        }
        this.cacheLock = new Object();
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("no data in stream; class: " + this.getClass().getName());
    }

    private static class Failure {
        final Throwable exception;
        final boolean retry;

        Failure(Throwable throwable, boolean bl) {
            this.exception = throwable;
            this.retry = bl;
        }
    }
}

