/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlservices;

import com.mathworks.jmi.Matlab;
import javax.swing.event.ChangeEvent;

public final class MLExecutionEvent
extends ChangeEvent {
    public static final int NO_NON_MATLAB_STATUS = -1;
    private int fPrompt = Matlab.NO_PROMPT;
    private int fLastNonNullPrompt = Matlab.BASE_PROMPT;
    private int fBlock = 0;
    private int fRawStatus = -1;
    private boolean fProfiling = false;
    private InterpretedStatus fNonMATLABStatus = InterpretedStatus.UNSET;
    private InterpretedStatus fInterpretedStatus = InterpretedStatus.UNSET;
    private static MLExecutionEvent sTheEvent;
    private int fHGStatus;
    private static final int HG_VALID = 64;

    private MLExecutionEvent(Object object, int n, InterpretedStatus interpretedStatus) {
        super(object);
        this.setStatus(n, interpretedStatus);
    }

    private void extractStatus() {
        if (this.fNonMATLABStatus != InterpretedStatus.UNSET) {
            switch (this.fNonMATLABStatus) {
                case START_EVAL: {
                    this.fRawStatus |= 0xFF00;
                    break;
                }
                case PROFILER_ON: {
                    this.fProfiling = true;
                    break;
                }
                case PROFILER_OFF: {
                    this.fProfiling = false;
                }
            }
        }
        int n = this.fPrompt;
        this.fPrompt = Matlab.getInputRequester((int)this.fRawStatus);
        if (n != Matlab.NO_PROMPT) {
            this.fLastNonNullPrompt = n;
        }
        this.fBlock = Matlab.getCodeBlockStatus((int)this.fRawStatus);
    }

    public synchronized int getRawStatus() {
        return this.fRawStatus;
    }

    public synchronized boolean fromInterpreter() {
        switch (this.getInterpretedStatus()) {
            case AT_BREAKPOINT: 
            case AWAITING_INPUT: 
            case COMPLETING_BLOCK: 
            case IDLE: 
            case IDLE_AND_PROFILING: 
            case PAUSED: {
                return true;
            }
        }
        return false;
    }

    public synchronized boolean getHGBusy() {
        int n = this.getHGStatus();
        return (n & 6) != 0;
    }

    public synchronized int getHGStatus() {
        return Matlab.getHGStatus((int)this.fRawStatus);
    }

    public static MLExecutionEvent getInstance(Object object, int n, InterpretedStatus interpretedStatus) {
        if (sTheEvent == null) {
            sTheEvent = new MLExecutionEvent(object, n, interpretedStatus);
        }
        return sTheEvent;
    }

    public synchronized InterpretedStatus getInterpretedStatus() {
        if (this.fInterpretedStatus == InterpretedStatus.UNSET) {
            this.fInterpretedStatus = this.interpretStatus();
        }
        return this.fInterpretedStatus;
    }

    private InterpretedStatus interpretStatus() {
        switch (this.fNonMATLABStatus) {
            case START_EVAL: 
            case BANG: {
                if (this.fProfiling) {
                    return InterpretedStatus.BUSY_AND_PROFILING;
                }
                return InterpretedStatus.BUSY;
            }
            case BANG_FINISH: {
                this.fNonMATLABStatus = InterpretedStatus.UNSET;
            }
        }
        if (this.fNonMATLABStatus != InterpretedStatus.UNSET) {
            return this.fNonMATLABStatus;
        }
        if (this.fBlock == 1) {
            return InterpretedStatus.COMPLETING_BLOCK;
        }
        if (this.fPrompt == Matlab.NO_PROMPT) {
            if (this.fProfiling) {
                return InterpretedStatus.BUSY_AND_PROFILING;
            }
            return InterpretedStatus.BUSY;
        }
        if (this.fPrompt == Matlab.DEBUG_PROMPT) {
            return InterpretedStatus.AT_BREAKPOINT;
        }
        if (this.fPrompt == Matlab.PAUSE_PROMPT) {
            return InterpretedStatus.PAUSED;
        }
        if (this.fPrompt == Matlab.INPUT_PROMPT || this.fPrompt == Matlab.KEYBOARD_PROMPT) {
            return InterpretedStatus.AWAITING_INPUT;
        }
        if (this.fProfiling) {
            return InterpretedStatus.IDLE_AND_PROFILING;
        }
        return InterpretedStatus.IDLE;
    }

    public synchronized boolean isAtKeyboard() {
        return this.fPrompt == Matlab.KEYBOARD_PROMPT;
    }

    public synchronized boolean isAwaitingInput() {
        return this.fPrompt == Matlab.INPUT_PROMPT;
    }

    public synchronized boolean isEnteringInputMode() {
        return this.fPrompt == Matlab.INPUT_PROMPT && this.fPrompt != this.fLastNonNullPrompt;
    }

    public synchronized boolean isEnteringKeyboardMode() {
        return this.fPrompt == Matlab.KEYBOARD_PROMPT && this.fPrompt != this.fLastNonNullPrompt;
    }

    public synchronized boolean isCommandBusy() {
        return this.getInterpretedStatus() == InterpretedStatus.BUSY || this.getInterpretedStatus() == InterpretedStatus.BUSY_AND_PROFILING;
    }

    public synchronized boolean isCommandInProgress() {
        return !this.isCommandOver();
    }

    public synchronized boolean isCommandOver() {
        InterpretedStatus interpretedStatus = this.getInterpretedStatus();
        return interpretedStatus == InterpretedStatus.IDLE || interpretedStatus == InterpretedStatus.IDLE_AND_PROFILING;
    }

    public synchronized boolean isIncomplete() {
        return this.getInterpretedStatus() == InterpretedStatus.COMPLETING_BLOCK;
    }

    public synchronized void setStatus(int n, InterpretedStatus interpretedStatus) {
        this.fInterpretedStatus = InterpretedStatus.UNSET;
        this.fNonMATLABStatus = interpretedStatus;
        if (interpretedStatus == InterpretedStatus.UNSET) {
            if (n == -256) {
                n = (Matlab.getInputRequester((int)n) & 0xFF) << 8;
            }
            int n2 = Matlab.getInputRequester((int)n);
            if ((Matlab.getHGStatus((int)n) & 0x40) == 0) {
                n |= this.fHGStatus & 0x3F000000;
            }
            this.fHGStatus = n = n & 0xFFFF00FF | (n2 & 0xFF) << 8;
            this.fRawStatus = n;
            this.fNonMATLABStatus = InterpretedStatus.UNSET;
        }
        this.extractStatus();
    }

    public static enum InterpretedStatus {
        UNSET,
        INITIALIZING,
        IDLE,
        IDLE_AND_PROFILING,
        BUSY,
        BUSY_AND_PROFILING,
        PAUSED,
        AT_BREAKPOINT,
        AWAITING_INPUT,
        COMPLETING_BLOCK,
        BANG,
        BANG_FINISH,
        START_EVAL,
        DESKTOP_UP,
        PROMPT_INSERT,
        PROFILER_ON,
        PROFILER_OFF;

    }
}

