/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlservices;

import com.mathworks.jmi.Matlab;
import com.mathworks.mlservices.MLExecute;
import com.mathworks.mlservices.MLExecutionListener;
import com.mathworks.mlservices.MLServices;
import com.mathworks.mlservices.MLServicesRegistry;
import com.mathworks.mlservices.MatlabExecutionErrorHandler;
import java.util.Enumeration;
import java.util.Vector;
import org.jetbrains.annotations.NotNull;

public class MLExecuteServices
extends MLServices {
    private static MLExecute sMLExecute;
    private static Matlab sMatlab;
    private static Vector<MLExecutionListener> sListenersToAdd;

    private MLExecuteServices() {
    }

    public static void executeCommand(String string) {
        MLExecuteServices.loadMLExecuteCommandService();
        if (sMLExecute != null) {
            sMLExecute.executeCommand(string);
        } else {
            sMatlab.evalConsoleOutput(string);
        }
    }

    public static void executeCommand(String string, @NotNull MatlabExecutionErrorHandler matlabExecutionErrorHandler) {
        MLExecuteServices.loadMLExecuteCommandService();
        if (sMLExecute != null) {
            sMLExecute.executeCommand(string, matlabExecutionErrorHandler);
        } else {
            sMatlab.evalConsoleOutput(string);
        }
    }

    public static void consoleEval(String string) {
        MLExecuteServices.loadMLExecuteCommandService();
        if (sMLExecute != null) {
            sMLExecute.consoleEval(string);
        } else {
            sMatlab.evalStreamOutput(string, null);
        }
    }

    public static void consoleEval(String string, int n) {
        MLExecuteServices.loadMLExecuteCommandService();
        if (sMLExecute != null) {
            sMLExecute.consoleEval(string, n);
        } else {
            sMatlab.evalStreamOutput(string, null, n);
        }
    }

    public static synchronized void addMLExecutionListener(MLExecutionListener mLExecutionListener) {
        MLExecuteServices.loadMLExecuteCommandService();
        if (sMLExecute != null) {
            sMLExecute.addMLExecutionListener(mLExecutionListener);
        } else {
            sListenersToAdd.add(mLExecutionListener);
        }
    }

    public static void removeMLExecutionListener(MLExecutionListener mLExecutionListener) {
        MLExecuteServices.loadMLExecuteCommandService();
        if (sMLExecute != null) {
            sMLExecute.removeMLExecutionListener(mLExecutionListener);
        } else {
            sListenersToAdd.remove(mLExecutionListener);
        }
    }

    private static synchronized void loadMLExecuteCommandService() {
        if (sMLExecute == null && (sMLExecute = (MLExecute)MLExecuteServices.getRegisteredService(MLServicesRegistry.MLEXECUTE_REGISTRAR, "getMLExecute")) != null) {
            Enumeration<MLExecutionListener> enumeration = sListenersToAdd.elements();
            while (enumeration.hasMoreElements()) {
                MLExecuteServices.addMLExecutionListener(enumeration.nextElement());
            }
        }
    }

    static {
        sMatlab = new Matlab();
        sListenersToAdd = new Vector();
        MLServicesRegistry.addRegistrationListener(new ServicesRegistryListener());
    }

    private static class ServicesRegistryListener
    implements MLServicesRegistry.Listener {
        private ServicesRegistryListener() {
        }

        @Override
        public void registrationChanged(String string) {
            if (string.equals("getMLExecute")) {
                sMLExecute = null;
            }
        }
    }
}

