/*
 * Decompiled with CFR 0.152.
 */
package org.openide;

import java.util.Date;

public abstract class ErrorManager {
    public static final int UNKNOWN = 0;
    public static final int INFORMATIONAL = 1;
    public static final int WARNING = 16;
    public static final int USER = 256;
    public static final int EXCEPTION = 4096;
    public static final int ERROR = 65536;
    private static ErrorManager current;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ErrorManager getDefault() {
        Class<ErrorManager> clazz = ErrorManager.class;
        synchronized (ErrorManager.class) {
            if (current != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return current;
            }
            current = new PrintErrorManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return current;
        }
    }

    public abstract Throwable attachAnnotations(Throwable var1, Annotation[] var2);

    public abstract Annotation[] findAnnotations(Throwable var1);

    public abstract Throwable annotate(Throwable var1, int var2, String var3, String var4, Throwable var5, Date var6);

    public abstract void notify(int var1, Throwable var2);

    public final void notify(Throwable throwable) {
        this.notify(0, throwable);
    }

    public abstract void log(int var1, String var2);

    public final void log(String string) {
        this.log(1, string);
    }

    public boolean isLoggable(int n) {
        return true;
    }

    public boolean isNotifiable(int n) {
        return this.isLoggable(n);
    }

    public abstract ErrorManager getInstance(String var1);

    public final Throwable annotate(Throwable throwable, String string) {
        return this.annotate(throwable, 0, null, string, null, null);
    }

    public final Throwable annotate(Throwable throwable, Throwable throwable2) {
        return this.annotate(throwable, 0, null, null, throwable2, null);
    }

    public final Throwable copyAnnotation(Throwable throwable, Throwable throwable2) {
        return this.annotate(throwable, 0, null, null, throwable2, null);
    }

    private static class PrintErrorManager
    extends ErrorManager {
        private PrintErrorManager() {
        }

        @Override
        public ErrorManager getInstance(String string) {
            return this;
        }

        @Override
        public Throwable attachAnnotations(Throwable throwable, Annotation[] annotationArray) {
            return throwable;
        }

        @Override
        public Annotation[] findAnnotations(Throwable throwable) {
            return new Annotation[0];
        }

        @Override
        public Throwable annotate(Throwable throwable, int n, String string, String string2, Throwable throwable2, Date date) {
            return throwable;
        }

        @Override
        public void notify(int n, Throwable throwable) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                throwable.printStackTrace();
            }
        }

        @Override
        public void log(int n, String string) {
            System.err.println("Log: " + n + " msg: " + string);
        }

        @Override
        public boolean isLoggable(int n) {
            return Boolean.getBoolean("netbeans.debug.exceptions") && n != 1;
        }

        @Override
        public boolean isNotifiable(int n) {
            return Boolean.getBoolean("netbeans.debug.exceptions");
        }
    }

    public static interface Annotation {
        public String getMessage();

        public String getLocalizedMessage();

        public Throwable getStackTrace();

        public Date getDate();

        public int getSeverity();
    }
}

