/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.nio.charset.Charset;
import java.util.Set;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.javax.xml.xquery.XQMetaData;

public class SaxonXQMetaData
implements XQMetaData {
    private Configuration config;

    public SaxonXQMetaData(Configuration config) {
        this.config = config;
    }

    public int getMaxExpressionLength() {
        return Integer.MAX_VALUE;
    }

    public int getMaxUserNameLength() {
        return Integer.MAX_VALUE;
    }

    public int getProductMajorVersion() {
        return Version.getStructuredVersionNumber()[0];
    }

    public int getProductMinorVersion() {
        return Version.getStructuredVersionNumber()[1];
    }

    public String getProductName() {
        return Version.getProductName();
    }

    public String getProductVersion() {
        return Version.getProductVersion();
    }

    public Set getSupportedXQueryEncodings() {
        return Charset.availableCharsets().keySet();
    }

    public String getUserName() {
        return null;
    }

    public int getXQJMajorVersion() {
        return 0;
    }

    public int getXQJMinorVersion() {
        return 9;
    }

    public String getXQJVersion() {
        return "0.9";
    }

    public boolean isFullAxisFeatureSupported() {
        return true;
    }

    public boolean isModuleFeatureSupported() {
        return true;
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isSchemaImportFeatureSupported() {
        return this.config.isSchemaAware(51);
    }

    public boolean isSchemaValidationFeatureSupported() {
        return this.config.isSchemaAware(51);
    }

    public boolean isSerializationFeatureSupported() {
        return true;
    }

    public boolean isStaticTypingExtensionsSupported() {
        return false;
    }

    public boolean isStaticTypingFeatureSupported() {
        return false;
    }

    public boolean isTransactionSupported() {
        return false;
    }

    public boolean isUserDefinedXMLSchemaTypeSupported() {
        return this.config.isSchemaAware(51);
    }

    public boolean isXQueryEncodingDeclSupported() {
        return true;
    }

    public boolean isXQueryEncodingSupported(String encoding) {
        return this.getSupportedXQueryEncodings().contains(encoding);
    }

    public boolean isXQueryXSupported() {
        return false;
    }

    public boolean wasCreatedFromJDBCConnection() {
        return false;
    }
}

