/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Properties;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.sax.SAXResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.functions.Insert;
import net.sf.saxon.javax.xml.xquery.XQConnection;
import net.sf.saxon.javax.xml.xquery.XQException;
import net.sf.saxon.javax.xml.xquery.XQItem;
import net.sf.saxon.javax.xml.xquery.XQItemAccessor;
import net.sf.saxon.javax.xml.xquery.XQItemType;
import net.sf.saxon.javax.xml.xquery.XQResultSequence;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pull.PullFromIterator;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.pull.PullToStax;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.xqj.SaxonXQConnection;
import net.sf.saxon.xqj.SaxonXQItem;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class SaxonXQForwardSequence
implements XQResultSequence {
    private SequenceIterator iterator;
    private SaxonXQConnection connection;
    int position = 0;
    boolean closed = false;

    protected SaxonXQForwardSequence(SequenceIterator iterator, SaxonXQConnection connection) {
        this.iterator = iterator;
        this.connection = connection;
    }

    SequenceIterator getCleanIterator() throws XPathException {
        return this.iterator.getAnother();
    }

    public XQConnection getConnection() {
        return this.connection;
    }

    public String getAtomicValue() throws XQException {
        return this.getCurrentXQItem().getAtomicValue();
    }

    public boolean getBoolean() throws XQException {
        return this.getCurrentXQItem().getBoolean();
    }

    public byte getByte() throws XQException {
        return this.getCurrentXQItem().getByte();
    }

    public double getDouble() throws XQException {
        return this.getCurrentXQItem().getDouble();
    }

    public float getFloat() throws XQException {
        return this.getCurrentXQItem().getFloat();
    }

    public int getInt() throws XQException {
        return this.getCurrentXQItem().getInt();
    }

    public XMLStreamReader getItemAsStream() throws XQException {
        return this.getCurrentXQItem().getItemAsStream();
    }

    public String getItemAsString(Properties props) throws XQException {
        return this.getCurrentXQItem().getItemAsString(props);
    }

    public XQItemType getItemType() throws XQException {
        return this.getCurrentXQItem().getItemType();
    }

    public long getLong() throws XQException {
        return this.getCurrentXQItem().getLong();
    }

    public Node getNode() throws XQException {
        return this.getCurrentXQItem().getNode();
    }

    public URI getNodeUri() throws XQException {
        return this.getCurrentXQItem().getNodeUri();
    }

    public Object getObject() throws XQException {
        return this.getCurrentXQItem().getObject();
    }

    public short getShort() throws XQException {
        return this.getCurrentXQItem().getShort();
    }

    public boolean instanceOf(XQItemType type) throws XQException {
        return this.getCurrentXQItem().instanceOf(type);
    }

    public void writeItem(OutputStream os, Properties props) throws XQException {
        this.getCurrentXQItem().writeItem(os, props);
    }

    public void writeItem(Writer ow, Properties props) throws XQException {
        this.getCurrentXQItem().writeItem(ow, props);
    }

    public void writeItemToResult(Result result) throws XQException {
        this.getCurrentXQItem().writeItemToResult(result);
    }

    public void writeItemToSAX(ContentHandler saxHandler) throws XQException {
        this.getCurrentXQItem().writeItemToSAX(saxHandler);
    }

    public boolean absolute(int itempos) throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    public void afterLast() throws XQException {
        this.checkNotClosed();
        this.position = -1;
    }

    public void beforeFirst() throws XQException {
        this.checkNotClosed();
        try {
            this.iterator = this.iterator.getAnother();
            this.position = 0;
        }
        catch (XPathException e) {
            throw this.newXQException((Exception)((Object)e));
        }
    }

    public void close() throws XQException {
        this.closed = true;
        this.iterator = null;
        this.connection = null;
    }

    public int count() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    public boolean first() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    public XQItem getItem() throws XQException {
        return new SaxonXQItem(this.iterator.current(), this.connection);
    }

    public int getPosition() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    public XMLStreamReader getSequenceAsStream() throws XQException {
        PullFromIterator provider = new PullFromIterator(this.iterator);
        provider.setPipelineConfiguration(this.connection.getConfiguration().makePipelineConfiguration());
        return new PullToStax((PullProvider)provider);
    }

    public String getSequenceAsString(Properties props) throws XQException {
        StringWriter sw = new StringWriter();
        this.writeSequence(sw, props);
        return sw.toString();
    }

    public boolean isAfterLast() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    public boolean isBeforeFirst() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isFirst() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    public boolean isLast() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    public boolean isOnItem() throws XQException {
        this.checkNotClosed();
        return this.position > 0;
    }

    public boolean isScrollable() throws XQException {
        this.checkNotClosed();
        return false;
    }

    public boolean last() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    public boolean next() throws XQException {
        this.checkNotClosed();
        if (this.position < 0) {
            return false;
        }
        try {
            Item next = this.iterator.next();
            if (next == null) {
                this.position = -1;
                return false;
            }
            ++this.position;
            return true;
        }
        catch (XPathException e) {
            throw this.newXQException((Exception)((Object)e));
        }
    }

    public boolean previous() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    public boolean relative(int itempos) throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    public void writeSequence(OutputStream os, Properties props) throws XQException {
        this.checkNotClosed();
        SequenceIterator iter = this.iterator;
        if (this.isOnItem()) {
            iter = new Insert.InsertIterator((SequenceIterator)SingletonIterator.makeIterator((Item)iter.current()), iter, 0);
        }
        try {
            QueryResult.serializeSequence((SequenceIterator)iter, (Configuration)this.connection.getConfiguration(), (OutputStream)os, (Properties)props);
        }
        catch (XPathException e) {
            throw this.newXQException((Exception)((Object)e));
        }
    }

    public void writeSequence(Writer ow, Properties props) throws XQException {
        this.checkNotClosed();
        PrintWriter pw = ow instanceof PrintWriter ? (PrintWriter)ow : new PrintWriter(ow);
        SequenceIterator iter = this.iterator;
        if (this.isOnItem()) {
            iter = new Insert.InsertIterator((SequenceIterator)SingletonIterator.makeIterator((Item)iter.current()), iter, 0);
        }
        try {
            QueryResult.serializeSequence((SequenceIterator)iter, (Configuration)this.connection.getConfiguration(), (Writer)pw, (Properties)props);
        }
        catch (XPathException e) {
            throw this.newXQException((Exception)((Object)e));
        }
    }

    public void writeSequenceToResult(Result result) throws XQException {
        try {
            QueryResult.serializeSequence((SequenceIterator)this.iterator, (Configuration)this.connection.getConfiguration(), (Result)result, (Properties)new Properties());
        }
        catch (XPathException e) {
            throw this.newXQException((Exception)((Object)e));
        }
    }

    public void writeSequenceToSAX(ContentHandler saxHandler) throws XQException {
        this.writeSequenceToResult(new SAXResult(saxHandler));
    }

    private XQItemAccessor getCurrentXQItem() throws XQException {
        this.checkNotClosed();
        if (this.position == 0) {
            throw new XQException("The XQSequence is positioned before the first item");
        }
        if (this.position < 0) {
            throw new XQException("The XQSequence is positioned after the last item");
        }
        return new SaxonXQItem(this.iterator.current(), this.connection);
    }

    private void checkNotClosed() throws XQException {
        if (this.closed) {
            throw new XQException("The XQSequence has been closed");
        }
    }

    private XQException newXQException(Exception err) {
        XQException xqe = new XQException(err.getMessage());
        xqe.initCause(err);
        return xqe;
    }
}

