/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.fixedpoint;

import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.toolbox.fixedpoint.FixedPointFunctionAbstractPanel;
import com.mathworks.toolbox.fixedpoint.FixedPointMenuAction;
import com.mathworks.toolbox.fixedpoint.TextWidget;
import com.mathworks.toolbox.fixedpoint.Utilities;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;

public class NumericTypePanel
extends FixedPointFunctionAbstractPanel {
    public static final String DATA_TYPE_COMBOBOX_NAME = "dataTypeModeComboBox";
    public static final String SIGNED_MODE_COMBOBOX_NAME = "signedModeComboBox";
    public static final String WORD_LENGTH_FIELD_NAME = "wordLengthField";
    public static final String FRACTION_LENGTH_FIELD_NAME = "fractionLengthField";
    public static final String SLOPE_FIELD_NAME = "slopeLengthField";
    public static final String BIAS_FIELD_NAME = "biasField";
    public static final String WORD_LENGTH_DEFAULT = "16";
    public static final String FRACTION_LENGTH_DEFAULT = "15";
    public static final String SLOPE_DEFAULT = "2^-15";
    public static final String BIAS_DEFAULT = "0";
    private ParamValueMode fParamValueMode = ParamValueMode.PAIR;
    private final boolean fSimpleMode;
    private MJComboBox fDataTypeModeComboBox;
    private MJCheckBox fSignedCheckBox;
    private MJComboBox fSignedModeComboBox;
    private TextWidget fBiasTextField;
    private TextWidget fFractionLengthTextField;
    private TextWidget fSlopeTextField;
    private TextWidget fWordLengthTextField;
    private MJLabel fBiasLabel;
    private MJLabel fSignedModeLabel;
    private MJLabel fFractionLengthLabel;
    private MJLabel fSlopeLabel;
    private MJLabel fWordLengthLabel;

    public NumericTypePanel(ParamValueMode paramValueMode, boolean bl) {
        this.fParamValueMode = paramValueMode;
        this.fSimpleMode = bl;
        this.initComponents();
    }

    @Override
    public String getFunctionName() {
        return "numerictype";
    }

    @Override
    public Map<String, String> getParameterMap() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        ParamValueMode paramValueMode = this.fParamValueMode;
        boolean bl = false;
        if (this.fSignedModeComboBox.isVisible() && this.fSignedModeComboBox.getSelectedItem() == SignedMode.AUTO) {
            bl = true;
        }
        if (!this.fSimpleMode && ((DataTypeMode)((Object)this.fDataTypeModeComboBox.getSelectedItem())).isForceParamValue()) {
            bl = true;
        }
        if (paramValueMode == ParamValueMode.PAIR || bl) {
            linkedHashMap.put("DataTypeMode", Utilities.quoteSelection(this.fDataTypeModeComboBox));
            if (this.fSignedModeComboBox.isVisible()) {
                linkedHashMap.put("Signedness", Utilities.quoteSelection(this.fSignedModeComboBox));
            }
            if (this.fWordLengthTextField.isVisible()) {
                linkedHashMap.put("WordLength", this.fWordLengthTextField.getText());
            }
            if (this.fFractionLengthTextField.isVisible()) {
                linkedHashMap.put("FractionLength", this.fFractionLengthTextField.getText());
            }
            if (this.fSlopeTextField.isVisible()) {
                linkedHashMap.put("Slope", this.fSlopeTextField.getText());
            }
            if (this.fBiasTextField.isVisible()) {
                linkedHashMap.put("Bias", this.fBiasTextField.getText());
            }
        } else {
            DataTypeMode dataTypeMode = (DataTypeMode)((Object)this.fDataTypeModeComboBox.getSelectedItem());
            if (dataTypeMode.isLiteralValue()) {
                linkedHashMap.put("", Utilities.quoteSelection(this.fDataTypeModeComboBox));
            } else {
                StringBuilder stringBuilder = new StringBuilder("");
                stringBuilder.append(this.fSignedModeComboBox.getSelectedItem() == SignedMode.SIGNED ? "1" : BIAS_DEFAULT);
                if (this.fWordLengthTextField.isVisible()) {
                    stringBuilder.append(", ").append(this.fWordLengthTextField.getText());
                }
                if (this.fFractionLengthTextField.isVisible()) {
                    stringBuilder.append(", ").append(this.fFractionLengthTextField.getText());
                }
                if (this.fSlopeTextField.isVisible()) {
                    stringBuilder.append(", ").append(this.fSlopeTextField.getText());
                }
                if (this.fBiasTextField.isVisible()) {
                    stringBuilder.append(", ").append(this.fBiasTextField.getText());
                }
                linkedHashMap.put("", stringBuilder.toString());
            }
        }
        return linkedHashMap;
    }

    @Override
    public String getHelpFunction() {
        return "ref/numerictype.html";
    }

    @Override
    protected void updateComponents() {
        DataTypeMode dataTypeMode = (DataTypeMode)((Object)this.fDataTypeModeComboBox.getSelectedItem());
        boolean bl = dataTypeMode != DataTypeMode.BOOLEAN && dataTypeMode != DataTypeMode.SINGLE && dataTypeMode != DataTypeMode.DOUBLE;
        this.fSignedCheckBox.setVisible(bl);
        this.fSignedModeLabel.setVisible(bl);
        this.fSignedModeComboBox.setVisible(bl);
        this.fWordLengthLabel.setVisible(bl);
        this.fWordLengthTextField.setVisible(bl);
        boolean bl2 = dataTypeMode == DataTypeMode.FIXED_BINARY || dataTypeMode == DataTypeMode.SCALED_BINARY;
        this.fFractionLengthLabel.setVisible(bl2);
        this.fFractionLengthTextField.setVisible(bl2);
        boolean bl3 = dataTypeMode == DataTypeMode.FIXED_SLOPE_AND_BIAS || dataTypeMode == DataTypeMode.SCALED_SLOPE_AND_BIAS;
        this.fSlopeLabel.setVisible(bl3);
        this.fSlopeTextField.setVisible(bl3);
        this.fBiasLabel.setVisible(bl3);
        this.fBiasTextField.setVisible(bl3);
    }

    private void initComponents() {
        MJLabel mJLabel = new MJLabel(FixedPointMenuAction.BUNDLE.getString("DataTypeModePromptStr"));
        this.fDataTypeModeComboBox = new MJComboBox(new DefaultComboBoxModel<DataTypeMode>(this.fSimpleMode ? DataTypeMode.getSimpleValues() : DataTypeMode.values()));
        this.fDataTypeModeComboBox.setName(DATA_TYPE_COMBOBOX_NAME);
        this.fDataTypeModeComboBox.setSelectedItem((Object)(this.fSimpleMode ? DataTypeMode.FIXED_UNSPECIFIED : DataTypeMode.FIXED_BINARY));
        this.fSignedModeLabel = new MJLabel(FixedPointMenuAction.BUNDLE.getString("SignednessPromptStr"));
        this.fSignedModeComboBox = new MJComboBox(new DefaultComboBoxModel<SignedMode>(SignedMode.values()));
        this.fSignedModeComboBox.setName(SIGNED_MODE_COMBOBOX_NAME);
        this.fWordLengthLabel = new MJLabel(FixedPointMenuAction.BUNDLE.getString("WordLengthPromptStr"));
        this.fSignedCheckBox = new MJCheckBox(FixedPointMenuAction.BUNDLE.getString("SignedStr"), true);
        this.fFractionLengthLabel = new MJLabel(FixedPointMenuAction.BUNDLE.getString("FractionLengthPromptStr"));
        this.fSlopeLabel = new MJLabel(FixedPointMenuAction.BUNDLE.getString("SlopePromptStr"));
        this.fBiasLabel = new MJLabel(FixedPointMenuAction.BUNDLE.getString("BiasPromptStr"));
        this.fWordLengthTextField = new TextWidget(WORD_LENGTH_DEFAULT, WORD_LENGTH_FIELD_NAME);
        this.fFractionLengthTextField = new TextWidget(FRACTION_LENGTH_DEFAULT, FRACTION_LENGTH_FIELD_NAME);
        this.fSlopeTextField = new TextWidget(SLOPE_DEFAULT, SLOPE_FIELD_NAME);
        this.fBiasTextField = new TextWidget(BIAS_DEFAULT, BIAS_FIELD_NAME);
        this.addComponentPair((Component)mJLabel, (Component)this.fDataTypeModeComboBox);
        this.addComponentPair((Component)this.fSignedModeLabel, (Component)this.fSignedModeComboBox);
        this.addComponentPair((Component)this.fWordLengthLabel, this.fWordLengthTextField.getComponent());
        this.addComponentPair((Component)this.fFractionLengthLabel, this.fFractionLengthTextField.getComponent());
        this.addComponentPair((Component)this.fSlopeLabel, this.fSlopeTextField.getComponent());
        this.addComponentPair((Component)this.fBiasLabel, this.fBiasTextField.getComponent());
        this.fDataTypeModeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NumericTypePanel.this.updatePanel();
            }
        });
    }

    public static enum SignedMode {
        SIGNED("Signed"),
        UNSIGNED("Unsigned"),
        AUTO("Auto");

        private final String fLabel;

        public String toString() {
            return this.fLabel;
        }

        private SignedMode(String string2) {
            this.fLabel = string2;
        }
    }

    public static enum DataTypeMode {
        BOOLEAN("Boolean", false, true),
        SINGLE("Single", false, true),
        DOUBLE("Double", false, true),
        FIXED_UNSPECIFIED("Fixed-point: unspecified scaling"),
        FIXED_BINARY("Fixed-point: binary point scaling"),
        FIXED_SLOPE_AND_BIAS("Fixed-point: slope and bias scaling"),
        SCALED_UNSPECIFIED("Scaled double: unspecified scaling", true),
        SCALED_BINARY("Scaled double: binary point scaling", true),
        SCALED_SLOPE_AND_BIAS("Scaled double: slope and bias scaling", true);

        private final String fLabel;
        private final boolean fForceParamValue;
        private final boolean fIsLiteralValue;

        public static DataTypeMode[] getSimpleValues() {
            return new DataTypeMode[]{FIXED_UNSPECIFIED, FIXED_BINARY, FIXED_SLOPE_AND_BIAS};
        }

        public String toString() {
            return this.fLabel;
        }

        public boolean isForceParamValue() {
            return this.fForceParamValue;
        }

        public boolean isLiteralValue() {
            return this.fIsLiteralValue;
        }

        private DataTypeMode(String string2) {
            this(string2, false);
        }

        private DataTypeMode(String string2, boolean bl) {
            this(string2, bl, false);
        }

        private DataTypeMode(String string2, boolean bl, boolean bl2) {
            this.fLabel = string2;
            this.fIsLiteralValue = bl2;
            this.fForceParamValue = bl;
        }
    }

    public static enum ParamValueMode {
        PAIR,
        CONDENSED;

    }
}

