/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DOptionElement;
import ice.pilots.html4.DSelectElement;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.swing.DocView;
import ice.pilots.html4.swing.Movable;
import ice.pilots.html4.swing.MyList;
import ice.pilots.html4.swing.OptionListModel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class FormSelectList
extends JScrollPane
implements DSelectElement.SelectPainter,
ListSelectionListener,
Movable {
    private DocView docView;
    private DSelectElement sel;
    private ObjectBox box;
    private JList list;
    private boolean ignoreItemChange;
    private Border _originalBorder = this.getBorder();

    FormSelectList(DocView docView, DElement dElement, int n) {
        this.docView = docView;
        this.sel = (DSelectElement)dElement;
        this.list = new MyList(docView);
        this.list.setVisibleRowCount(n);
        int n2 = 0;
        if (this.sel.getMultiple()) {
            n2 = 2;
        }
        this.list.setSelectionMode(n2);
        this.copyOptionsToView();
        this.setViewportView(this.list);
        this.list.addListSelectionListener(this);
    }

    public void paintComponent(Graphics graphics) {
        if (this.isShowing()) {
            super.paintComponent(graphics);
        } else {
            graphics.translate(1, 1);
            graphics.setColor(Color.white);
            graphics.setClip(0, 0, this.getSize().width - 2, this.getSize().height - 2);
            graphics.fillRect(0, 0, this.getSize().width - 2, this.getSize().height - 2);
            graphics.setColor(Color.lightGray);
            graphics.drawRect(0, 0, this.getSize().width - 2, this.getSize().height - 2);
            graphics.setColor(Color.black);
            String string = (String)this.list.getSelectedValue();
            FontMetrics fontMetrics = graphics.getFontMetrics();
            fontMetrics = this.getFontMetrics(this.getFont());
            int n = this.getSize().height / this.list.getVisibleRowCount();
            int n2 = n - fontMetrics.getDescent() - 2;
            for (int i = 0; i < this.list.getVisibleRowCount(); ++i) {
                string = (String)this.list.getModel().getElementAt(i);
                graphics.drawString(string, 2, n2);
                n2 += n;
            }
        }
    }

    private void setListCellHeight() {
        if (this.sel == null) {
            return;
        }
        DOptionElement dOptionElement = this.sel.getDOption(0);
        if (dOptionElement != null && dOptionElement.getText() != null) {
            return;
        }
        Font font = this.list.getFont();
        FontMetrics fontMetrics = this.list.getFontMetrics(font);
        this.list.setFixedCellHeight(fontMetrics.getHeight());
    }

    private void copyOptionsToView() {
        this.ignoreItemChange = true;
        this.list.setModel(new OptionListModel(this.sel));
        this.checkAttributes();
        this.ignoreItemChange = false;
        this.updateSelection();
    }

    private void updateSelection() {
        this.ignoreItemChange = true;
        this.list.clearSelection();
        if (this.list.getSelectionMode() == 0) {
            int n = this.sel.getSelectedIndex();
            if (n >= 0) {
                this.list.addSelectionInterval(n, n);
            }
        } else {
            DOptionElement dOptionElement = this.sel.firstDOption();
            int n = 0;
            while (dOptionElement != null) {
                if (dOptionElement.getSelected()) {
                    this.list.addSelectionInterval(n, n);
                }
                dOptionElement = this.sel.nextDOption(dOptionElement);
                ++n;
            }
        }
        this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
        this.ignoreItemChange = false;
    }

    private void checkAttributes() {
        this.list.setEnabled(!this.sel.getDisabled());
        this.setListCellHeight();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!this.ignoreItemChange) {
            DOptionElement dOptionElement = this.sel.firstDOption();
            int n = 0;
            while (dOptionElement != null) {
                if (dOptionElement.getSelected() != this.list.isSelectedIndex(n)) {
                    this.sel.setSelectedIndexByUser(n);
                }
                dOptionElement = this.sel.nextDOption(dOptionElement);
                ++n;
            }
        }
        this.updateFont();
    }

    public void onElementAttrChange(DElement dElement, DAttr dAttr) {
        this.checkAttributes();
    }

    public void onOptionStructChange() {
        this.copyOptionsToView();
    }

    public void onOptionSelectionChange() {
        this.updateSelection();
    }

    public void onOptionAttrChange(DOptionElement dOptionElement, DAttr dAttr) {
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.list != null) {
            this.list.setFont(font);
        }
        this.setListCellHeight();
    }

    public void setFontHints(CSSAttribs cSSAttribs) {
        this.updateFont();
    }

    private void updateFont() {
        if (this.list == null) {
            return;
        }
        if (this.box != null) {
            StringBuffer stringBuffer = new StringBuffer();
            ListModel listModel = this.list.getModel();
            for (int i = 0; i < listModel.getSize(); ++i) {
                stringBuffer.append(listModel.getElementAt(i).toString());
            }
            CSSAttribs cSSAttribs = this.box.getCSSAttribs();
            Font font = cSSAttribs.getTestedFont(stringBuffer.toString());
            if (!font.equals(this.getFont())) {
                this.setFont(font);
            }
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.list != null) {
            this.list.setBackground(color);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.list != null) {
            this.list.setForeground(color);
        }
    }

    public void dispose() {
        Container container = this.getParent();
        if (container != null) {
            container.remove(this);
        }
    }

    public void setBox(ObjectBox objectBox) {
        this.box = objectBox;
        this.docView.checkAwtTree(objectBox, this);
        if (objectBox != null) {
            this.copyOptionsToView();
        }
    }

    public ObjectBox getBox() {
        return this.box;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int n, int n2) {
        this.setSize(n, n2);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public boolean isManagingFocus() {
        return true;
    }

    public void draw(Graphics graphics) {
    }

    public void syncDom(int n, int n2, boolean bl) {
        this.setLocation(n, n2);
        this.setVisible(bl);
    }

    public void setBorderVisible(boolean bl) {
        if (!bl) {
            this.setBorder(null);
        } else {
            this.setBorder(this._originalBorder);
        }
    }
}

