/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.util;

import com.mathworks.comparisons.util.ResourceManager;
import com.mathworks.services.Prefs;
import java.io.File;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class FileNameFilters {
    private String[] mFilters;
    private boolean mCaseInsensitive = new File("A").equals(new File("a"));
    private static FileNameFilters sCurrent;
    private static final String sDelimiter = "\"";
    public static final String sPrefName = "FileNameFilters";

    public static boolean isFilteredOut(String string) {
        if (sCurrent == null) {
            FileNameFilters.load();
        }
        return sCurrent.match(string) != -1;
    }

    public static void clear() {
        sCurrent = null;
    }

    public static FileNameFilters debugGetCurrent() {
        if (sCurrent == null) {
            FileNameFilters.load();
        }
        return sCurrent;
    }

    private FileNameFilters() {
        this.mFilters = FileNameFilters.getRawFilters();
        for (int i = 0; i < this.mFilters.length; ++i) {
            String string = this.mFilters[i];
            string = string.replace("\\", "\\\\");
            string = string.replace("/", "\\/");
            string = string.replace(".", "\\.");
            string = string.replace("*", "[^\\/]*");
            string = "(.*\\/)*" + string;
            if (string.endsWith("/")) {
                string = string + "(.*)";
            }
            if (this.mCaseInsensitive) {
                string = "(?i)" + string;
            }
            this.mFilters[i] = string;
        }
    }

    private static String[] getRawFilters() {
        String string = Prefs.getStringPref((String)sPrefName);
        StringTokenizer stringTokenizer = new StringTokenizer(string, sDelimiter);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        assert (!stringTokenizer.hasMoreTokens());
        return stringArray;
    }

    public static String[] get() {
        return FileNameFilters.getRawFilters();
    }

    private static void load() {
        sCurrent = new FileNameFilters();
    }

    public static void set(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                FileNameFilters.checkValidFilter(stringArray[i]);
                stringBuilder.append(stringArray[i]);
                if (i >= stringArray.length - 1) continue;
                stringBuilder.append(sDelimiter);
            }
        }
        String string = stringBuilder.toString();
        Prefs.setStringPref((String)sPrefName, (String)string);
        FileNameFilters.clear();
    }

    public static void checkValidFilter(String string) {
        if (string.contains(sDelimiter)) {
            String string2 = ResourceManager.format("exception.illegalfilter", string);
            throw new IllegalArgumentException(string2);
        }
    }

    public int match(String string) {
        for (int i = 0; i < this.mFilters.length; ++i) {
            if (!Pattern.matches(this.mFilters[i], string)) continue;
            return i;
        }
        return -1;
    }
}

