/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.selection.dialog;

import com.mathworks.comparisons.selection.InvalidConversionException;
import com.mathworks.comparisons.selection.SelectionPolicies;
import com.mathworks.comparisons.selection.SelectionPoliciesRegister;
import com.mathworks.comparisons.selection.StringConversionPolicy;
import com.mathworks.comparisons.selection.dialog.SourceSelectionErrorReporter;
import com.mathworks.comparisons.selection.dialog.SourceSelectionListModel;
import com.mathworks.comparisons.util.ResourceManager;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.ListDataListener;

public final class SourceSelectionComboBoxModel
implements MutableComboBoxModel {
    private Object mCurrentSelection;
    private final SourceSelectionListModel mListModel;
    private Class<?> mCurrentType;
    private StringConversionPolicy mCurrentStringConversionPolicy;
    private final SelectionPoliciesRegister mPoliciesRegister;
    private final SourceSelectionErrorReporter mErrorReporter;

    public SourceSelectionComboBoxModel(SelectionPoliciesRegister selectionPoliciesRegister, SourceSelectionListModel sourceSelectionListModel, SourceSelectionErrorReporter sourceSelectionErrorReporter) {
        this.mPoliciesRegister = selectionPoliciesRegister;
        this.mListModel = sourceSelectionListModel;
        this.mErrorReporter = sourceSelectionErrorReporter;
    }

    public void addElement(Object object) {
        this.mListModel.add(object);
    }

    @Override
    public void removeElement(Object object) {
        this.mListModel.remove(object);
    }

    public void insertElementAt(Object object, int n) {
        if (n == 0) {
            this.mListModel.add(object);
        }
    }

    @Override
    public void removeElementAt(int n) {
        Object object = this.mListModel.getElementAt(n);
        if (object != null) {
            this.removeElement(object);
        }
    }

    @Override
    public void setSelectedItem(Object object) {
        this.mCurrentSelection = object != null && object instanceof String ? this.convert((String)object) : object;
    }

    @Override
    public Object getSelectedItem() {
        return this.mCurrentSelection;
    }

    @Override
    public int getSize() {
        return this.mListModel.getSize();
    }

    @Override
    public Object getElementAt(int n) {
        return this.mListModel.getElementAt(n);
    }

    @Override
    public void addListDataListener(ListDataListener listDataListener) {
        this.mListModel.addListDataListener(listDataListener);
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
        this.mListModel.removeListDataListener(listDataListener);
    }

    public void setCurrentStringConversionPolicyClass(Class<?> clazz) {
        assert (clazz != null);
        if (!clazz.equals(this.mCurrentType)) {
            this.mCurrentType = clazz;
            this.updatePolicy(clazz);
        }
    }

    public Class<?> getCurrentStringConversionPolicyClass() {
        return this.mCurrentType;
    }

    private void updatePolicy(Class<?> clazz) {
        SelectionPolicies selectionPolicies = this.mPoliciesRegister.getPolicies(clazz);
        this.mCurrentStringConversionPolicy = selectionPolicies != null ? selectionPolicies.createStringConversionPolicy() : null;
        if (this.mCurrentStringConversionPolicy == null) {
            throw new UnsupportedOperationException(ResourceManager.getString("exception.unsupportedtype"));
        }
    }

    private Object convert(String string) {
        assert (this.mCurrentStringConversionPolicy != null);
        Object var2_2 = null;
        String string2 = "";
        try {
            var2_2 = this.mCurrentStringConversionPolicy.convert(string);
        }
        catch (InvalidConversionException invalidConversionException) {
            string2 = invalidConversionException.getMessage();
        }
        this.mErrorReporter.showError(string2);
        return var2_2;
    }
}

