/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.decorator.variable;

import com.mathworks.comparisons.decorator.variable.StructTableObject;
import com.mathworks.comparisons.decorator.variable.VariableDifferences;
import com.mathworks.comparisons.util.CheckNullArgument;
import com.mathworks.comparisons.util.ResourceManager;
import com.mathworks.widgets.recordlist.AbstractRecordlistModel;
import com.mathworks.widgets.recordlist.RecordlistModelEvent;

public class StructTableModel
extends AbstractRecordlistModel {
    private final Object fSemaphore = new Object();
    private StructTableObject[][] fData;
    private String fLeftFieldName;
    private String fRightFieldName;

    void setData(VariableDifferences.FieldEntry[] fieldEntryArray) {
        CheckNullArgument.check(fieldEntryArray, "data");
        this.fData = StructTableModel.convertFieldEntriesToTableObjects(fieldEntryArray);
        this.fireRecordlistModelEvent(new RecordlistModelEvent());
    }

    void setNames(String string, String string2) {
        this.fLeftFieldName = string;
        this.fRightFieldName = string2;
    }

    public Object getValueAt(int n, int n2) {
        return this.fData[n][n2];
    }

    public int getRecordCount() {
        if (this.fData == null) {
            return 0;
        }
        return this.fData.length;
    }

    public Class<?> getFieldClass(int n) {
        return String.class;
    }

    public int getFieldCount() {
        return 3;
    }

    public String getFieldName(int n) {
        switch (n) {
            case 0: {
                return ResourceManager.getString("variable.fieldname");
            }
            case 1: {
                return this.fLeftFieldName;
            }
            case 2: {
                return this.fRightFieldName;
            }
        }
        throw new UnsupportedOperationException("Expect field index to be 0, 1 or 2");
    }

    public int getPrimaryFieldIndex() {
        return 0;
    }

    public int getPresortFieldIndex() {
        return 0;
    }

    public int getPresortFieldOrder() {
        return 0;
    }

    public Object getSemaphore() {
        return this.fSemaphore;
    }

    private static StructTableObject[][] convertFieldEntriesToTableObjects(VariableDifferences.FieldEntry[] fieldEntryArray) {
        StructTableObject[][] structTableObjectArray = new StructTableObject[fieldEntryArray.length][3];
        int n = 0;
        for (VariableDifferences.FieldEntry fieldEntry : fieldEntryArray) {
            StructTableObject.DiffType diffType = StructTableModel.determineDiffType(fieldEntry);
            structTableObjectArray[n][0] = StructTableModel.createTableObject(fieldEntry.getName(), null, diffType);
            structTableObjectArray[n][1] = StructTableModel.createTableObject(StructTableModel.getNonNullDescription(fieldEntry.getSummary1()), fieldEntry.getClass1(), diffType);
            structTableObjectArray[n][2] = StructTableModel.createTableObject(StructTableModel.getNonNullDescription(fieldEntry.getSummary2()), fieldEntry.getClass2(), diffType);
            ++n;
        }
        return structTableObjectArray;
    }

    private static StructTableObject createTableObject(String string, String string2, StructTableObject.DiffType diffType) {
        return new StructTableObject(string, string2, diffType);
    }

    private static String getNonNullDescription(String string) {
        return string == null ? "" : string;
    }

    private static StructTableObject.DiffType determineDiffType(VariableDifferences.FieldEntry fieldEntry) {
        if (fieldEntry.getSummary1() == null) {
            return StructTableObject.DiffType.ADDED;
        }
        if (fieldEntry.getSummary2() == null) {
            return StructTableObject.DiffType.REMOVED;
        }
        return fieldEntry.getDiff() ? StructTableObject.DiffType.MODIFIED : StructTableObject.DiffType.NONE;
    }
}

