/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlab.api.deploytool;

import com.mathworks.matlab.api.deploytool.DeploymentProcess;
import com.mathworks.matlab.api.deploytool.InvalidFormatException;
import com.mathworks.matlab.api.deploytool.InvalidProjectException;
import com.mathworks.matlab.api.deploytool.ReadableConfiguration;
import com.mathworks.matlab.api.deploytool.UnavailableTargetException;
import com.mathworks.matlab.api.deploytool.ValidationMessage;
import com.mathworks.matlab.api.deploytool.WritableConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;

public abstract class ProjectApi {
    private static ProjectApi sInstance;

    public static ProjectApi getInstance() {
        if (sInstance == null) {
            throw new IllegalStateException("The ProjectApi implementation has not been installed.");
        }
        return sInstance;
    }

    public static void setInstance(ProjectApi projectApi) {
        sInstance = projectApi;
    }

    public abstract boolean isNonStandardProjectFormat(File var1) throws IOException, InvalidFormatException;

    public abstract WritableConfiguration openProject(File var1) throws IOException, InvalidFormatException, UnavailableTargetException;

    public abstract void saveProject(ReadableConfiguration var1, File var2) throws IOException;

    public abstract List<ValidationMessage> validate(ReadableConfiguration var1, File var2, boolean var3);

    public abstract DeploymentProcess createBuildProcess(ReadableConfiguration var1, File var2) throws InvalidProjectException;

    public abstract DeploymentProcess createPackageProcess(ReadableConfiguration var1, File var2, String var3, File var4, Callable<Boolean> var5) throws InvalidProjectException;
}

