/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.GlobalParam;
import net.sf.saxon.instruct.GlobalVariable;
import net.sf.saxon.javax.xml.xquery.XQException;
import net.sf.saxon.javax.xml.xquery.XQPreparedExpression;
import net.sf.saxon.javax.xml.xquery.XQResultSequence;
import net.sf.saxon.javax.xml.xquery.XQSequenceType;
import net.sf.saxon.javax.xml.xquery.XQStaticContext;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.sort.IntIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;
import net.sf.saxon.xqj.SaxonXQConnection;
import net.sf.saxon.xqj.SaxonXQDataFactory;
import net.sf.saxon.xqj.SaxonXQDynamicContext;
import net.sf.saxon.xqj.SaxonXQExpressionContext;
import net.sf.saxon.xqj.SaxonXQForwardSequence;
import net.sf.saxon.xqj.SaxonXQSequence;
import net.sf.saxon.xqj.SaxonXQSequenceType;

public class SaxonXQPreparedExpression
extends SaxonXQDynamicContext
implements XQPreparedExpression {
    private XQueryExpression expression;
    private DynamicQueryContext context;
    private boolean closed;
    private boolean scrollable;
    private static QName[] EMPTY_QNAME_ARRAY = new QName[0];

    protected SaxonXQPreparedExpression(SaxonXQConnection connection, XQueryExpression expression, DynamicQueryContext context) throws XQException {
        this.connection = connection;
        this.expression = expression;
        this.context = context;
        this.scrollable = connection.getStaticContext().getScrollability() == 2;
    }

    protected DynamicQueryContext getDynamicContext() {
        return this.context;
    }

    protected void checkNotClosed() throws XQException {
        if (this.isClosed()) {
            throw new XQException("Expression has been closed");
        }
    }

    protected SaxonXQDataFactory getDataFactory() throws XQException {
        if (this.connection.isClosed()) {
            this.close();
        }
        this.checkNotClosed();
        return this.connection;
    }

    public void cancel() throws XQException {
        this.checkNotClosed();
    }

    public void close() {
        this.closed = true;
    }

    public XQResultSequence executeQuery() throws XQException {
        this.checkNotClosed();
        try {
            SequenceIterator iter = this.expression.iterator(this.context);
            if (this.scrollable) {
                Value value = Value.asValue((ValueRepresentation)SequenceExtent.makeSequenceExtent((SequenceIterator)iter));
                return new SaxonXQSequence(value, this.connection.getConfiguration(), this.connection);
            }
            return new SaxonXQForwardSequence(iter, this.connection);
        }
        catch (XPathException de) {
            XQException xqe = new XQException(de.getMessage());
            xqe.initCause(de);
            throw xqe;
        }
    }

    public QName[] getAllExternalVariables() throws XQException {
        this.checkNotClosed();
        HashMap vars = this.expression.getExecutable().getCompiledGlobalVariables();
        if (vars == null || vars.isEmpty()) {
            return EMPTY_QNAME_ARRAY;
        }
        HashSet<StructuredQName> params = new HashSet<StructuredQName>(vars.size());
        Iterator iter = vars.values().iterator();
        while (iter.hasNext()) {
            GlobalVariable var = (GlobalVariable)iter.next();
            if (!(var instanceof GlobalParam)) continue;
            params.add(var.getVariableQName());
        }
        QName[] qnames = new QName[params.size()];
        int q = 0;
        Iterator it = params.iterator();
        while (it.hasNext()) {
            StructuredQName name = (StructuredQName)it.next();
            qnames[q++] = new QName(name.getNamespaceURI(), name.getLocalName(), name.getPrefix());
        }
        return qnames;
    }

    public QName[] getAllUnboundExternalVariables() throws XQException {
        this.checkNotClosed();
        Set boundParameters = this.getDynamicContext().getParameters().keySet();
        IntHashSet unbound = new IntHashSet(boundParameters.size());
        QName[] all = this.getAllExternalVariables();
        for (int i = 0; i < all.length; ++i) {
            String clark = "{" + all[i].getNamespaceURI() + "}" + all[i].getLocalPart();
            if (boundParameters.contains(clark)) continue;
            unbound.add(i);
        }
        QName[] unboundq = new QName[unbound.size()];
        int c = 0;
        IntIterator iter = unbound.iterator();
        while (iter.hasNext()) {
            int x = iter.next();
            unboundq[c++] = all[x];
        }
        return unboundq;
    }

    public XQStaticContext getStaticContext() throws XQException {
        return new SaxonXQExpressionContext(this.expression);
    }

    public XQSequenceType getStaticResultType() throws XQException {
        this.checkNotClosed();
        Expression exp = this.expression.getExpression();
        ItemType itemType = exp.getItemType(this.connection.getConfiguration().getTypeHierarchy());
        int cardinality = exp.getCardinality();
        SequenceType staticType = SequenceType.makeSequenceType((ItemType)itemType, (int)cardinality);
        return new SaxonXQSequenceType(staticType, this.connection.getConfiguration());
    }

    public XQSequenceType getStaticVariableType(QName name) throws XQException {
        GlobalVariable var;
        this.checkNotClosed();
        StructuredQName qn = new StructuredQName(name.getPrefix(), name.getNamespaceURI(), name.getLocalPart());
        HashMap vars = this.expression.getExecutable().getCompiledGlobalVariables();
        GlobalVariable globalVariable = var = vars == null ? null : (GlobalVariable)vars.get(qn);
        if (var == null) {
            throw new XQException("Variable " + name + " is not declared");
        }
        return new SaxonXQSequenceType(var.getRequiredType(), this.connection.getConfiguration());
    }

    public boolean isClosed() {
        if (this.connection.isClosed()) {
            this.close();
        }
        return this.closed;
    }
}

