/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.phoenix;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.rmi.server.ObjID;
import java.rmi.server.UnicastRemoteObject;
import net.jini.export.Exporter;
import sun.rmi.server.UnicastServerRef;
import sun.rmi.transport.LiveRef;

public class SunJrmpExporter
implements Exporter {
    private final int id;
    private final int port;
    private WeakReference ref;
    private static final Method exportMethod;

    public SunJrmpExporter(int n, int n2) {
        this.id = n;
        this.port = n2;
    }

    public Remote export(Remote remote) throws ExportException {
        if (this.ref != null) {
            throw new IllegalStateException("already used for export");
        }
        if (remote == null) {
            throw new NullPointerException();
        }
        this.ref = new WeakReference<Remote>(remote);
        UnicastServerRef unicastServerRef = this.getServerRef(new LiveRef(new ObjID(this.id), this.port));
        try {
            Object[] objectArray = new Object[]{remote, null, Boolean.TRUE};
            return (Remote)exportMethod.invoke((Object)unicastServerRef, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof ExportException) {
                throw (ExportException)throwable;
            }
            if (throwable instanceof RemoteException) {
                throw new ExportException("export failed", (Exception)throwable);
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new AssertionError((Object)throwable);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw (Error)new IllegalAccessError().initCause(illegalAccessException);
        }
    }

    UnicastServerRef getServerRef(LiveRef liveRef) {
        return new UnicastServerRef(liveRef);
    }

    public boolean unexport(boolean bl) {
        if (this.ref == null) {
            throw new IllegalStateException("no object exported through this exporter");
        }
        Remote remote = (Remote)this.ref.get();
        if (remote == null) {
            return true;
        }
        try {
            return UnicastRemoteObject.unexportObject(remote, bl);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            return true;
        }
    }

    static {
        try {
            Class[] classArray = new Class[]{Remote.class, Object.class, Boolean.TYPE};
            exportMethod = UnicastServerRef.class.getMethod("exportObject", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw (Error)new NoSuchMethodError().initCause(noSuchMethodException);
        }
    }
}

