/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.phoenix;

import [Ljava.lang.String;;
import com.sun.jini.phoenix.AID;
import com.sun.jini.phoenix.AbstractActivator;
import com.sun.jini.phoenix.AbstractMonitor;
import com.sun.jini.phoenix.AbstractRegistry;
import com.sun.jini.phoenix.AbstractSystem;
import com.sun.jini.phoenix.AccessILFactory;
import com.sun.jini.phoenix.ActivationGroupData;
import com.sun.jini.phoenix.Activator;
import com.sun.jini.phoenix.ConstrainableAID;
import com.sun.jini.phoenix.GroupOutputHandler;
import com.sun.jini.phoenix.InactiveGroupException;
import com.sun.jini.phoenix.PhoenixConstants;
import com.sun.jini.phoenix.PhoenixStarter;
import com.sun.jini.phoenix.PipeWriter;
import com.sun.jini.phoenix.RegistrySunExporter;
import com.sun.jini.phoenix.SystemAccessILFactory;
import com.sun.jini.proxy.BasicProxyTrustVerifier;
import com.sun.jini.proxy.MarshalledWrapper;
import com.sun.jini.reliableLog.LogHandler;
import com.sun.jini.reliableLog.ReliableLog;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroupDesc;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationInstantiator;
import java.rmi.activation.ActivationMonitor;
import java.rmi.activation.ActivationSystem;
import java.rmi.activation.UnknownGroupException;
import java.rmi.activation.UnknownObjectException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UID;
import java.security.CodeSource;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationNotFoundException;
import net.jini.config.ConfigurationProvider;
import net.jini.config.NoSuchEntryException;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.export.Exporter;
import net.jini.io.MarshalInputStream;
import net.jini.io.MarshalOutputStream;
import net.jini.io.MarshalledInstance;
import net.jini.jeri.BasicILFactory;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.tcp.TcpServerEndpoint;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ServerProxyTrust;

class Activation
implements Serializable {
    private static final long serialVersionUID = -6825932652725866242L;
    private static final String PHOENIX = "com.sun.jini.phoenix";
    private static ResourceBundle resources;
    private static Logger logger;
    private static final int PHOENIX_PORT = 1198;
    private static final Object logLock;
    private Map idTable = new HashMap();
    private Map groupTable = new HashMap();
    private transient LoginContext login;
    private transient int groupSemaphore;
    private transient int groupCounter = 0;
    private transient ReliableLog log;
    private transient int numUpdates = 0;
    private transient int snapshotInterval;
    private transient String[] command;
    private transient long groupTimeout;
    private transient long unexportTimeout;
    private transient long unexportWait;
    private transient Activator activator;
    private transient Exporter activatorExporter;
    private transient Activator activatorStub;
    private transient ActivationSystem system;
    private transient Exporter systemExporter;
    private transient ActivationSystem systemStub;
    private transient ActivationMonitor monitor;
    private transient Exporter monitorExporter;
    private transient ActivationMonitor monitorStub;
    private transient Registry registry;
    private transient Exporter registryExporter;
    private transient Registry registryStub;
    private transient MarshalledObject groupData;
    private transient String groupLocation;
    private transient ProxyPreparer groupPreparer;
    private transient GroupOutputHandler outputHandler;
    private volatile boolean shuttingDown = false;
    private transient Thread shutdownHook;
    private transient PhoenixStarter starter;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sun$jini$phoenix$Activation$ActLogHandler;

    private Activation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(ReliableLog reliableLog, LoginContext loginContext, Configuration configuration, String[] stringArray, PhoenixStarter phoenixStarter) throws Exception {
        this.log = reliableLog;
        this.login = loginContext;
        this.starter = phoenixStarter;
        this.groupSemaphore = Activation.getInt(configuration, "groupThrottle", 3);
        this.snapshotInterval = Activation.getInt(configuration, "persistenceSnapshotThreshold", 200);
        this.groupTimeout = Activation.getInt(configuration, "groupTimeout", 60000);
        this.unexportTimeout = Activation.getInt(configuration, "unexportTimeout", 60000);
        this.unexportWait = Activation.getInt(configuration, "unexportWait", 10);
        String[] stringArray2 = (String[])configuration.getEntry(PHOENIX, "groupOptions", String;.class, new String[0]);
        this.command = new String[stringArray2.length + 2];
        this.command[0] = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        System.arraycopy(stringArray2, 0, this.command, 1, stringArray2.length);
        this.command[this.command.length - 1] = "com.sun.jini.phoenix.ActivationGroupInit";
        this.shutdownHook = new ShutdownHook();
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        this.groupPreparer = Activation.getPreparer(configuration, "instantiatorPreparer");
        this.groupData = new MarshalledObject<ActivationGroupData>(new ActivationGroupData((String[])configuration.getEntry(PHOENIX, "groupConfig", String;.class, stringArray)));
        this.outputHandler = (GroupOutputHandler)configuration.getEntry(PHOENIX, "groupOutputHandler", GroupOutputHandler.class, new GroupOutputHandler(){

            public void handleOutput(ActivationGroupID activationGroupID, ActivationGroupDesc activationGroupDesc, long l, String string, InputStream inputStream, InputStream inputStream2) {
                PipeWriter.plugTogetherPair(string, inputStream, System.out, inputStream2, System.err);
            }
        });
        this.groupLocation = (String)configuration.getEntry(PHOENIX, "groupLocation", String.class, Activation.getDefaultGroupLocation());
        ActivationGroupID[] activationGroupIDArray = this.groupTable.keySet().toArray(new ActivationGroupID[this.groupTable.size()]);
        this.activator = new ActivatorImpl();
        TcpServerEndpoint tcpServerEndpoint = TcpServerEndpoint.getInstance(1198);
        this.activatorExporter = Activation.getExporter(configuration, "activatorExporter", new BasicJeriExporter(tcpServerEndpoint, new BasicILFactory(), false, true, PhoenixConstants.ACTIVATOR_UUID));
        this.system = new SystemImpl();
        this.systemExporter = Activation.getExporter(configuration, "systemExporter", new BasicJeriExporter(tcpServerEndpoint, new SystemAccessILFactory(), false, true, PhoenixConstants.ACTIVATION_SYSTEM_UUID));
        this.monitor = new MonitorImpl();
        this.monitorExporter = Activation.getExporter(configuration, "monitorExporter", new BasicJeriExporter(tcpServerEndpoint, new AccessILFactory()));
        this.registry = new RegistryImpl();
        this.registryExporter = Activation.getExporter(configuration, "registryExporter", new RegistrySunExporter());
        this.monitorStub = (ActivationMonitor)this.monitorExporter.export((Remote)this.monitor);
        Exporter exporter = this.activatorExporter;
        synchronized (exporter) {
            this.systemStub = (ActivationSystem)this.systemExporter.export((Remote)this.system);
            this.activatorStub = (Activator)this.activatorExporter.export(this.activator);
        }
        this.registryStub = (Registry)this.registryExporter.export(this.registry);
        logger.info(Activation.getTextResource("phoenix.daemon.started"));
        int n = activationGroupIDArray.length;
        while (--n >= 0) {
            try {
                this.getGroupEntry(activationGroupIDArray[n]).restartServices();
            }
            catch (UnknownGroupException unknownGroupException) {}
        }
    }

    private static String getDefaultGroupLocation() {
        String string;
        ProtectionDomain protectionDomain = Activation.class.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URL uRL = null;
        if (codeSource != null) {
            uRL = codeSource.getLocation();
        }
        if (uRL != null && (string = uRL.toString()).endsWith(".jar")) {
            return string.substring(0, string.length() - 4) + "-group.jar";
        }
        return null;
    }

    private static Configuration getConfig(String[] stringArray, PhoenixStarter phoenixStarter) throws ConfigurationException {
        try {
            return ConfigurationProvider.getInstance(stringArray, Activation.class.getClassLoader());
        }
        catch (ConfigurationNotFoundException configurationNotFoundException) {
            if (phoenixStarter == null) {
                Activation.bomb("phoenix.missing.config", Arrays.asList(stringArray).toString());
            }
            throw configurationNotFoundException;
        }
    }

    private static int getInt(Configuration configuration, String string, int n) throws ConfigurationException {
        return (Integer)configuration.getEntry(PHOENIX, string, Integer.TYPE, new Integer(n));
    }

    private static Exporter getExporter(Configuration configuration, String string, Exporter exporter) throws ConfigurationException {
        return (Exporter)configuration.getEntry(PHOENIX, string, Exporter.class, exporter);
    }

    private static ProxyPreparer getPreparer(Configuration configuration, String string) throws ConfigurationException {
        return (ProxyPreparer)configuration.getEntry(PHOENIX, string, ProxyPreparer.class, new BasicProxyPreparer());
    }

    private void checkShutdown() throws ActivationException {
        if (this.shuttingDown) {
            throw new ActivationException("activation system is shutting down");
        }
    }

    private ActivationID getAID(UID uID) {
        if (this.activatorStub instanceof RemoteMethodControl) {
            return new ConstrainableAID(this.activatorStub, uID);
        }
        return new AID(this.activatorStub, uID);
    }

    private static UID getUID(ActivationID activationID) throws UnknownObjectException {
        Class<?> clazz = activationID.getClass();
        if (clazz == AID.class || clazz == ConstrainableAID.class) {
            return ((AID)activationID).getUID();
        }
        throw new UnknownObjectException("object unknown");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActivationGroupID getGroupID(UID uID) throws UnknownObjectException {
        Map map = this.idTable;
        synchronized (map) {
            ActivationGroupID activationGroupID = (ActivationGroupID)this.idTable.get(uID);
            if (activationGroupID != null) {
                return activationGroupID;
            }
        }
        throw new UnknownObjectException("object unknown");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GroupEntry getGroupEntry(ActivationGroupID activationGroupID) throws UnknownGroupException {
        if (activationGroupID.getClass() == ActivationGroupID.class) {
            Map map = this.groupTable;
            synchronized (map) {
                GroupEntry groupEntry = (GroupEntry)this.groupTable.get(activationGroupID);
                if (groupEntry != null && !groupEntry.removed) {
                    return groupEntry;
                }
            }
        }
        throw new UnknownGroupException("group unknown");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GroupEntry getGroupEntry(UID uID) throws UnknownObjectException {
        ActivationGroupID activationGroupID = this.getGroupID(uID);
        Map map = this.groupTable;
        synchronized (map) {
            GroupEntry groupEntry = (GroupEntry)this.groupTable.get(activationGroupID);
            if (groupEntry != null) {
                return groupEntry;
            }
        }
        throw new UnknownObjectException("object's group removed");
    }

    private String[] activationArgs(ActivationGroupDesc activationGroupDesc) {
        String[] stringArray;
        Properties properties;
        ActivationGroupDesc.CommandEnvironment commandEnvironment = activationGroupDesc.getCommandEnvironment();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(commandEnvironment != null && commandEnvironment.getCommandPath() != null ? commandEnvironment.getCommandPath() : this.command[0]);
        if (commandEnvironment != null && commandEnvironment.getCommandOptions() != null) {
            arrayList.addAll(Arrays.asList(commandEnvironment.getCommandOptions()));
        }
        if ((properties = activationGroupDesc.getPropertyOverrides()) != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                stringArray = (String[])enumeration.nextElement();
                arrayList.add("-D" + (String)stringArray + "=" + properties.getProperty((String)stringArray));
            }
        }
        for (int i = 1; i < this.command.length; ++i) {
            arrayList.add(this.command[i]);
        }
        stringArray = new String[arrayList.size()];
        System.arraycopy(arrayList.toArray(), 0, stringArray, 0, stringArray.length);
        return stringArray;
    }

    private void addLogRecord(LogRecord logRecord) throws ActivationException {
        if (!$assertionsDisabled && !Thread.holdsLock(logLock)) {
            throw new AssertionError();
        }
        this.checkShutdown();
        if (this.numUpdates >= this.snapshotInterval) {
            this.snapshot();
        }
        try {
            this.log.update(logRecord, true);
            ++this.numUpdates;
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "log update throws", exception);
            this.snapshot();
        }
    }

    private void snapshot() throws ActivationException {
        if (!$assertionsDisabled && !Thread.holdsLock(logLock)) {
            throw new AssertionError();
        }
        try {
            this.log.snapshot();
            this.numUpdates = 0;
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "log snapshot throws", exception);
            try {
                this.system.shutdown();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            throw new ActivationException("log snapshot failed", (Throwable)exception);
        }
    }

    private static void usage() {
        System.err.println(MessageFormat.format(Activation.getTextResource("phoenix.usage"), Activation.class.getName()));
        System.exit(1);
    }

    private static void bomb(String string) {
        System.err.println("phoenix: " + string);
        Activation.usage();
    }

    private static void bomb(String string, String string2) {
        Activation.bomb(MessageFormat.format(Activation.getTextResource(string), string2));
    }

    public static void main(String[] stringArray) {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new SecurityManager());
        }
        boolean bl = false;
        if (stringArray.length > 0 && stringArray[0].equals("-stop")) {
            bl = true;
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            stringArray = stringArray2;
        } else if (stringArray.length == 1 && stringArray[0].equals("-help")) {
            Activation.usage();
        }
        try {
            Activation.main(stringArray, bl, null);
        }
        catch (Exception exception) {
            System.err.println(MessageFormat.format(Activation.getTextResource("phoenix.unexpected.exception"), exception.getMessage()));
            exception.printStackTrace();
            System.exit(1);
        }
    }

    ActivationSystem getActivationSystemProxy() {
        return this.systemStub;
    }

    static Activation main(final String[] stringArray, final boolean bl, final PhoenixStarter phoenixStarter) throws Exception {
        final Configuration configuration = Activation.getConfig(stringArray, phoenixStarter);
        final LoginContext loginContext = (LoginContext)configuration.getEntry(PHOENIX, "loginContext", LoginContext.class, null);
        if (loginContext != null) {
            loginContext.login();
        }
        PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public Object run() throws Exception {
                if (bl) {
                    if (!$assertionsDisabled && phoenixStarter != null) {
                        throw new AssertionError();
                    }
                    Activation.shutdown(configuration);
                    System.exit(0);
                }
                String string = null;
                try {
                    string = (String)configuration.getEntry(Activation.PHOENIX, "persistenceDirectory", class$java$lang$String == null ? (class$java$lang$String = Activation.class$("java.lang.String")) : class$java$lang$String);
                }
                catch (NoSuchEntryException noSuchEntryException) {
                    if (phoenixStarter == null) {
                        Activation.bomb("phoenix.missing.log", null);
                    }
                    throw noSuchEntryException;
                }
                ActLogHandler actLogHandler = new ActLogHandler();
                ReliableLog reliableLog = new ReliableLog(string, actLogHandler);
                reliableLog.recover();
                Activation activation = actLogHandler.getState();
                if (activation == null) {
                    reliableLog.snapshot();
                    activation = actLogHandler.getState();
                }
                activation.init(reliableLog, loginContext, configuration, stringArray, phoenixStarter);
                if (phoenixStarter == null) {
                    while (true) {
                        try {
                            while (true) {
                                Thread.sleep(Long.MAX_VALUE);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
                return activation;
            }

            static {
                $assertionsDisabled = !(class$com$sun$jini$phoenix$Activation == null ? (class$com$sun$jini$phoenix$Activation = Activation.class$("com.sun.jini.phoenix.Activation")) : class$com$sun$jini$phoenix$Activation).desiredAssertionStatus();
            }
        };
        if (loginContext != null) {
            return (Activation)Subject.doAsPrivileged(loginContext.getSubject(), privilegedExceptionAction, null);
        }
        return (Activation)privilegedExceptionAction.run();
    }

    private static void shutdown(Configuration configuration) throws Exception {
        String string = (String)configuration.getEntry(PHOENIX, "registryHost", String.class, null);
        int n = Activation.getInt(configuration, "registryPort", 1098);
        Registry registry = LocateRegistry.getRegistry(string, n);
        ActivationSystem activationSystem = (ActivationSystem)registry.lookup(ActivationSystem.class.getName());
        ProxyPreparer proxyPreparer = Activation.getPreparer(configuration, "systemPreparer");
        activationSystem = (ActivationSystem)proxyPreparer.prepareProxy(activationSystem);
        activationSystem.shutdown();
    }

    static String getTextResource(String string) {
        if (resources == null) {
            try {
                resources = ResourceBundle.getBundle("com.sun.jini.phoenix.resources.phoenix");
            }
            catch (MissingResourceException missingResourceException) {
                return "[missing resource file: " + string + "]";
            }
        }
        try {
            return resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "[missing resource: " + string + "]";
        }
    }

    private synchronized String Pstartgroup() throws ActivationException {
        while (true) {
            this.checkShutdown();
            if (this.groupSemaphore > 0) {
                --this.groupSemaphore;
                return "Group-" + this.groupCounter++;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private synchronized void Vstartgroup() {
        ++this.groupSemaphore;
        this.notifyAll();
    }

    static /* synthetic */ String access$2600(Activation activation) throws ActivationException {
        return activation.Pstartgroup();
    }

    static /* synthetic */ String[] access$2700(Activation activation, ActivationGroupDesc activationGroupDesc) {
        return activation.activationArgs(activationGroupDesc);
    }

    static /* synthetic */ GroupOutputHandler access$2800(Activation activation) {
        return activation.outputHandler;
    }

    static /* synthetic */ MarshalledObject access$2900(Activation activation) {
        return activation.groupData;
    }

    static /* synthetic */ String access$3000(Activation activation) {
        return activation.groupLocation;
    }

    static /* synthetic */ void access$3100(Activation activation) {
        activation.Vstartgroup();
    }

    static {
        $assertionsDisabled = !Activation.class.desiredAssertionStatus();
        resources = null;
        logger = Logger.getLogger(PHOENIX);
        logLock = new Object();
    }

    private static class LogGroupIncarnation
    extends LogRecord {
        private static final long serialVersionUID = 4146872747377631897L;
        private ActivationGroupID id;
        private long inc;

        LogGroupIncarnation(ActivationGroupID activationGroupID, long l) {
            this.id = activationGroupID;
            this.inc = l;
        }

        Object apply(Object object) {
            try {
                GroupEntry groupEntry = ((Activation)object).getGroupEntry(this.id);
                groupEntry.incarnation = this.inc;
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "log recovery throws", exception);
            }
            return object;
        }
    }

    private static class LogUnregisterGroup
    extends LogRecord {
        private static final long serialVersionUID = -3356306586522147344L;
        private ActivationGroupID id;

        LogUnregisterGroup(ActivationGroupID activationGroupID) {
            this.id = activationGroupID;
        }

        Object apply(Object object) {
            GroupEntry groupEntry = (GroupEntry)((Activation)object).groupTable.remove(this.id);
            try {
                groupEntry.unregisterGroup(false);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "log recovery throws", exception);
            }
            return object;
        }
    }

    private static class LogUpdateGroupDesc
    extends LogRecord {
        private static final long serialVersionUID = -1271300989218424337L;
        private ActivationGroupID id;
        private ActivationGroupDesc desc;

        LogUpdateGroupDesc(ActivationGroupID activationGroupID, ActivationGroupDesc activationGroupDesc) {
            this.id = activationGroupID;
            this.desc = activationGroupDesc;
        }

        Object apply(Object object) {
            try {
                ((Activation)object).getGroupEntry(this.id).setActivationGroupDesc(this.id, this.desc, false);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "log recovery throws", exception);
            }
            return object;
        }
    }

    private static class LogUpdateDesc
    extends LogRecord {
        private static final long serialVersionUID = 545511539051179885L;
        private UID uid;
        private ActivationDesc desc;

        LogUpdateDesc(UID uID, ActivationDesc activationDesc) {
            this.uid = uID;
            this.desc = activationDesc;
        }

        Object apply(Object object) {
            try {
                ((Activation)object).getGroupEntry(this.uid).setActivationDesc(this.uid, this.desc, false);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "log recovery throws", exception);
            }
            return object;
        }
    }

    private static class LogRegisterGroup
    extends LogRecord {
        private static final long serialVersionUID = -1966827458515403625L;
        private ActivationGroupID id;
        private ActivationGroupDesc desc;

        LogRegisterGroup(ActivationGroupID activationGroupID, ActivationGroupDesc activationGroupDesc) {
            this.id = activationGroupID;
            this.desc = activationGroupDesc;
        }

        Object apply(Object object) {
            Map map = ((Activation)object).groupTable;
            Activation activation = (Activation)object;
            activation.getClass();
            map.put(this.id, activation.new GroupEntry(this.id, this.desc));
            return object;
        }
    }

    private static class LogUnregisterObject
    extends LogRecord {
        private static final long serialVersionUID = 6269824097396935501L;
        private UID uid;

        LogUnregisterObject(UID uID) {
            this.uid = uID;
        }

        Object apply(Object object) {
            try {
                ((Activation)object).getGroupEntry(this.uid).unregisterObject(this.uid, false);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "log recovery throws", exception);
            }
            return object;
        }
    }

    private static class LogRegisterObject
    extends LogRecord {
        private static final long serialVersionUID = -6280336276146085143L;
        private UID uid;
        private ActivationDesc desc;

        LogRegisterObject(UID uID, ActivationDesc activationDesc) {
            this.uid = uID;
            this.desc = activationDesc;
        }

        Object apply(Object object) {
            try {
                ((Activation)object).getGroupEntry(this.desc.getGroupID()).registerObject(this.uid, this.desc, false);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "log recovery throws", exception);
            }
            return object;
        }
    }

    private static abstract class LogRecord
    implements Serializable {
        private static final long serialVersionUID = 8395140512322687529L;

        private LogRecord() {
        }

        abstract Object apply(Object var1) throws Exception;
    }

    private static class ActLogHandler
    extends LogHandler {
        private Activation state = null;

        ActLogHandler() {
        }

        public Activation getState() {
            return this.state;
        }

        public void snapshot(OutputStream outputStream) throws Exception {
            if (this.state == null) {
                this.state = new Activation();
            }
            MarshalOutputStream marshalOutputStream = new MarshalOutputStream(outputStream, Collections.EMPTY_LIST);
            marshalOutputStream.writeObject(this.state);
            marshalOutputStream.flush();
        }

        public void recover(InputStream inputStream) throws Exception {
            MarshalInputStream marshalInputStream = new MarshalInputStream(inputStream, (class$com$sun$jini$phoenix$Activation$ActLogHandler == null ? (class$com$sun$jini$phoenix$Activation$ActLogHandler = Activation.class$("com.sun.jini.phoenix.Activation$ActLogHandler")) : class$com$sun$jini$phoenix$Activation$ActLogHandler).getClassLoader(), false, null, Collections.EMPTY_LIST);
            marshalInputStream.useCodebaseAnnotations();
            this.state = (Activation)marshalInputStream.readObject();
        }

        public void writeUpdate(OutputStream outputStream, Object object) throws Exception {
            MarshalOutputStream marshalOutputStream = new MarshalOutputStream(outputStream, Collections.EMPTY_LIST);
            marshalOutputStream.writeObject(object);
            marshalOutputStream.flush();
        }

        public void readUpdate(InputStream inputStream) throws Exception {
            MarshalInputStream marshalInputStream = new MarshalInputStream(inputStream, (class$com$sun$jini$phoenix$Activation$ActLogHandler == null ? (class$com$sun$jini$phoenix$Activation$ActLogHandler = Activation.class$("com.sun.jini.phoenix.Activation$ActLogHandler")) : class$com$sun$jini$phoenix$Activation$ActLogHandler).getClassLoader(), false, null, Collections.EMPTY_LIST);
            marshalInputStream.useCodebaseAnnotations();
            this.applyUpdate(marshalInputStream.readObject());
        }

        public void applyUpdate(Object object) throws Exception {
            ((LogRecord)object).apply(this.state);
        }
    }

    private class ObjectEntry
    implements Serializable {
        private static final long serialVersionUID = -808474359039620126L;
        ActivationDesc desc;
        volatile transient MarshalledWrapper stub = null;
        volatile transient boolean removed = false;

        ObjectEntry(ActivationDesc activationDesc) {
            this.desc = activationDesc;
        }

        synchronized MarshalledWrapper activate(UID uID, boolean bl, ActivationInstantiator activationInstantiator) throws RemoteException, ActivationException {
            MarshalledWrapper marshalledWrapper = this.stub;
            if (this.removed) {
                throw new UnknownObjectException("object removed");
            }
            if (!bl && marshalledWrapper != null) {
                return marshalledWrapper;
            }
            MarshalledInstance marshalledInstance = new MarshalledInstance(activationInstantiator.newInstance(Activation.this.getAID(uID), this.desc));
            this.stub = marshalledWrapper = new MarshalledWrapper(marshalledInstance);
            return marshalledWrapper;
        }

        void reset() {
            this.stub = null;
        }

        void removed() {
            this.removed = true;
        }
    }

    private class GroupEntry
    implements Serializable {
        private static final long serialVersionUID = 7222464070032993304L;
        private static final int MAX_TRIES = 2;
        private static final int NORMAL = 0;
        private static final int CREATING = 1;
        private static final int TERMINATE = 2;
        private static final int TERMINATING = 3;
        ActivationGroupDesc desc;
        ActivationGroupID groupID;
        long incarnation = 0L;
        Map objects = new HashMap(11);
        HashSet restartSet = new HashSet();
        transient ActivationInstantiator group = null;
        transient int status = 0;
        transient long waitTime = 0L;
        transient String groupName = null;
        transient Process child = null;
        transient boolean removed = false;
        transient Watchdog watchdog = null;

        GroupEntry(ActivationGroupID activationGroupID, ActivationGroupDesc activationGroupDesc) {
            this.groupID = activationGroupID;
            this.desc = activationGroupDesc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void restartServices() {
            Iterator iterator = null;
            Serializable serializable = this;
            synchronized (serializable) {
                if (this.restartSet.isEmpty()) {
                    return;
                }
                iterator = ((Set)this.restartSet.clone()).iterator();
            }
            while (iterator.hasNext()) {
                serializable = (UID)iterator.next();
                try {
                    this.activate((UID)serializable, true);
                }
                catch (Exception exception) {
                    if (Activation.this.shuttingDown) {
                        return;
                    }
                    logger.log(Level.WARNING, "unable to restart service", exception);
                }
            }
        }

        synchronized void activeGroup(ActivationInstantiator activationInstantiator, long l) throws ActivationException {
            if (this.group != null && this.group.equals(activationInstantiator) && this.incarnation == l) {
                return;
            }
            if (this.child != null && this.status != 1) {
                throw new ActivationException("group not being created");
            }
            if (this.incarnation != l) {
                throw new ActivationException("invalid incarnation");
            }
            if (this.group != null) {
                throw new ActivationException("group already active");
            }
            this.group = activationInstantiator;
            this.status = 0;
            this.notifyAll();
        }

        private void checkRemoved() throws UnknownGroupException {
            if (this.removed) {
                throw new UnknownGroupException("group removed");
            }
        }

        private ObjectEntry getObjectEntry(UID uID) throws UnknownObjectException {
            if (this.removed) {
                throw new UnknownObjectException("object's group removed");
            }
            ObjectEntry objectEntry = (ObjectEntry)this.objects.get(uID);
            if (objectEntry == null) {
                throw new UnknownObjectException("object unknown");
            }
            return objectEntry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void registerObject(UID uID, ActivationDesc activationDesc, boolean bl) throws ActivationException {
            this.checkRemoved();
            Object object = logLock;
            synchronized (object) {
                if (bl) {
                    Activation.this.addLogRecord(new LogRegisterObject(uID, activationDesc));
                }
                this.objects.put(uID, new ObjectEntry(activationDesc));
                if (activationDesc.getRestartMode()) {
                    this.restartSet.add(uID);
                }
                Map map = Activation.this.idTable;
                synchronized (map) {
                    Activation.this.idTable.put(uID, this.groupID);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void unregisterObject(UID uID, boolean bl) throws ActivationException {
            ObjectEntry objectEntry = this.getObjectEntry(uID);
            Object object = logLock;
            synchronized (object) {
                if (bl) {
                    Activation.this.addLogRecord(new LogUnregisterObject(uID));
                }
                objectEntry.removed();
                this.objects.remove(uID);
                if (objectEntry.desc.getRestartMode()) {
                    this.restartSet.remove(uID);
                }
                Map map = Activation.this.idTable;
                synchronized (map) {
                    Activation.this.idTable.remove(uID);
                }
            }
        }

        synchronized Map getActivatableObjects() {
            HashMap<ActivationID, ActivationDesc> hashMap = new HashMap<ActivationID, ActivationDesc>(this.objects.size());
            Iterator iterator = this.objects.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                hashMap.put(Activation.this.getAID((UID)entry.getKey()), ((ObjectEntry)entry.getValue()).desc);
            }
            return hashMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void unregisterGroup(boolean bl) throws ActivationException {
            this.checkRemoved();
            Object object = logLock;
            synchronized (object) {
                if (bl) {
                    Activation.this.addLogRecord(new LogUnregisterGroup(this.groupID));
                }
                this.removed = true;
                Iterator iterator = this.objects.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    UID uID = (UID)entry.getKey();
                    Object object2 = Activation.this.idTable;
                    synchronized (object2) {
                        Activation.this.idTable.remove(uID);
                    }
                    object2 = (ObjectEntry)entry.getValue();
                    ((ObjectEntry)object2).removed();
                }
                this.objects.clear();
                this.restartSet.clear();
                this.reset();
                this.childGone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized ActivationDesc setActivationDesc(UID uID, ActivationDesc activationDesc, boolean bl) throws ActivationException {
            ObjectEntry objectEntry = this.getObjectEntry(uID);
            Object object = logLock;
            synchronized (object) {
                if (bl) {
                    Activation.this.addLogRecord(new LogUpdateDesc(uID, activationDesc));
                }
                ActivationDesc activationDesc2 = objectEntry.desc;
                objectEntry.desc = activationDesc;
                if (activationDesc.getRestartMode()) {
                    this.restartSet.add(uID);
                } else {
                    this.restartSet.remove(uID);
                }
                return activationDesc2;
            }
        }

        synchronized ActivationDesc getActivationDesc(UID uID) throws UnknownObjectException {
            return this.getObjectEntry((UID)uID).desc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized ActivationGroupDesc setActivationGroupDesc(ActivationGroupID activationGroupID, ActivationGroupDesc activationGroupDesc, boolean bl) throws ActivationException {
            this.checkRemoved();
            Object object = logLock;
            synchronized (object) {
                if (bl) {
                    Activation.this.addLogRecord(new LogUpdateGroupDesc(activationGroupID, activationGroupDesc));
                }
                ActivationGroupDesc activationGroupDesc2 = this.desc;
                this.desc = activationGroupDesc;
                return activationGroupDesc2;
            }
        }

        synchronized void inactiveGroup(long l, boolean bl) throws UnknownGroupException {
            this.checkRemoved();
            if (this.incarnation != l) {
                throw new UnknownGroupException("invalid incarnation");
            }
            this.reset();
            if (bl) {
                this.terminate();
            } else if (this.child != null && this.status == 0) {
                this.status = 2;
                this.watchdog.noRestart();
            }
        }

        synchronized void activeObject(UID uID, MarshalledObject marshalledObject) throws UnknownObjectException {
            this.getObjectEntry((UID)uID).stub = new MarshalledWrapper(new MarshalledInstance(marshalledObject));
        }

        synchronized void inactiveObject(UID uID) throws UnknownObjectException {
            this.getObjectEntry(uID).reset();
        }

        private void reset() {
            this.group = null;
            Iterator iterator = this.objects.values().iterator();
            while (iterator.hasNext()) {
                ((ObjectEntry)iterator.next()).reset();
            }
        }

        private void childGone() {
            if (this.child != null) {
                this.child = null;
                this.watchdog.dispose();
                this.watchdog = null;
                this.status = 0;
                this.notifyAll();
            }
        }

        private void terminate() {
            if (this.child != null && this.status != 3) {
                this.child.destroy();
                this.status = 3;
                this.waitTime = System.currentTimeMillis() + Activation.this.groupTimeout;
                this.notifyAll();
            }
        }

        private void await() {
            while (true) {
                switch (this.status) {
                    case 0: {
                        return;
                    }
                    case 2: {
                        this.terminate();
                    }
                    case 3: {
                        try {
                            this.child.exitValue();
                        }
                        catch (IllegalThreadStateException illegalThreadStateException) {
                            long l = System.currentTimeMillis();
                            if (this.waitTime > l) {
                                try {
                                    this.wait(this.waitTime - l);
                                }
                                catch (InterruptedException interruptedException) {}
                                break;
                            }
                            logger.log(Level.WARNING, "group did not terminate: {0}", this.groupName);
                        }
                        this.childGone();
                        return;
                    }
                    case 1: {
                        try {
                            this.wait();
                            break;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        }

        void shutdownFast() {
            Process process = this.child;
            if (process != null) {
                process.destroy();
            }
        }

        synchronized void shutdown() {
            this.reset();
            this.terminate();
            this.await();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MarshalledWrapper activate(UID uID, boolean bl) throws ActivationException {
            Object object = null;
            for (int i = 2; i > 0; --i) {
                boolean bl2;
                boolean bl3;
                long l;
                block13: {
                    ActivationInstantiator activationInstantiator;
                    ObjectEntry objectEntry;
                    GroupEntry groupEntry = this;
                    synchronized (groupEntry) {
                        objectEntry = this.getObjectEntry(uID);
                        if (!bl && objectEntry.stub != null) {
                            return objectEntry.stub;
                        }
                        activationInstantiator = this.getInstantiator(this.groupID);
                        l = this.incarnation;
                    }
                    bl3 = false;
                    bl2 = false;
                    try {
                        return objectEntry.activate(uID, bl, activationInstantiator);
                    }
                    catch (NoSuchObjectException noSuchObjectException) {
                        bl3 = true;
                        object = noSuchObjectException;
                    }
                    catch (ConnectException connectException) {
                        bl3 = true;
                        bl2 = true;
                        object = connectException;
                    }
                    catch (ConnectIOException connectIOException) {
                        bl3 = true;
                        bl2 = true;
                        object = connectIOException;
                    }
                    catch (InactiveGroupException inactiveGroupException) {
                        bl3 = true;
                        object = inactiveGroupException;
                    }
                    catch (RemoteException remoteException) {
                        if (object != null) break block13;
                        object = remoteException;
                    }
                }
                if (!bl3) continue;
                try {
                    Activation.this.getGroupEntry(this.groupID).inactiveGroup(l, bl2);
                    continue;
                }
                catch (UnknownGroupException unknownGroupException) {
                    // empty catch block
                }
            }
            throw new ActivationException("object activation failed after 2 tries", object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private ActivationInstantiator getInstantiator(ActivationGroupID var1_1) throws ActivationException {
            this.await();
            if (this.group != null) {
                return this.group;
            }
            this.checkRemoved();
            var2_2 = false;
            try {
                block16: {
                    this.groupName = Activation.access$2600(Activation.this);
                    var2_2 = true;
                    var3_3 = Activation.access$2700(Activation.this, this.desc);
                    if (Activation.access$2200().isLoggable(Level.FINE)) {
                        Activation.access$2200().log(Level.FINE, "{0} exec {1}", new Object[]{this.groupName, Arrays.asList(var3_3)});
                    }
                    try {
                        this.child = Runtime.getRuntime().exec(var3_3);
                        this.status = 1;
                        var4_4 = Activation.access$900();
                        synchronized (var4_4) {
                            Activation.access$1000(Activation.this, new LogGroupIncarnation(var1_1, this.incarnation + 1L));
                            ++this.incarnation;
                        }
                        this.watchdog = new Watchdog();
                        this.watchdog.start();
                        Activation.access$2800(Activation.this).handleOutput(var1_1, this.desc, this.incarnation, this.groupName, this.child.getInputStream(), this.child.getErrorStream());
                        var4_4 = new MarshalOutputStream(this.child.getOutputStream(), Collections.EMPTY_LIST);
                        var4_4.writeObject(var1_1);
                        var5_8 = this.desc;
                        if (var5_8.getClassName() == null) {
                            var6_9 = var5_8.getData();
                            if (var6_9 == null) {
                                var6_9 = Activation.access$2900(Activation.this);
                            }
                            if ((var7_11 = var5_8.getLocation()) == null) {
                                var7_11 = Activation.access$3000(Activation.this);
                            }
                            var5_8 = new ActivationGroupDesc("com.sun.jini.phoenix.ActivationGroupImpl", var7_11, var6_9, var5_8.getPropertyOverrides(), var5_8.getCommandEnvironment());
                        }
                        var4_4.writeObject(var5_8);
                        var4_4.writeLong(this.incarnation);
                        var4_4.flush();
                        var4_4.close();
                    }
                    catch (IOException var4_5) {
                        this.terminate();
                        throw new ActivationException("unable to create activation group", (Throwable)var4_5);
                    }
                    try {
                        var4_6 = System.currentTimeMillis();
                        var6_10 = var4_6 + Activation.access$2500(Activation.this);
                        while (true) {
                            this.wait(var6_10 - var4_6);
                            if (this.group != null) {
                                var8_12 = this.group;
                            }
                            ** GOTO lbl-1000
                            break;
                        }
                    }
                    catch (InterruptedException var4_7) {
                        // empty catch block
                        break block16;
                    }
                    var10_13 = null;
                    if (var2_2 == false) return var8_12;
                    Activation.access$3100(Activation.this);
                    return var8_12;
lbl-1000:
                    // 1 sources

                    {
                        var4_6 = System.currentTimeMillis();
                        if (this.status == 1 && var4_6 < var6_10) ** continue;
                    }
                }
                this.terminate();
                throw new ActivationException("timeout creating child process");
            }
            catch (Throwable var9_15) {
                var10_14 = null;
                if (var2_2 == false) throw var9_15;
                Activation.access$3100(Activation.this);
                throw var9_15;
            }
        }

        private class Watchdog
        extends Thread {
            private Process groupProcess;
            private long groupIncarnation;
            private boolean canInterrupt;
            private boolean shouldQuit;
            private boolean shouldRestart;

            Watchdog() {
                super("Watchdog-" + GroupEntry.this.groupName + "-" + GroupEntry.this.incarnation);
                this.groupProcess = GroupEntry.this.child;
                this.groupIncarnation = GroupEntry.this.incarnation;
                this.canInterrupt = true;
                this.shouldQuit = false;
                this.shouldRestart = true;
                this.setDaemon(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (this.shouldQuit) {
                    return;
                }
                try {
                    this.groupProcess.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                boolean bl = false;
                GroupEntry groupEntry = GroupEntry.this;
                synchronized (groupEntry) {
                    if (this.shouldQuit) {
                        return;
                    }
                    this.canInterrupt = false;
                    Watchdog.interrupted();
                    if (this.groupIncarnation == GroupEntry.this.incarnation) {
                        bl = this.shouldRestart && !Activation.this.shuttingDown;
                        GroupEntry.this.reset();
                        GroupEntry.this.childGone();
                    }
                }
                if (bl) {
                    GroupEntry.this.restartServices();
                }
            }

            void dispose() {
                this.shouldQuit = true;
                if (this.canInterrupt) {
                    this.interrupt();
                }
            }

            void noRestart() {
                this.shouldRestart = false;
            }
        }
    }

    private class ShutdownHook
    extends Thread {
        ShutdownHook() {
            super("Phoenix Shutdown Hook");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = Activation.this;
            synchronized (object) {
                Activation.this.shuttingDown = true;
            }
            object = Activation.this.groupTable;
            synchronized (object) {
                Iterator iterator = Activation.this.groupTable.values().iterator();
                while (iterator.hasNext()) {
                    ((GroupEntry)iterator.next()).shutdownFast();
                }
            }
        }
    }

    private class Shutdown
    extends Thread {
        Shutdown() {
            super("Shutdown");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                long l = System.currentTimeMillis() + Activation.this.unexportTimeout;
                boolean bl = false;
                while (!(Activation.this.registryExporter.unexport(bl) && Activation.this.activatorExporter.unexport(bl) && Activation.this.systemExporter.unexport(bl) && Activation.this.monitorExporter.unexport(bl))) {
                    long l2 = l - System.currentTimeMillis();
                    if (l2 <= 0L) {
                        bl = true;
                        continue;
                    }
                    try {
                        Thread.sleep(Math.min(l2, Activation.this.unexportWait));
                    }
                    catch (InterruptedException interruptedException) {}
                }
                Object object = Activation.this.groupTable;
                synchronized (object) {
                    Iterator iterator = Activation.this.groupTable.values().iterator();
                    while (iterator.hasNext()) {
                        ((GroupEntry)iterator.next()).shutdown();
                    }
                }
                Runtime.getRuntime().removeShutdownHook(Activation.this.shutdownHook);
                try {
                    object = logLock;
                    synchronized (object) {
                        Activation.this.log.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (Activation.this.login != null) {
                        Activation.this.login.logout();
                    }
                }
                catch (LoginException loginException) {
                }
                Object var10_11 = null;
                logger.info(Activation.getTextResource("phoenix.daemon.shutdown"));
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                logger.info(Activation.getTextResource("phoenix.daemon.shutdown"));
                if (Activation.this.starter == null) {
                    System.exit(0);
                    throw throwable;
                } else {
                    Activation.this.starter.unregister();
                }
                throw throwable;
            }
            if (Activation.this.starter == null) {
                System.exit(0);
                return;
            }
            Activation.this.starter.unregister();
        }
    }

    class RegistryImpl
    extends AbstractRegistry {
        private final String NAME = (class$java$rmi$activation$ActivationSystem == null ? (class$java$rmi$activation$ActivationSystem = Activation.class$("java.rmi.activation.ActivationSystem")) : class$java$rmi$activation$ActivationSystem).getName();

        RegistryImpl() {
        }

        public Remote lookup(String string) throws NotBoundException {
            if (string.equals(this.NAME)) {
                return Activation.this.systemStub;
            }
            throw new NotBoundException(string);
        }

        public void bind(String string, Remote remote) {
            throw new SecurityException("read-only registry");
        }

        public void unbind(String string) {
            throw new SecurityException("read-only registry");
        }

        public void rebind(String string, Remote remote) {
            throw new SecurityException("read-only registry");
        }

        public String[] list() {
            return new String[]{this.NAME};
        }
    }

    class SystemImpl
    extends AbstractSystem
    implements ServerProxyTrust {
        SystemImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ActivationID registerObject(ActivationDesc activationDesc) throws ActivationException {
            UID uID = new UID();
            ActivationGroupID activationGroupID = activationDesc.getGroupID();
            Activation.this.getGroupEntry(activationGroupID).registerObject(uID, activationDesc, true);
            Exporter exporter = Activation.this.activatorExporter;
            synchronized (exporter) {
                return Activation.this.getAID(uID);
            }
        }

        public void unregisterObject(ActivationID activationID) throws ActivationException {
            UID uID = Activation.getUID(activationID);
            Activation.this.getGroupEntry(Activation.this.getGroupID(uID)).unregisterObject(uID, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ActivationGroupID registerGroup(ActivationGroupDesc activationGroupDesc) throws ActivationException {
            ActivationGroupID activationGroupID = new ActivationGroupID(Activation.this.systemStub);
            Object object = logLock;
            synchronized (object) {
                Activation.this.addLogRecord(new LogRegisterGroup(activationGroupID, activationGroupDesc));
                GroupEntry groupEntry = new GroupEntry(activationGroupID, activationGroupDesc);
                Map map = Activation.this.groupTable;
                synchronized (map) {
                    Activation.this.groupTable.put(activationGroupID, groupEntry);
                }
            }
            return activationGroupID;
        }

        public ActivationMonitor activeGroup(ActivationGroupID activationGroupID, ActivationInstantiator activationInstantiator, long l) throws ActivationException, RemoteException {
            activationInstantiator = (ActivationInstantiator)Activation.this.groupPreparer.prepareProxy(activationInstantiator);
            Activation.this.getGroupEntry(activationGroupID).activeGroup(activationInstantiator, l);
            return Activation.this.monitorStub;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregisterGroup(ActivationGroupID activationGroupID) throws ActivationException {
            GroupEntry groupEntry;
            Map map = Activation.this.groupTable;
            synchronized (map) {
                groupEntry = Activation.this.getGroupEntry(activationGroupID);
                Activation.this.groupTable.remove(activationGroupID);
            }
            groupEntry.unregisterGroup(true);
        }

        public ActivationDesc setActivationDesc(ActivationID activationID, ActivationDesc activationDesc) throws ActivationException {
            UID uID = Activation.getUID(activationID);
            if (!Activation.this.getGroupID(uID).equals((Object)activationDesc.getGroupID())) {
                throw new ActivationException("ActivationDesc contains wrong group");
            }
            return Activation.this.getGroupEntry(uID).setActivationDesc(uID, activationDesc, true);
        }

        public ActivationGroupDesc setActivationGroupDesc(ActivationGroupID activationGroupID, ActivationGroupDesc activationGroupDesc) throws ActivationException {
            return Activation.this.getGroupEntry(activationGroupID).setActivationGroupDesc(activationGroupID, activationGroupDesc, true);
        }

        public ActivationDesc getActivationDesc(ActivationID activationID) throws UnknownObjectException {
            UID uID = Activation.getUID(activationID);
            return Activation.this.getGroupEntry(uID).getActivationDesc(uID);
        }

        public ActivationGroupDesc getActivationGroupDesc(ActivationGroupID activationGroupID) throws UnknownGroupException {
            return ((Activation)Activation.this).getGroupEntry((ActivationGroupID)activationGroupID).desc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            Activation activation = Activation.this;
            synchronized (activation) {
                if (!Activation.this.shuttingDown) {
                    Activation.this.shuttingDown = true;
                    new Shutdown().start();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map getActivationGroups() {
            Map map = Activation.this.groupTable;
            synchronized (map) {
                HashMap<ActivationGroupID, ActivationGroupDesc> hashMap = new HashMap<ActivationGroupID, ActivationGroupDesc>(Activation.this.groupTable.size());
                Iterator iterator = Activation.this.groupTable.values().iterator();
                while (iterator.hasNext()) {
                    GroupEntry groupEntry = (GroupEntry)iterator.next();
                    if (groupEntry.removed) continue;
                    hashMap.put(groupEntry.groupID, groupEntry.desc);
                }
                return hashMap;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map getActivatableObjects(ActivationGroupID activationGroupID) throws UnknownGroupException {
            Exporter exporter = Activation.this.activatorExporter;
            synchronized (exporter) {
            }
            return Activation.this.getGroupEntry(activationGroupID).getActivatableObjects();
        }

        public TrustVerifier getProxyVerifier() {
            return new BasicProxyTrustVerifier(Activation.this.systemStub);
        }
    }

    class MonitorImpl
    extends AbstractMonitor
    implements ServerProxyTrust {
        MonitorImpl() {
        }

        public void inactiveObject(ActivationID activationID) throws UnknownObjectException {
            UID uID = Activation.getUID(activationID);
            Activation.this.getGroupEntry(uID).inactiveObject(uID);
        }

        public void activeObject(ActivationID activationID, MarshalledObject marshalledObject) throws UnknownObjectException {
            UID uID = Activation.getUID(activationID);
            Activation.this.getGroupEntry(uID).activeObject(uID, marshalledObject);
        }

        public void inactiveGroup(ActivationGroupID activationGroupID, long l) throws UnknownGroupException {
            Activation.this.getGroupEntry(activationGroupID).inactiveGroup(l, false);
        }

        public TrustVerifier getProxyVerifier() {
            return new BasicProxyTrustVerifier(Activation.this.monitorStub);
        }
    }

    class ActivatorImpl
    extends AbstractActivator
    implements ServerProxyTrust {
        ActivatorImpl() {
        }

        public MarshalledWrapper activate(ActivationID activationID, boolean bl) throws ActivationException {
            UID uID = Activation.getUID(activationID);
            return Activation.this.getGroupEntry(uID).activate(uID, bl);
        }

        public TrustVerifier getProxyVerifier() {
            return new ConstrainableAID.Verifier(Activation.this.activatorStub);
        }
    }
}

