/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index.doccenter;

import com.mathworks.helpsearch.index.HtmlParser;
import com.mathworks.helpsearch.index.HtmlParserFactory;
import com.mathworks.helpsearch.index.LinkResolver;
import com.mathworks.helpsearch.index.XmlFragmentHandler;
import com.mathworks.helpsearch.index.doccenter.BodyFragmentHandler;
import com.mathworks.helpsearch.index.doccenter.BreadCrumbFragmentHandler;
import com.mathworks.helpsearch.index.doccenter.LinkFragmentHandler;
import com.mathworks.helpsearch.index.doccenter.SyntaxFragmentHandler;
import com.mathworks.helpsearch.index.doccenter.TitleFragmentHandler;
import com.mathworks.helpsearch.index.shared.DescriptionFragmentHandler;
import com.mathworks.helpsearch.index.shared.RefEntityFragmentHandler;
import com.mathworks.helpsearch.product.DocProduct;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;

public class DocCenterHtmlParserFactory
implements HtmlParserFactory {
    private final DocProduct fProduct;
    private final LinkResolver fResolver;

    public DocCenterHtmlParserFactory(DocProduct product, LinkResolver resolver) {
        this.fProduct = product;
        this.fResolver = resolver;
    }

    @Override
    public HtmlParser createParserForDocument(Document doc, String relPath) {
        List<XmlFragmentHandler> handlers = this.createHandlers(relPath, this.fResolver);
        return new HtmlParser(doc, handlers);
    }

    private List<XmlFragmentHandler> createHandlers(String relPath, LinkResolver resolver) {
        ArrayList<XmlFragmentHandler> handlers = new ArrayList<XmlFragmentHandler>();
        handlers.add(new RefEntityFragmentHandler());
        handlers.add(new TitleFragmentHandler());
        handlers.add(new DescriptionFragmentHandler());
        handlers.add(new BreadCrumbFragmentHandler(this.fProduct, relPath));
        handlers.add(new BodyFragmentHandler());
        handlers.add(new LinkFragmentHandler(relPath, resolver));
        handlers.add(new SyntaxFragmentHandler());
        return handlers;
    }
}

