/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class PagePopularities {
    private static final String POPULARITIES_FILE = "hits.txt";
    private final Map<String, Integer> fPopularities;

    PagePopularities(File resourceDir) {
        this.fPopularities = PagePopularities.populate(resourceDir);
    }

    private static Map<String, Integer> populate(File resourceDir) {
        try {
            File popFile = new File(resourceDir, POPULARITIES_FILE);
            return PagePopularities.loadPopularities(popFile);
        }
        catch (IOException ioe) {
            return Collections.emptyMap();
        }
    }

    Map<String, Integer> getPopularities() {
        return Collections.unmodifiableMap(this.fPopularities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Integer> loadPopularities(File popFile) throws IOException {
        if (popFile.exists()) {
            HashMap<String, Integer> pops = new HashMap<String, Integer>();
            BufferedReader br = new BufferedReader(new FileReader(popFile));
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    String[] parts = line.split(" ");
                    String relPath = parts[0].replaceFirst("^(techdoc|matlab)/", "");
                    if (parts.length != 2) continue;
                    double numHits = Double.parseDouble(parts[1]);
                    pops.put(relPath, PagePopularities.getPopularityValue(numHits));
                }
            }
            finally {
                br.close();
            }
            return pops;
        }
        return Collections.emptyMap();
    }

    static int getPopularityValue(double numHits) {
        if (numHits >= 1000.0) {
            int pop = 1;
            for (double i = numHits / 1000.0; i >= 2.0; i /= 2.0) {
                ++pop;
            }
            return pop;
        }
        return 0;
    }
}

