/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index;

import com.mathworks.helpsearch.index.XmlFragmentHandler;
import com.mathworks.helpsearch.index.XmlFragmentReader;
import com.mathworks.helpsearch.index.XmlTagInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentationDomParser {
    private final Map<String, List<XmlFragmentHandler>> fFragmentHandlers = new HashMap<String, List<XmlFragmentHandler>>();
    private final List<XmlFragmentHandler> fGlobalHanders = new LinkedList<XmlFragmentHandler>();
    private final List<XmlFragmentReader> fCurrentHandlers = new ArrayList<XmlFragmentReader>();

    public DocumentationDomParser(XmlFragmentHandler ... handlers) {
        this(Arrays.asList(handlers));
    }

    public DocumentationDomParser(Collection<XmlFragmentHandler> fragmentHandlers) {
        for (XmlFragmentHandler handler : fragmentHandlers) {
            String[] tagList = handler.getEnclosingTagNames();
            if (tagList == null || tagList.length == 0) {
                this.fGlobalHanders.add(handler);
                continue;
            }
            for (String tag : tagList) {
                List<XmlFragmentHandler> handlersForTag = this.fFragmentHandlers.get(tag = tag.toLowerCase(Locale.ENGLISH));
                if (handlersForTag == null) {
                    handlersForTag = new ArrayList<XmlFragmentHandler>();
                    this.fFragmentHandlers.put(tag, handlersForTag);
                }
                handlersForTag.add(handler);
            }
        }
    }

    public void parse(Node rootNode) {
        XmlTagInfo rootInfo = DocumentationDomParser.getInfoForNode(rootNode, null);
        this.parseChildren(rootNode, rootInfo);
    }

    private void parseChildren(Node node, XmlTagInfo parentTag) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == 3) {
                this.handleTextNode(child, parentTag);
                continue;
            }
            this.handleTagNode(child, parentTag);
        }
    }

    private void handleTextNode(Node node, XmlTagInfo parentTag) {
        String text = node.getNodeValue();
        for (XmlFragmentReader handler : this.fCurrentHandlers) {
            handler.characters(parentTag, text);
            if (handler.continueHandling()) continue;
            break;
        }
    }

    private void handleTagNode(Node child, XmlTagInfo parentTag) {
        XmlTagInfo currentTag = DocumentationDomParser.getInfoForNode(child, parentTag);
        if (currentTag.getTagName() == null) {
            return;
        }
        List<XmlFragmentHandler> handlers = this.getHandlersForTag(currentTag);
        HashMap<XmlFragmentHandler, XmlFragmentReader> readers = new HashMap<XmlFragmentHandler, XmlFragmentReader>();
        if (handlers != null) {
            for (XmlFragmentHandler xmlFragmentHandler : handlers) {
                XmlFragmentReader reader = xmlFragmentHandler.startFragment(currentTag);
                readers.put(xmlFragmentHandler, reader);
                this.fCurrentHandlers.add(0, reader);
            }
        }
        for (XmlFragmentReader xmlFragmentReader : this.fCurrentHandlers) {
            xmlFragmentReader.startElement(currentTag);
            if (xmlFragmentReader.continueHandling()) continue;
            break;
        }
        this.parseChildren(child, currentTag);
        for (XmlFragmentReader xmlFragmentReader : this.fCurrentHandlers) {
            xmlFragmentReader.endElement(currentTag);
            if (xmlFragmentReader.continueHandling()) continue;
            break;
        }
        if (handlers != null) {
            for (XmlFragmentHandler xmlFragmentHandler : handlers) {
                xmlFragmentHandler.endFragment(currentTag);
                this.fCurrentHandlers.remove(readers.get(xmlFragmentHandler));
            }
        }
    }

    private static XmlTagInfo getInfoForNode(Node node, XmlTagInfo parentTag) {
        NamedNodeMap attributes = node.getAttributes();
        HashMap<String, String> attsMap = new HashMap<String, String>();
        if (attributes != null) {
            for (int j = 0; j < attributes.getLength(); ++j) {
                Node attNode = attributes.item(j);
                attsMap.put(attNode.getNodeName(), attNode.getNodeValue());
            }
        }
        return new XmlTagInfo(node.getNodeName(), attsMap, parentTag);
    }

    private List<XmlFragmentHandler> getHandlersForTag(XmlTagInfo tagInfo) {
        LinkedList<XmlFragmentHandler> possibleHandlers = new LinkedList<XmlFragmentHandler>(this.fGlobalHanders);
        List<XmlFragmentHandler> targetedHandlers = this.fFragmentHandlers.get(tagInfo.getTagName());
        if (targetedHandlers != null) {
            possibleHandlers.addAll(targetedHandlers);
        }
        if (!possibleHandlers.isEmpty()) {
            ArrayList<XmlFragmentHandler> acceptedHandlers = new ArrayList<XmlFragmentHandler>();
            for (XmlFragmentHandler handler : possibleHandlers) {
                if (!handler.useHandler(tagInfo)) continue;
                acceptedHandlers.add(0, handler);
            }
            return acceptedHandlers;
        }
        return null;
    }
}

