/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.facets;

import com.mathworks.helpsearch.facets.DocFacet;
import com.mathworks.helpsearch.facets.DocFacetResults;
import com.mathworks.helpsearch.facets.Facetable;
import com.mathworks.search.SearchException;
import com.mathworks.search.SearchExpression;
import com.mathworks.search.SearchResult;
import com.mathworks.search.SearchResultCollector;
import com.mathworks.search.facet.FacetResult;
import com.mathworks.search.facet.FacetResultCollector;
import java.util.LinkedList;
import java.util.List;

public class FacetSearchHelper<T extends Facetable> {
    private final DocFacet fFacet;
    private final DocFacetResults<T> fResults;
    private FacetResultCollector<T> fCollector;
    private SearchExpression fExpression;

    FacetSearchHelper(DocFacet facet) {
        this.fFacet = facet;
        this.fResults = new DocFacetResults(facet);
    }

    public DocFacet getFacet() {
        return this.fFacet;
    }

    public DocFacetResults<T> getResults() {
        return this.fResults;
    }

    void setCollector(FacetResultCollector<T> collector) {
        this.fCollector = new FacetCollectorWrapper(collector);
    }

    public SearchResultCollector getCollector() {
        return this.fCollector;
    }

    void setExpression(SearchExpression expression) {
        this.fExpression = expression;
    }

    public SearchExpression getExpression() {
        return this.fExpression;
    }

    public void setSelectedFacet(T selectedFacet) {
        this.fResults.setSelectedFacet((Facetable)selectedFacet);
    }

    private class FacetCollectorWrapper
    implements FacetResultCollector<T> {
        private final FacetResultCollector<T> iBaseCollector;

        private FacetCollectorWrapper(FacetResultCollector<T> baseCollector) {
            this.iBaseCollector = baseCollector;
        }

        public List<FacetResult<T>> getResults() {
            return this.iBaseCollector.getResults();
        }

        public void examineResult(SearchResult result) throws SearchException {
            this.iBaseCollector.examineResult(result);
        }

        public void resultsComplete() {
            this.iBaseCollector.resultsComplete();
            List results = this.getResults();
            LinkedList adaptedResults = new LinkedList(results);
            FacetSearchHelper.this.fResults.setResults(adaptedResults);
        }
    }
}

