/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.facets;

import com.mathworks.helpsearch.ContentFormat;
import com.mathworks.helpsearch.DocumentationSearchField;
import java.util.Locale;

public enum DocFacet {
    PRODUCT(DocumentationSearchField.PRODUCT),
    CATEGORY(DocumentationSearchField.ANCESTOR_ID),
    TYPE(DocumentationSearchField.RESULT_TYPE);

    private final DocumentationSearchField fSearchField;

    private DocFacet(DocumentationSearchField searchField) {
        this.fSearchField = searchField;
    }

    public static DocFacet fromFacetPrefix(String facetPrefix) {
        try {
            return DocFacet.valueOf(facetPrefix.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    public String getFacetPrefix() {
        return this.toString().toLowerCase(Locale.ENGLISH);
    }

    public DocumentationSearchField getSearchField() {
        return this.fSearchField;
    }

    public boolean useFacetWithFormat(ContentFormat format) {
        if (this == CATEGORY) {
            return format == ContentFormat.DOC_CENTER_DOC;
        }
        return true;
    }
}

