/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.search.lucene;

import com.mathworks.search.SearchCriteria;
import com.mathworks.search.SearchEngine;
import com.mathworks.search.SearchException;
import com.mathworks.search.SearchField;
import com.mathworks.search.SearchLanguage;
import com.mathworks.search.SearchResult;
import com.mathworks.search.SearchResultCollector;
import com.mathworks.search.SearchSuggestions;
import com.mathworks.search.lucene.HitCollectorSearchResult;
import com.mathworks.search.lucene.HitSearchResult;
import com.mathworks.search.lucene.IndexLocation;
import com.mathworks.search.lucene.LuceneSearchVisitor;
import com.mathworks.search.lucene.MWAnalyzer;
import com.mathworks.search.lucene.MWMultiSearcher;
import com.mathworks.search.lucene.MWSearcher;
import com.mathworks.search.lucene.SuggestionProvider;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Hit;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;

public class LuceneSearchEngine
implements SearchEngine {
    private final Analyzer fAnalyzer;
    private final Collection<SearchField> fDefaultFields;
    private final IndexLocation[] fLocations;
    private MWSearcher fSearcher;

    public LuceneSearchEngine(SearchLanguage language, Collection<? extends SearchField> defaultFields, IndexLocation ... locations) {
        this(new MWAnalyzer(language).getSearchAnalyzer(), defaultFields, locations);
    }

    public LuceneSearchEngine(Analyzer analyzer, Collection<? extends SearchField> defaultFields, IndexLocation ... locations) {
        this.fAnalyzer = analyzer;
        this.fDefaultFields = new LinkedList<SearchField>(defaultFields);
        this.fLocations = new IndexLocation[locations.length];
        System.arraycopy(locations, 0, this.fLocations, 0, locations.length);
    }

    @Override
    public void openIndex() throws IOException {
        this.fSearcher = this.fLocations == null || this.fLocations.length == 0 ? null : (this.fLocations.length > 1 ? new MWMultiSearcher(this.fLocations) : this.fLocations[0].getSearcher());
    }

    private void openIfNecessary() throws IOException {
        if (this.fSearcher == null && this.fLocations != null && this.fLocations.length > 0) {
            this.openIndex();
        }
    }

    private Searcher getIndexSearcher() throws IOException {
        this.openIfNecessary();
        return this.fSearcher != null ? this.fSearcher.getSearcher() : null;
    }

    private IndexReader getIndexReader() throws IOException {
        this.openIfNecessary();
        return this.fSearcher != null ? this.fSearcher.getReader() : null;
    }

    @Override
    public final void search(SearchCriteria criteria, SearchResultCollector ... collectors) throws SearchException {
        Query query = this.toLuceneQuery(criteria);
        try {
            Searcher searcher = this.getIndexSearcher();
            int maxResults = criteria.getMaxResults();
            if (maxResults > 0) {
                this.searchMaxResults(searcher, query, maxResults, collectors);
            } else {
                this.searchAllResults(searcher, query, collectors);
            }
        }
        catch (IOException ioe) {
            throw new SearchException(ioe);
        }
        for (SearchResultCollector collector : collectors) {
            collector.resultsComplete();
        }
    }

    private void searchMaxResults(Searcher searcher, Query query, int maxResults, SearchResultCollector ... collectors) throws IOException, SearchException {
        Hits hits = searcher.search(query);
        Iterator hitsIterator = hits.iterator();
        for (int i = 0; i < maxResults && hitsIterator.hasNext(); ++i) {
            Hit hit = (Hit)hitsIterator.next();
            HitSearchResult result = new HitSearchResult(hit);
            for (SearchResultCollector collector : collectors) {
                collector.examineResult(result);
            }
        }
    }

    private void searchAllResults(Searcher searcher, Query query, SearchResultCollector ... collectors) throws IOException {
        CollectorAdapter hitCollector = new CollectorAdapter(searcher, collectors);
        searcher.search(query, (HitCollector)hitCollector);
    }

    @Override
    public final SearchSuggestions suggest(SearchField field, String partialText, int maxSuggestions) throws SearchException {
        if (field == null) {
            return SearchSuggestions.emptySuggestions();
        }
        try {
            IndexReader reader = this.getIndexReader();
            if (reader != null) {
                SuggestionProvider provider = new SuggestionProvider(reader, field);
                return provider.getSuggestions(partialText, maxSuggestions);
            }
            return SearchSuggestions.emptySuggestions();
        }
        catch (IOException ioe) {
            throw new SearchException(ioe);
        }
    }

    @Override
    public void closeIndex() throws IOException {
        if (this.fSearcher != null) {
            this.fSearcher.close();
        }
    }

    public Map<SearchResult, Explanation> explain(SearchCriteria criteria, int num) throws SearchException {
        LinkedHashMap<SearchResult, Explanation> explanations = new LinkedHashMap<SearchResult, Explanation>();
        Query query = this.toLuceneQuery(criteria);
        try {
            Searcher searcher = this.getIndexSearcher();
            if (searcher != null) {
                Hits hits = searcher.search(query);
                for (int i = 0; i < Math.min(num, hits.length()); ++i) {
                    float score = hits.score(i);
                    int docId = hits.id(i);
                    HitCollectorSearchResult result = new HitCollectorSearchResult(this.fSearcher.getSearcher(), docId, score);
                    explanations.put(result, searcher.explain(query, hits.id(i)));
                }
                return explanations;
            }
            return null;
        }
        catch (IOException ioe) {
            throw new SearchException(ioe);
        }
    }

    private Query toLuceneQuery(SearchCriteria criteria) throws SearchException {
        LuceneSearchVisitor lsv = new LuceneSearchVisitor(this.fAnalyzer, this.fDefaultFields);
        criteria.getExpression().accept(lsv);
        return lsv.getBaseQuery();
    }

    private static class CollectorAdapter
    extends HitCollector {
        private final Searcher iSearcher;
        private final SearchResultCollector[] iResultCollectors;

        private CollectorAdapter(Searcher searcher, SearchResultCollector ... resultCollector) {
            this.iSearcher = searcher;
            this.iResultCollectors = resultCollector;
        }

        public void collect(int i, float v) {
            try {
                HitCollectorSearchResult result = new HitCollectorSearchResult(this.iSearcher, i, v);
                for (SearchResultCollector collector : this.iResultCollectors) {
                    collector.examineResult(result);
                }
            }
            catch (SearchException searchException) {
                // empty catch block
            }
        }
    }
}

