/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.licensing.borrowing.view;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.EventSelectionModel;
import ca.odell.glazedlists.swing.EventTableModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import com.mathworks.mde.licensing.borrowing.comparator.MatlabeticalComparator;
import com.mathworks.mde.licensing.borrowing.controller.BorrowController;
import com.mathworks.mde.licensing.borrowing.model.Feature;
import com.mathworks.mde.licensing.borrowing.view.FeatureColViewUtil;
import com.mathworks.mde.licensing.borrowing.view.ReturnTableFormat;
import com.mathworks.mde.licensing.borrowing.view.ReturnView;
import com.mathworks.mde.licensing.borrowing.view.ScrollPaneComponentAdapter;
import com.mathworks.mde.licensing.borrowing.view.SelectableFeature;
import com.mathworks.mde.licensing.borrowing.view.SelectableFeatureImpl;
import com.mathworks.mde.licensing.borrowing.view.SubPanelView;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJTable;
import com.mathworks.mwswing.table.ListColorUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public final class ReturnViewImpl
implements ReturnView,
SubPanelView {
    public static final String RETURN_BUTTON_NAME = "ReturnButton";
    public static final String RETURNFEATURE_PANEL_NAME = "ReturnFeaturePanel";
    public static final String RETURN_TABLE_NAME = "ReturnTable";
    public static final String TABLE_SCROLLPANE_NAME = "TableScrollPane";
    private final Collection<SelectableFeature> fSelectableFeatures = new ArrayList<SelectableFeature>();
    private EventList<SelectableFeature> featureTableList;
    private final BorrowController fController;
    private JPanel subPanel;
    private MJButton fReturnButton;
    private MJTable returnTable;
    private ReturnTableFormat returnFormat;
    private EventTableModel fFeatureTableModel;
    private MatlabeticalComparator featureComparator;
    private final ResourceBundle fResBundle;
    private static final int NUM_ROWS_TO_DISPALY = 7;
    private final Observer fFeatureObserver;
    private final ActionListener fButtonListener;

    public ReturnViewImpl(BorrowController borrowController, ResourceBundle resourceBundle) {
        this.fController = borrowController;
        this.fResBundle = resourceBundle;
        this.fFeatureObserver = new FeatureSelectionObserver();
        this.fButtonListener = new ReturnButtonListener();
        this.createComponents();
    }

    private void createComponents() {
        this.returnTable = new MJTable();
        this.returnTable.setName(RETURN_TABLE_NAME);
        this.featureTableList = new BasicEventList();
        this.returnFormat = new ReturnTableFormat(this.fResBundle);
        this.featureComparator = new MatlabeticalComparator();
    }

    private void createFeatureTableList() {
        for (SelectableFeature feature : this.fSelectableFeatures) {
            feature.deleteObservers();
        }
        this.fSelectableFeatures.clear();
        Collection<Feature> collection = this.fController.getFlexFeatures();
        for (Feature feature : collection) {
            if (!feature.isBorrowed()) continue;
            this.fSelectableFeatures.add(new SelectableFeatureImpl(true, feature));
        }
        for (SelectableFeature selectableFeature : this.fSelectableFeatures) {
            selectableFeature.addObserver(this.fFeatureObserver);
        }
        this.featureTableList.clear();
        this.featureTableList.addAll(this.fSelectableFeatures);
        Iterator<Feature> iterator = new SortedList(this.featureTableList, (Comparator)this.featureComparator);
        if (this.fFeatureTableModel == null || this.featureTableList == null) {
            this.fFeatureTableModel = new EventTableModel(iterator, (TableFormat)this.returnFormat);
        }
    }

    private JPanel buildSubPanel() {
        ColumnSpec[] columnSpecArray = new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.PREFERRED, 1.0)};
        RowSpec[] rowSpecArray = new RowSpec[]{new RowSpec(RowSpec.DEFAULT, (Size)Sizes.PREFERRED, 0.0), new RowSpec((Size)Sizes.dluY((int)10)), new RowSpec(RowSpec.FILL, (Size)Sizes.PREFERRED, 0.0), new RowSpec((Size)Sizes.DLUY14), new RowSpec(RowSpec.DEFAULT, (Size)Sizes.PREFERRED, 0.0)};
        FormLayout formLayout = new FormLayout(columnSpecArray, rowSpecArray);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addSeparator(this.fResBundle.getString("returnproducts.title"), cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.createTable(), cellConstraints.xy(1, 3));
        panelBuilder.add((Component)this.createButtonPanel(), cellConstraints.xy(1, 5));
        return panelBuilder.getPanel();
    }

    private JComponent createTable() {
        this.createFeatureTableList();
        EventSelectionModel eventSelectionModel = new EventSelectionModel(this.featureTableList);
        eventSelectionModel.setSelectionMode(0);
        this.returnTable.setModel((TableModel)this.fFeatureTableModel);
        this.returnTable.setSelectionModel((ListSelectionModel)eventSelectionModel);
        this.returnTable.getTableHeader().setReorderingAllowed(false);
        FeatureColViewUtil.sizeTableColumnsToContents((JTable)this.returnTable);
        TableColumnModel tableColumnModel = this.returnTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setMaxWidth(tableColumn.getMinWidth());
        ListColorUtils.setupForList((JTable)this.returnTable);
        JScrollPane jScrollPane = new JScrollPane((Component)this.returnTable);
        jScrollPane.setName(TABLE_SCROLLPANE_NAME);
        int n = 7 * this.returnTable.getRowHeight();
        this.returnTable.setPreferredScrollableViewportSize(new Dimension(0, n));
        this.returnTable.getParent().setBackground(this.returnTable.getBackground());
        jScrollPane.addComponentListener(new ScrollPaneComponentAdapter(this.returnTable));
        return jScrollPane;
    }

    private JPanel createButtonPanel() {
        this.fReturnButton = new MJButton(this.fResBundle.getString("button.return"));
        this.fReturnButton.setName(RETURN_BUTTON_NAME);
        this.fReturnButton.setMnemonic(82);
        this.fReturnButton.addActionListener(this.fButtonListener);
        JPanel jPanel = ButtonBarFactory.buildRightAlignedBar((JButton)this.fReturnButton);
        return jPanel;
    }

    @Override
    public Collection<Feature> getSelectedFeatures() {
        LinkedList<Feature> linkedList = new LinkedList<Feature>();
        for (SelectableFeature selectableFeature : this.fSelectableFeatures) {
            if (!selectableFeature.getSelected()) continue;
            linkedList.add(selectableFeature);
        }
        return linkedList;
    }

    @Override
    public void enableReturnButton() {
        this.fReturnButton.setEnabled(true);
    }

    @Override
    public void disableReturnButton() {
        this.fReturnButton.setEnabled(false);
    }

    @Override
    public JPanel createSubPanelView() {
        this.subPanel = this.buildSubPanel();
        this.subPanel.setName(RETURNFEATURE_PANEL_NAME);
        return this.subPanel;
    }

    private class FeatureSelectionObserver
    implements Observer {
        private FeatureSelectionObserver() {
        }

        @Override
        public void update(Observable observable, Object object) {
            if (object == null) {
                if (observable instanceof SelectableFeature) {
                    SelectableFeature selectableFeature = (SelectableFeature)((Object)observable);
                    ReturnViewImpl.this.fController.returnFeatureSelected(selectableFeature.getSelected());
                }
            } else if (object.equals("return") && observable instanceof SelectableFeature) {
                SelectableFeature selectableFeature = (SelectableFeature)((Object)observable);
                int n = ReturnViewImpl.this.featureTableList.indexOf((Object)selectableFeature);
                if (n >= 0) {
                    ReturnViewImpl.this.featureTableList.remove(n);
                }
            }
        }
    }

    private class ReturnButtonListener
    implements ActionListener {
        private ReturnButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ReturnViewImpl.this.fController.performReturnAction();
        }
    }
}

