/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help.search;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jidesoft.swing.StyleRange;
import com.jidesoft.swing.StyledLabel;
import com.mathworks.mde.help.search.HelpBrowserSearchPrefs;
import com.mathworks.mde.help.search.HelpBrowserSearchResult;
import com.mathworks.mde.help.search.HighlightProvider;
import com.mathworks.mde.help.search.SearchHighlight;
import com.mathworks.mde.help.search.SearchIconUtils;
import com.mathworks.mde.help.search.SearchResultCellColors;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class SearchResultCell {
    private static final String TITLE_SUMMARY_DIVIDER = " - ";
    private static final SimpleAttributeSet BASE_ATTRIBUTES = new SimpleAttributeSet();
    private static final SimpleAttributeSet HIGHLIGHT_ATTRIBUTES = new SimpleAttributeSet();
    private final HelpBrowserSearchResult fResult;
    private MJPanel fPanel = new MJPanel();
    private HighlightProvider fHighlightProvider;

    SearchResultCell(HelpBrowserSearchResult helpBrowserSearchResult, HighlightProvider highlightProvider) {
        this.fPanel.setName("SearchResult_" + helpBrowserSearchResult.getProductName() + "_" + helpBrowserSearchResult.getSection() + "_" + helpBrowserSearchResult.getTitle());
        this.fHighlightProvider = highlightProvider;
        this.fResult = helpBrowserSearchResult;
        this.setOpaque(true);
    }

    public HelpBrowserSearchResult getResult() {
        return this.fResult;
    }

    JComponent getComponent() {
        this.renderResultInPanel(this.fResult);
        return this.fPanel;
    }

    static void updateColors() {
        StyleConstants.setForeground(BASE_ATTRIBUTES, SearchResultCellColors.getHighlightsForeground());
        StyleConstants.setBold(HIGHLIGHT_ATTRIBUTES, true);
        StyleConstants.setForeground(HIGHLIGHT_ATTRIBUTES, SearchResultCellColors.getHighlightsForeground());
    }

    static boolean shouldShowHighlights() {
        return HelpBrowserSearchPrefs.shouldShowHighlights(true);
    }

    static void setShouldShowHighlights(boolean bl) {
        HelpBrowserSearchPrefs.setShouldShowHighlights(bl);
    }

    static int getCellHeight(int n) {
        if (SearchResultCell.shouldShowHighlights()) {
            return 4 * n + 4;
        }
        return Math.max(n, 16) + 4;
    }

    void setFont(Font font) {
        this.fPanel.setFont(font);
    }

    void setBackground(Color color) {
        this.fPanel.setBackground(color);
    }

    void setForeground(Color color) {
        this.fPanel.setForeground(color);
    }

    void setOpaque(boolean bl) {
        this.fPanel.setOpaque(bl);
    }

    private void renderResultInPanel(HelpBrowserSearchResult helpBrowserSearchResult) {
        if (SearchResultCell.shouldShowHighlights()) {
            this.renderWithHighlights(helpBrowserSearchResult);
        } else {
            this.renderWithoutHighlights(helpBrowserSearchResult);
        }
    }

    private void renderWithHighlights(HelpBrowserSearchResult helpBrowserSearchResult) {
        JComponent jComponent;
        this.fPanel.setLayout((LayoutManager)new FormLayout("16px, 5px, default:grow, default, 5px", "pref, pref, pref"));
        CellConstraints cellConstraints = new CellConstraints();
        Icon icon = SearchResultCell.getIcon(helpBrowserSearchResult);
        if (icon != null) {
            jComponent = new MJLabel(icon);
            this.fPanel.add((Component)jComponent, (Object)cellConstraints.xywh(1, 1, 1, 3, CellConstraints.FILL, CellConstraints.TOP));
        }
        jComponent = this.getTitleComponent(helpBrowserSearchResult);
        this.fPanel.add((Component)jComponent, (Object)cellConstraints.xyw(3, 1, 3));
        JComponent jComponent2 = this.getHighlightsComponent(helpBrowserSearchResult);
        this.fPanel.add((Component)jComponent2, (Object)cellConstraints.xyw(3, 2, 3));
        JComponent jComponent3 = this.getProdComponent(helpBrowserSearchResult);
        this.fPanel.add((Component)jComponent3, (Object)cellConstraints.xy(4, 3));
    }

    private void renderWithoutHighlights(HelpBrowserSearchResult helpBrowserSearchResult) {
        JComponent jComponent;
        this.fPanel.setLayout((LayoutManager)new FormLayout("16px, 5px, 5px:grow, 5px, pref", "pref"));
        CellConstraints cellConstraints = new CellConstraints();
        Icon icon = SearchResultCell.getIcon(helpBrowserSearchResult);
        if (icon != null) {
            jComponent = new MJLabel(icon);
            this.fPanel.add((Component)jComponent, (Object)cellConstraints.xy(1, 1, CellConstraints.FILL, CellConstraints.CENTER));
        }
        jComponent = this.getTitleComponent(helpBrowserSearchResult);
        this.fPanel.add((Component)jComponent, (Object)cellConstraints.xy(3, 1));
        JComponent jComponent2 = this.getProdComponent(helpBrowserSearchResult);
        this.fPanel.add((Component)jComponent2, (Object)cellConstraints.xy(5, 1));
    }

    private static Icon getIcon(HelpBrowserSearchResult helpBrowserSearchResult) {
        return SearchIconUtils.getIconForResultType(helpBrowserSearchResult.getType());
    }

    private JComponent getTitleComponent(HelpBrowserSearchResult helpBrowserSearchResult) {
        String string = helpBrowserSearchResult.getTitle();
        String string2 = helpBrowserSearchResult.getSummaryLine();
        String string3 = string2 == null ? string : string + TITLE_SUMMARY_DIVIDER + string2;
        StyledLabel styledLabel = new StyledLabel(string3);
        styledLabel.setName("Title");
        styledLabel.addStyleRange(new StyleRange(0, string.length(), 1, SearchResultCellColors.getTitleForeground()));
        this.setFontAndColors((JComponent)styledLabel);
        return styledLabel;
    }

    private JComponent getHighlightsComponent(HelpBrowserSearchResult helpBrowserSearchResult) {
        JComponent jComponent;
        try {
            Collection<SearchHighlight> collection = SearchResultCell.getHighlightsToDisplay(helpBrowserSearchResult);
            if (collection.isEmpty()) {
                jComponent = SearchResultCell.getNoHighlightsComponent();
            } else {
                MJTextPane mJTextPane = new MJTextPane();
                StyledDocument styledDocument = mJTextPane.getStyledDocument();
                for (SearchHighlight searchHighlight : collection) {
                    SearchResultCell.insertHighlights(styledDocument, searchHighlight);
                }
                jComponent = mJTextPane;
            }
        }
        catch (Exception exception) {
            jComponent = SearchResultCell.getNoHighlightsComponent();
        }
        jComponent.setFont(this.fPanel.getFont());
        jComponent.setBackground(this.fPanel.getBackground());
        int n = jComponent.getFontMetrics(jComponent.getFont()).getHeight();
        int n2 = 2 * n + 2;
        jComponent.setMaximumSize(new Dimension(Integer.MAX_VALUE, n2));
        jComponent.setPreferredSize(new Dimension(jComponent.getPreferredSize().width, n2));
        jComponent.setName("Highlights");
        return jComponent;
    }

    public static Collection<SearchHighlight> getHighlightsToDisplay(HelpBrowserSearchResult helpBrowserSearchResult) {
        Collection<SearchHighlight> collection = helpBrowserSearchResult.getHighlights();
        ArrayList<SearchHighlight> arrayList = new ArrayList<SearchHighlight>();
        for (SearchHighlight searchHighlight : collection) {
            String string = searchHighlight.getHighlightText();
            String string2 = helpBrowserSearchResult.getSummaryLine();
            if (string2 == null) {
                string2 = "";
            }
            if (helpBrowserSearchResult.getTitle().contains(string) || string2.contains(string)) continue;
            arrayList.add(searchHighlight);
        }
        if (arrayList.isEmpty()) {
            return collection;
        }
        return arrayList;
    }

    private static void insertHighlights(Document document, SearchHighlight searchHighlight) throws BadLocationException {
        if (document.getLength() > 0) {
            document.insertString(document.getLength(), " ... ", BASE_ATTRIBUTES);
        }
        String string = searchHighlight.getHighlightText();
        int n = 0;
        for (SearchHighlight.Extent extent : searchHighlight.getExtents()) {
            document.insertString(document.getLength(), string.substring(n, extent.getStart()), BASE_ATTRIBUTES);
            document.insertString(document.getLength(), string.substring(extent.getStart(), extent.getEnd()), HIGHLIGHT_ATTRIBUTES);
            n = extent.getEnd();
        }
        document.insertString(document.getLength(), string.substring(n), BASE_ATTRIBUTES);
    }

    private static JComponent getNoHighlightsComponent() {
        MJLabel mJLabel = new MJLabel(HelpUtils.getLocalizedString((String)"searchfilelist.no_preview"));
        mJLabel.setForeground(SearchResultCellColors.getHighlightsForeground());
        mJLabel.setName("NoPreview");
        return mJLabel;
    }

    private JComponent getProdComponent(HelpBrowserSearchResult helpBrowserSearchResult) {
        MJLabel mJLabel = new MJLabel();
        mJLabel.setTipWhenTruncatedEnabled(true);
        mJLabel.setMinimumSize(new Dimension(0, mJLabel.getHeight()));
        mJLabel.setText(helpBrowserSearchResult.getProductName());
        mJLabel.setBackground(this.fPanel.getBackground());
        mJLabel.setForeground(SearchResultCellColors.getProdSectForeground());
        mJLabel.setFont(this.fPanel.getFont());
        mJLabel.setName("Product");
        return mJLabel;
    }

    private void setFontAndColors(JComponent jComponent) {
        jComponent.setBackground(this.fPanel.getBackground());
        jComponent.setForeground(this.fPanel.getForeground());
        jComponent.setFont(this.fPanel.getFont());
    }
}

