/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.plugins.matlab;

import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.mde.desk.MLMenuMergeTag;
import com.mathworks.mde.editor.breakpoints.MatlabBreakpointMargin;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import java.awt.event.ActionEvent;
import javax.swing.Action;

public class MatlabDebugActions {
    public static final String TOGGLE_BREAKPOINT_ID = "set-clear-breakpoint";
    public static final String ENABLE_BREAKPOINT_ID = "enable-disable-breakpoint";
    public static final String CONDITIONAL_BREAKPOINT_ID = "set-modify-breakpoint-condition";

    private MatlabDebugActions() {
    }

    public static MJAbstractAction createSetClearBreakpointAction(final Editor editor) {
        MatlabAbstractDebugActions matlabAbstractDebugActions = new MatlabAbstractDebugActions(TOGGLE_BREAKPOINT_ID, editor){

            public void actionPerformed(ActionEvent actionEvent) {
                editor.getBreakpointMargin().toggle(editor.getLineNumber());
            }
        };
        MLMenuMergeTag.TOGGLE_BREAKPOINT.setTag((Action)((Object)matlabAbstractDebugActions));
        return matlabAbstractDebugActions;
    }

    public static MJAbstractAction createEnableDisableBreakpointAction(final Editor editor) {
        MatlabAbstractDebugActions matlabAbstractDebugActions = new MatlabAbstractDebugActions(ENABLE_BREAKPOINT_ID, editor){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = editor.getLineNumber();
                ((MatlabBreakpointMargin)editor.getBreakpointMargin()).toggleEnablement(n);
            }
        };
        MLMenuMergeTag.ENABLE_BREAKPOINT.setTag((Action)((Object)matlabAbstractDebugActions));
        return matlabAbstractDebugActions;
    }

    public static MJAbstractAction createSetConditionalBreakpointAction(final Editor editor) {
        MatlabAbstractDebugActions matlabAbstractDebugActions = new MatlabAbstractDebugActions(CONDITIONAL_BREAKPOINT_ID, editor){

            public void actionPerformed(ActionEvent actionEvent) {
                ((MatlabBreakpointMargin)editor.getBreakpointMargin()).modifyCondition(editor.getLineNumber());
            }
        };
        MLMenuMergeTag.CONDITIONAL_BREAKPOINT.setTag((Action)((Object)matlabAbstractDebugActions));
        return matlabAbstractDebugActions;
    }

    private static void configureMatlabDebugContextKeyBinding(MJAbstractAction mJAbstractAction, String string) {
        MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABEditor", string, (ExtendedAction)mJAbstractAction);
    }

    private static abstract class MatlabAbstractDebugActions
    extends MJAbstractAction {
        protected final Editor fEditor;

        MatlabAbstractDebugActions(String string, Editor editor) {
            this.fEditor = editor;
            MatlabDebugActions.configureMatlabDebugContextKeyBinding(this, string);
            this.setEnabled(this.fEditor != null && this.fEditor.getStorageLocation() instanceof FileStorageLocation);
        }
    }
}

