/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor;

import com.mathworks.matlab.api.datamodel.BackingStore;
import com.mathworks.matlab.api.datamodel.StorageLocation;
import com.mathworks.matlab.api.dataview.UiInfoProvider;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.editor.EditorEvent;
import com.mathworks.matlab.api.editor.actions.DebuggerActions;
import com.mathworks.matlab.api.explorer.ActionInputSource;
import com.mathworks.matlab.api.explorer.ActionProvider;
import com.mathworks.matlab.api.explorer.ActionRegistry;
import com.mathworks.matlab.api.explorer.CoreActionID;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mde.editor.ActionManager;
import com.mathworks.mde.editor.DialogFactory;
import com.mathworks.mde.editor.EditorAction;
import com.mathworks.mde.editor.EditorGroup;
import com.mathworks.mde.editor.EditorOptions;
import com.mathworks.mde.editor.EditorStartup;
import com.mathworks.mde.editor.EditorStateManagerFactory;
import com.mathworks.mde.editor.EditorStatusBar;
import com.mathworks.mde.editor.EditorToolstripTabFactory;
import com.mathworks.mde.editor.EditorUiUtils;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mde.editor.EditorView;
import com.mathworks.mde.editor.EditorViewCallback;
import com.mathworks.mde.editor.EditorViewListener;
import com.mathworks.mde.editor.EditorViewUtils;
import com.mathworks.mde.editor.MatlabEditor;
import com.mathworks.mde.editor.MatlabEditorApplication;
import com.mathworks.mde.editor.PathActionInputSource;
import com.mathworks.mde.editor.TextFileUiInfoProvider;
import com.mathworks.mde.find.FindFiles;
import com.mathworks.mlservices.MatlabDebugAdapter;
import com.mathworks.mlservices.MatlabDebugObserver;
import com.mathworks.mlwidgets.debug.MatlabDebuggerActions;
import com.mathworks.mlwidgets.explorer.extensions.basic.CoreActionProvider;
import com.mathworks.mlwidgets.explorer.extensions.basic.NavigationActionProvider;
import com.mathworks.mlwidgets.explorer.extensions.matlab.PathActionProvider;
import com.mathworks.mlwidgets.stack.StackComboBox;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuBar;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.SimpleElement;
import com.mathworks.mwswing.api.DirtyStateChangeListener;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.util.AbsoluteFile;
import com.mathworks.util.FileUtils;
import com.mathworks.util.Log;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import com.mathworks.widgets.datamodel.StorageLocationUtils;
import com.mathworks.widgets.datamodel.TextFileBackingStore;
import com.mathworks.widgets.debug.DebuggerManager;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientBase;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.DTGroupPropertyProvider;
import com.mathworks.widgets.desk.DTMenuBoundary;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.desk.DTRecoverable;
import com.mathworks.widgets.desk.DTUnableToOpenException;
import com.mathworks.widgets.text.STPInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.apache.commons.lang.Validate;
import org.w3c.dom.Element;

public class EditorViewClient
extends DTClientBase
implements DTRecoverable {
    private static final String FILE_NAME = "EditorFileName";
    private EditorView fEditorView;
    private MJMenuBar fMenuBar;
    private MatlabDebugObserver fDebugStateListener = new DebugStateListener();
    private DebuggerManager.DebuggerManagerStateListener fDebuggerManagerStateListener = new DebuggerManager.DebuggerManagerStateListener(){

        public void stateUpdated(DebuggerManager.DebuggerTransition debuggerTransition, Class<? extends DebuggerActions> clazz) {
            if (MatlabDebuggerActions.class.equals(clazz)) {
                return;
            }
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (EditorViewClient.this.getEditorView() != null) {
                        EditorViewClient.this.createToolstripTabs();
                    }
                }
            });
        }
    };
    private EditorStatusBar fStatusBar;
    private MatlabEditor fEditor;
    private EditorToolstripTabFactory fToolstripTabFactory;
    private PropertyChangeListener fNameChangeListener = this.createNameChangeListener();
    private DirtyStateChangeListener fDirtyStateChangeListener = this.createDirtyStateChangeListener();
    private DTClientListener fDtClientListener = this.createDTClientListener();
    private StackComboBox fStackDisplay;
    private com.mathworks.mlwidgets.explorer.model.actions.ActionManager fPathActionManager;
    private MJMenu fPathContextMenu;
    private final PropertyChangeListener fRecreateDocumentTabContextMenu = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                EditorViewClient.this.buildDocumentTabContextMenu();
            }
        }
    };
    private boolean fCloseNoPrompt;
    private final Lock fPreventDisposalLock = new ReentrantLock();

    public EditorViewClient(BackingStore<Document> backingStore, UiInfoProvider uiInfoProvider) throws Exception {
        this.init(backingStore, uiInfoProvider);
    }

    public EditorViewClient(SimpleElement simpleElement) throws Exception {
        File file;
        File file2 = file = simpleElement.getAttribute(FILE_NAME) != null ? new File(simpleElement.getAttribute(FILE_NAME)) : null;
        if (file == null || !file.exists()) {
            String string = file == null ? "" : file.getAbsolutePath();
            EditorStateManagerFactory.getEditorStateManager().clearState(string);
            throw new DTUnableToOpenException("File " + string + " no longer exists.");
        }
        TextFileBackingStore textFileBackingStore = TextFileBackingStore.createWithExistentBackingFile((File)file);
        TextFileUiInfoProvider textFileUiInfoProvider = new TextFileUiInfoProvider(textFileBackingStore);
        this.init((BackingStore<Document>)textFileBackingStore, (UiInfoProvider)textFileUiInfoProvider);
        MatlabEditorApplication.installDefaultEditorFeatures(textFileBackingStore, (UiInfoProvider)textFileUiInfoProvider, this);
    }

    private void init(BackingStore<Document> backingStore, UiInfoProvider uiInfoProvider) throws Exception {
        assert (SwingUtilities.isEventDispatchThread()) : "EditorViewClient creation must be on EDT.";
        this.setName("EditorViewContainer");
        uiInfoProvider.addPropertyChangeListener(this.fNameChangeListener);
        this.fEditor = new MatlabEditor(this, uiInfoProvider, backingStore);
        this.fStackDisplay = EditorViewClient.createStackComboBox(this.fEditor);
        this.fEditorView = new EditorView(backingStore, uiInfoProvider, this.createEditorViewCallback());
        this.fEditorView.getActionManager().updateDirtyDependentActions(this.isDirty());
        this.fEditorView.addDirtyStateChangeListener(this.fDirtyStateChangeListener);
        this.fEditorView.addEditorViewListener(this.createEditorViewListener());
        this.fToolstripTabFactory = new EditorToolstripTabFactory(this.fEditor, this.fEditorView.getActionManager());
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.add((Component)((Object)this.fEditorView), "Center");
        this.reinitializeToolBarMenusAndStatusBar();
        this.setMultipleInstances(true);
        EditorStartup.addDebugObserver(this.fDebugStateListener);
        DebuggerManager.addDebugManagerStateListener((DebuggerManager.DebuggerManagerStateListener)this.fDebuggerManagerStateListener);
        this.getEditor().fireEditorEvent(EditorEvent.DEBUG_MODE_CHANGED);
        this.setAppendsAsteriskWhenDirty(true);
        this.updateShortAndLongTitle();
        this.setGroup((DTGroupPropertyProvider)EditorGroup.getInstance());
        EditorStartup.getParentDesktop().addClientListener((Component)((Object)this), this.fDtClientListener);
    }

    private static StackComboBox createStackComboBox(Editor editor) {
        StackComboBox stackComboBox = null;
        if (StorageLocationUtils.isOrWillBeBackedByFile((StorageLocation)editor.getStorageLocation())) {
            stackComboBox = new StackComboBox();
        }
        return stackComboBox;
    }

    void setEditorStatusBarText(String string) {
        this.fStatusBar.setTextToAppend(string);
    }

    public void dispose() {
        this.fToolstripTabFactory.disposeTabs();
        this.getEditorView().saveAndCleanupEditorState();
        this.fStatusBar.cleanup();
        this.fEditorView.dispose();
        this.fEditorView = null;
        this.fMenuBar.dispose();
        this.fMenuBar = null;
        this.disposePathActionManager();
        EditorStartup.removeDebugObserver(this.fDebugStateListener);
        DebuggerManager.removeDebugManagerStateListener((DebuggerManager.DebuggerManagerStateListener)this.fDebuggerManagerStateListener);
        EditorStartup.getParentDesktop().removeClientListener((Component)((Object)this), this.fDtClientListener);
        this.fDebugStateListener = null;
        this.fDebuggerManagerStateListener = null;
        this.fEditor.dispose();
        this.fEditor = null;
        if (this.fStackDisplay != null) {
            this.fStackDisplay.dispose();
        }
    }

    private void disposePathActionManager() {
        if (this.fPathActionManager != null) {
            this.fPathActionManager.getAction(CoreActionID.ADD_CONTAINING_FOLDER_TO_PATH).removePropertyChangeListener(this.fRecreateDocumentTabContextMenu);
            this.fPathActionManager.dispose();
            this.fPathActionManager = null;
        }
    }

    private EditorViewListener createEditorViewListener() {
        return new EditorViewListener(){

            @Override
            public void languageOrFilenameChanged() {
                EditorViewClient.this.reinitializeToolBarMenusAndStatusBar();
            }
        };
    }

    private EditorViewCallback createEditorViewCallback() {
        return new EditorViewCallback(){

            @Override
            public void setStatusText(String string) {
                EditorViewClient.this.setStatusText(string);
            }

            @Override
            public Component getDesktopClient() {
                return EditorViewClient.this;
            }

            @Override
            public Editor getCorrespondingEditor() {
                return EditorViewClient.this.fEditor;
            }
        };
    }

    private void reinitializeToolBarMenusAndStatusBar() {
        this.createToolbar();
        this.createMenuBar();
        this.createToolstripTabs();
        this.createDocumentTabContextMenu();
        this.createStatusBar();
    }

    public EditorView getEditorView() {
        return this.fEditorView;
    }

    static EditorView getActiveEditorView() {
        return MatlabEditorApplication.getLastActiveEditorViewClient() == null ? null : MatlabEditorApplication.getLastActiveEditorViewClient().getEditorView();
    }

    public void requestFocus() {
        this.getEditorView().requestFocus();
    }

    void refreshMenuBar() {
        if (this.fMenuBar != null) {
            this.setMenuBar((JMenuBar)this.fMenuBar);
        }
    }

    void close() {
        EditorStartup.getParentDesktop().closeClient((Component)((Object)this));
    }

    void closeNoPrompt() {
        this.fCloseNoPrompt = true;
        this.close();
    }

    void setContents(String string) {
        this.getEditorView().setContents(string);
    }

    void setIsDockedInDesktop(boolean bl) {
        this.getEditorView().setIsDockedInDesktop(bl);
    }

    private boolean isDirty() {
        return this.getEditorView().isDirty();
    }

    private void tryClosing(DTClientEvent dTClientEvent) {
        if (this.fCloseNoPrompt || !this.getEditorView().getBackingStore().shouldSaveOnClose((Object)this.getEditorView().getSyntaxTextPane().getDocument()) || !this.isDirtyAfterPromptingToReloadIfNecessary()) {
            this.approveDesktopClose(dTClientEvent);
        } else {
            int n = DialogFactory.showCloseDirty((Component)((Object)this.getEditorView()), this.getEditorView().getUiInfoProvider().getShortName());
            if (n == 0 && this.getEditorView().negotiateSave()) {
                this.approveDesktopClose(dTClientEvent);
            } else if (n == 1) {
                this.approveDesktopClose(dTClientEvent);
            } else {
                this.vetoClose(dTClientEvent.getData());
            }
        }
    }

    private void approveDesktopClose(DTClientEvent dTClientEvent) {
        this.setDontReopen(this.getEditor().isBuffer() || !EditorOptions.isReopenFilesUponStart());
        this.approveClose(dTClientEvent.getData());
    }

    private boolean isDirtyAfterPromptingToReloadIfNecessary() {
        this.getEditorView().promptToReloadIfNecessary();
        return this.isDirty();
    }

    private void setActive() {
        this.updateShortAndLongTitle();
        this.getEditorView().promptToReloadIfNecessary();
        this.getEditorView().setActive();
    }

    void reload(boolean bl) {
        assert (SwingUtilities.isEventDispatchThread()) : "Reload must be called on EDT.";
        this.getEditorView().reload(bl);
    }

    String getShortTitle() {
        String string = this.getEditorView().getUiInfoProvider().getShortName();
        return this.isDirty() ? EditorViewClient.createDirtyTitle(string) : string;
    }

    String getLongTitle() {
        String string = this.getEditorView().getBackingStore().isPersistenceLocationSet() && this.getEditorView().getBackingStore().isReadOnly() ? EditorViewClient.createReadOnlyTitle(this.getEditorView().getUiInfoProvider().getLongName()) : this.getEditorView().getUiInfoProvider().getLongName();
        return this.isDirty() ? EditorViewClient.createDirtyTitle(string) : string;
    }

    private void updateShortAndLongTitle() {
        this.updateLongTitle();
        this.updateShortTitle();
    }

    private void updateLongTitle() {
        this.setTitle(this.getLongTitle());
    }

    private void updateShortTitle() {
        this.setShortTitle(this.getShortTitle());
    }

    public Editor getEditor() {
        return this.fEditor;
    }

    void lock() {
        this.fPreventDisposalLock.lock();
    }

    void unlock() {
        this.fPreventDisposalLock.unlock();
    }

    public void setStackComboBox(StackComboBox stackComboBox) {
        Validate.notNull((Object)stackComboBox, (String)"The stack display cannot be null.");
        this.fStackDisplay = stackComboBox;
    }

    public StackComboBox getStackComboBox() {
        return this.fStackDisplay;
    }

    private void createStatusBar() {
        if (this.fStatusBar != null) {
            this.fStatusBar.cleanup();
        }
        this.fStatusBar = new EditorStatusBar(this.getEditorView());
        this.setStatusBar(this.fStatusBar);
    }

    void createToolbar() {
        this.setToolBarInfo(this.getEditorView().getActionManager().createToolbarInfo(this.getStackComboBox()));
    }

    private void createMenuBar() {
        if (this.fMenuBar != null) {
            this.fMenuBar.dispose();
        }
        this.fMenuBar = this.getEditorView().getActionManager().createMenuBar();
        this.setMenuBar((JMenuBar)this.fMenuBar);
    }

    private void createToolstripTabs() {
        if (MLDesktop.getInstance().useToolstrip()) {
            this.fToolstripTabFactory.disposeTabs();
            List<ToolstripTab> list = this.fToolstripTabFactory.createTabs();
            this.setToolstripTabs(list.toArray(new ToolstripTab[list.size()]));
        }
    }

    private void createDocumentTabContextMenu() {
        this.disposePathActionManager();
        if (this.getEditorView().isBackedByFile()) {
            File file = this.getEditorView().getBackingFile().toFile();
            ArrayList<DocumentTabActionProvider> arrayList = new ArrayList<DocumentTabActionProvider>();
            arrayList.add(new DocumentTabActionProvider(file.getParent()));
            arrayList.add((DocumentTabActionProvider)new CoreActionProvider());
            arrayList.add((DocumentTabActionProvider)new NavigationActionProvider());
            arrayList.add((DocumentTabActionProvider)new PathActionProvider());
            this.fPathActionManager = new com.mathworks.mlwidgets.explorer.model.actions.ActionManager("MATLABEditor", (ActionInputSource)new PathActionInputSource(this.fEditorView.getSyntaxTextPane().getActiveTextComponent(), file), arrayList, true, false, new Object[]{CoreActionID.CD_TO_LOCATION, CoreActionID.ADD_CONTAINING_FOLDER_TO_PATH, CoreActionID.REMOVE_CONTAINING_FOLDER_FROM_PATH, CoreActionID.LOCATE_ON_DISK});
            this.fPathActionManager.getAction(CoreActionID.ADD_CONTAINING_FOLDER_TO_PATH).addPropertyChangeListener(this.fRecreateDocumentTabContextMenu);
            this.buildDocumentTabContextMenu();
        } else {
            this.setPathContextMenu(null);
        }
    }

    private void setPathContextMenu(MJMenu mJMenu) {
        if (this.fPathContextMenu != null) {
            this.fPathContextMenu.dispose();
        }
        this.fPathContextMenu = mJMenu;
        this.setContextMenu((JMenu)this.fPathContextMenu);
    }

    private void buildDocumentTabContextMenu() {
        assert (this.fPathActionManager != null);
        assert (this.getEditorView().isBackedByFile());
        MJMenu mJMenu = new MJMenu();
        mJMenu.add((JMenuItem)new DTMenuBoundary(DTMenuMergeTag.START_OF_MENU));
        mJMenu.add((Action)this.fPathActionManager.getAction(CoreActionID.CD_TO_LOCATION));
        MJAbstractAction mJAbstractAction = this.fPathActionManager.getAction(CoreActionID.ADD_CONTAINING_FOLDER_TO_PATH);
        mJAbstractAction.setComponentName("add-to-path");
        MJAbstractAction mJAbstractAction2 = this.fPathActionManager.getAction(CoreActionID.REMOVE_CONTAINING_FOLDER_FROM_PATH);
        mJAbstractAction2.setComponentName("remove-from-path");
        mJMenu.add((Action)(mJAbstractAction.isEnabled() ? mJAbstractAction : mJAbstractAction2));
        MJAbstractAction mJAbstractAction3 = this.fPathActionManager.getAction(CoreActionID.LOCATE_ON_DISK);
        if (mJAbstractAction3.isEnabled()) {
            mJMenu.add((Action)mJAbstractAction3);
        }
        mJMenu.add((Action)this.getEditorView().getActionManager().getAction(EditorAction.COPY_FULL_PATH));
        mJMenu.addSeparator();
        this.setPathContextMenu(mJMenu);
    }

    public void appendText(String string) {
        if (string != null && string.length() > 0) {
            STPInterface sTPInterface = this.getEditorView().getSyntaxTextPane();
            int n = sTPInterface.getLength();
            sTPInterface.select(n, n);
            sTPInterface.replaceSelection(string);
        }
    }

    void insertTextAtCaret(String string) {
        EditorViewUtils.insertAtCaret(this.getEditorView().getSyntaxTextPane(), string);
    }

    void insertAndFormatTextAtCaret(String string) {
        EditorViewUtils.insertAndSmartIndentAtCaret(this.getEditorView().getSyntaxTextPane(), string);
    }

    void replaceText(String string, int n, int n2) {
        STPInterface sTPInterface = this.getEditorView().getSyntaxTextPane();
        try {
            sTPInterface.replace(n, n2, string);
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
    }

    void setStatusText(String string) {
        assert (this.fStatusBar != null) : "Attempt to set status text, but status bar reference is null.";
        this.fStatusBar.setText(string);
    }

    boolean isBeingDebugged(File file) {
        assert (this.fStackDisplay != null) : "isBeingDebugged should only be called from a file backed Editor";
        return EditorUtils.isMatlabAvailable() && this.getStackComboBox().isFunctionOnStack(new AbsoluteFile(file).getPath());
    }

    private void doDirtyStatusChanged() {
        this.updateShortAndLongTitle();
        this.getEditor().fireEditorEvent(EditorEvent.DIRTY_STATE_CHANGED);
    }

    private PropertyChangeListener createNameChangeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("shortName")) {
                    EditorViewClient.this.updateShortTitle();
                } else if (propertyChangeEvent.getPropertyName().equals("longName")) {
                    EditorViewClient.this.updateLongTitle();
                    EditorViewClient.this.getEditor().fireEditorEvent(EditorEvent.RENAMED);
                } else if ("uniqueKey".equals(propertyChangeEvent.getPropertyName())) {
                    EditorViewClient.this.fEditorView.updateEditorState();
                }
            }
        };
    }

    private DirtyStateChangeListener createDirtyStateChangeListener() {
        return new DirtyStateChangeListener(){

            public void dirtyStateChanged(boolean bl) {
                EditorViewClient.this.doDirtyStatusChanged();
            }
        };
    }

    private DTClientListener createDTClientListener() {
        return new DTClientAdapter(){

            public void clientOpened(DTClientEvent dTClientEvent) {
                EditorGroup.getInstance().doEditorViewClientOpened((EditorViewClient)((Object)dTClientEvent.getClient()));
            }

            public void clientActivated(DTClientEvent dTClientEvent) {
                EditorViewClient.this.setActive();
                EditorViewClient.this.getEditor().fireEditorEvent(EditorEvent.ACTIVATED);
            }

            public void clientDocked(DTClientEvent dTClientEvent) {
                EditorViewClient.this.setIsDockedInDesktop(true);
            }

            public void clientUndocked(DTClientEvent dTClientEvent) {
                EditorViewClient.this.setIsDockedInDesktop(false);
            }

            public void clientClosing(DTClientEvent dTClientEvent) {
                EditorViewClient.this.tryClosing(dTClientEvent);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void clientClosed(DTClientEvent dTClientEvent) {
                EditorGroup.getInstance().doEditorViewClientClosed(EditorViewClient.this);
                if (EditorViewClient.this.fPreventDisposalLock.tryLock()) {
                    try {
                        EditorViewClient.this.dispose();
                    }
                    finally {
                        EditorViewClient.this.unlock();
                    }
                } else {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            EditorViewClient.this.lock();
                            EditorViewClient.this.unlock();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    EditorViewClient.this.dispose();
                                }
                            });
                        }
                    }).start();
                }
            }
        };
    }

    private static String createDirtyTitle(String string) {
        return string + "*";
    }

    private static String createReadOnlyTitle(String string) {
        return string + ' ' + EditorUtils.lookup("label.ReadOnly");
    }

    boolean promptToExitDebugMode(File file) {
        boolean bl;
        if (!this.isBeingDebugged(file)) {
            throw new IllegalArgumentException("File should be on debug stack: " + file.getPath());
        }
        boolean bl2 = bl = DialogFactory.showSaveWhileDebug(EditorUiUtils.getParentFrame((Component)((Object)this)), file.getName()) == 0;
        if (bl) {
            EditorUtils.exitDebugMode();
        }
        return bl;
    }

    public void saveState(org.w3c.dom.Document document, Element element) {
        StorageLocation storageLocation = this.fEditor.getStorageLocation();
        if (storageLocation instanceof FileStorageLocation) {
            element.setAttribute(FILE_NAME, ((FileStorageLocation)storageLocation).getFile().getPath());
        }
    }

    public void restoreState(SimpleElement simpleElement) {
    }

    private static void doFindFiles() {
        EditorView editorView = EditorViewClient.getActiveEditorView();
        if (editorView != null) {
            editorView.invokeFindFiles();
        } else {
            FindFiles.invoke();
        }
    }

    private static void doFind() {
        EditorView editorView = EditorViewClient.getActiveEditorView();
        if (editorView != null) {
            editorView.invokeFind();
        }
    }

    private static void doFindAgain() {
        EditorView editorView = EditorViewClient.getActiveEditorView();
        if (editorView != null) {
            editorView.doFindAgain(false);
        }
    }

    private static void doFindAgainBack() {
        EditorView editorView = EditorViewClient.getActiveEditorView();
        if (editorView != null) {
            editorView.doFindAgain(true);
        }
    }

    static {
        ActionManager.setFindFilesObserver(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                EditorViewClient.doFindFiles();
            }
        });
        ActionManager.setFindObserver(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                EditorViewClient.doFind();
            }
        });
        ActionManager.setFindAgainObserver(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                EditorViewClient.doFindAgain();
            }
        });
        ActionManager.setFindAgainBackObserver(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                EditorViewClient.doFindAgainBack();
            }
        });
    }

    private static class DocumentTabActionProvider
    implements ActionProvider {
        private final String fFolderPath;

        private DocumentTabActionProvider(String string) {
            this.fFolderPath = FileUtils.truncatePathname((String)string, (int)22, (int)4);
        }

        public boolean isApplicable(FileSystemEntry fileSystemEntry) {
            return true;
        }

        public void configureActions(ActionRegistry actionRegistry) {
            actionRegistry.getAction(CoreActionID.CD_TO_LOCATION).setLabel(MessageFormat.format(EditorUtils.lookup("documentContextMenu.ChangeCurrentFolder"), this.fFolderPath));
            actionRegistry.getAction(CoreActionID.ADD_CONTAINING_FOLDER_TO_PATH).setLabel(MessageFormat.format(EditorUtils.lookup("documentContextMenu.AddFolderToPath"), this.fFolderPath));
            actionRegistry.getAction(CoreActionID.REMOVE_CONTAINING_FOLDER_FROM_PATH).setLabel(MessageFormat.format(EditorUtils.lookup("documentContextMenu.RemoveFolderFromPath"), this.fFolderPath));
        }
    }

    private class DebugStateListener
    extends MatlabDebugAdapter {
        private DebugStateListener() {
        }

        public void doDebugMode(boolean bl) {
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (EditorViewClient.this.getEditorView() != null) {
                        EditorViewClient.this.getEditor().fireEditorEvent(EditorEvent.DEBUG_MODE_CHANGED);
                        EditorViewClient.this.createToolstripTabs();
                    }
                }
            });
        }
    }
}

