/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.cmdwin;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.mde.cmdwin.CmdWinDocument;
import com.mathworks.mde.cmdwin.CmdWinEditorKit;
import com.mathworks.mde.cmdwin.CmdWinSyntaxWrapper;
import com.mathworks.mde.cmdwin.Prompt;
import com.mathworks.mde.cmdwin.XCaret;
import com.mathworks.mde.cmdwin.XCmdWndView;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mlservices.MLExecuteServices;
import com.mathworks.mlservices.MLExecutionEvent;
import com.mathworks.mlservices.MLExecutionListener;
import com.mathworks.mlservices.MatlabExecutionErrorHandler;
import com.mathworks.mvm.MVM;
import com.mathworks.mvm.context.MvmContext;
import com.mathworks.mvm.exec.FutureEvalResult;
import com.mathworks.mvm.exec.FutureResult;
import com.mathworks.mvm.exec.MatlabEvalRequest;
import com.mathworks.mvm.exec.MvmException;
import com.mathworks.mvm.exec.MvmExecutionException;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.services.Prefs;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import java.awt.AWTKeyStroke;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import org.jetbrains.annotations.NotNull;

public class CmdWinMLIF {
    private static final CmdWinDocument sCWDoc = CmdWinDocument.getInstance();
    private static final int POST_KEY = -13;
    private static final int NULL_OPTIONS = -1;
    public static final String ERROR_HANDLING_TIMEOUT_PREF = "ErrorHandlingTimeoutPref";
    public static final String INSERT_BEFORE_PROMPT_PREF = "InsertBeforePromptOn";
    private static MLExecutionEvent sChangeEvent = null;
    private static EventListenerList sListenerList = new EventListenerList();
    private static int sPreviousState = -1;
    private static MLExecutionEvent.InterpretedStatus sPreviousNonMATLABState = MLExecutionEvent.InterpretedStatus.UNSET;
    private static boolean sIsStudent = false;
    private static boolean sInitializing = true;
    private static volatile boolean sSendCtrlC = false;
    private static MatlabMCR sMatlab;
    private static KeyStrokeListener sKeyStrokeListener;
    private static BangKeyListener sBangKeyListener;
    private static int sPaused;
    private static volatile boolean sBangMode;
    private static int sSlashREndPos;
    private static XCmdWndView sCWView;
    private static GoToNullPrompt sGoToNullPrompt;
    private static final CmdWinMLIF sInterface;
    private static String fCurrentPromptText;

    private CmdWinMLIF() {
        sMatlab = new MatlabMCR();
        sIsStudent = Matlab.isStudentVersion();
        sGoToNullPrompt = new GoToNullPrompt();
    }

    static void addMLExecutionListener(MLExecutionListener mLExecutionListener) {
        sListenerList.add(MLExecutionListener.class, mLExecutionListener);
        if (sChangeEvent != null) {
            mLExecutionListener.stateChanged((ChangeEvent)sChangeEvent);
        }
    }

    private static void ctrlCProcessed() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    sCWDoc.insertString(sCWDoc.getPromptLineEndOffset(true), "\n", null);
                    sCWDoc.appendPrompt();
                }
                catch (BadLocationException badLocationException) {
                    Log.logException((Exception)badLocationException);
                }
            }
        });
    }

    static void sendMATLABAChar(final char c) {
        if (sBangMode) {
            sMatlab.eval(c);
        } else {
            Matlab.whenMatlabReady((Runnable)new Runnable(){

                @Override
                public void run() {
                    sMatlab.eval(c);
                }
            });
        }
    }

    private static synchronized void unpauseMATLAB(char c) {
        CmdWinMLIF.pauseInvariants();
        if (sPaused > 0) {
            CmdWinMLIF.setPaused(false, 0);
            CmdWinMLIF.sendMATLABAChar(c);
        }
    }

    static void removeMLExecutionListener(MLExecutionListener mLExecutionListener) {
        sListenerList.remove(MLExecutionListener.class, mLExecutionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void fireMLExecutionChanged(int n, MLExecutionEvent.InterpretedStatus interpretedStatus) {
        Class<MLExecuteServices> clazz = MLExecuteServices.class;
        synchronized (MLExecuteServices.class) {
            int n2 = Matlab.getExecutionStatus((int)n);
            if (n2 == 33) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (n2 == 34 || n2 == 35) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (sPreviousState == n && sPreviousNonMATLABState == interpretedStatus) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            sPreviousState = n;
            sPreviousNonMATLABState = interpretedStatus;
            Object[] objectArray = sListenerList.getListenerList();
            if (sChangeEvent == null) {
                sChangeEvent = MLExecutionEvent.getInstance((Object)sInterface, (int)n, (MLExecutionEvent.InterpretedStatus)interpretedStatus);
            } else {
                sChangeEvent.setStatus(n, interpretedStatus);
            }
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != MLExecutionListener.class) continue;
                ((MLExecutionListener)objectArray[i + 1]).stateChanged((ChangeEvent)sChangeEvent);
            }
            sCWDoc.shouldSyntaxHighlight(!sChangeEvent.isAwaitingInput() && !CmdWinMLIF.isInBangMode());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static void doEval(String string, int n) {
        if (!sBangMode) {
            CmdWinMLIF.fireMLExecutionChanged(0, MLExecutionEvent.InterpretedStatus.START_EVAL);
            if (n == -1) {
                sMatlab.evalStreamOutput(string, null);
            } else {
                sMatlab.evalStreamOutput(string, null, n);
            }
        } else if (sBangMode && PlatformInfo.isWindows()) {
            for (int i = 0; i < string.length(); ++i) {
                CmdWinMLIF.sendMATLABAChar(string.charAt(i));
            }
        }
    }

    static void doEval(String string) {
        CmdWinMLIF.doEval(string, -1);
    }

    static void doConsoleEval(String string, final int n) {
        if (sCWDoc.getCurrentPrompt() == Prompt.NULL_PROMPT || sCWDoc.getCurrentPrompt() == Prompt.INPUT_PROMPT) {
            if (n == -1) {
                sMatlab.evalConsoleOutput(string);
            } else {
                sMatlab.evalConsoleOutput(string, null, n);
            }
        } else {
            final String string2 = string;
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    sCWDoc.setPrompt(Prompt.NULL_PROMPT);
                    try {
                        sCWDoc.replacePrompt();
                    }
                    catch (BadLocationException badLocationException) {
                        Log.logException((Exception)badLocationException);
                    }
                    CmdWinMLIF.doEval(string2, n);
                }
            });
        }
    }

    static void doConsoleEval(String string) {
        CmdWinMLIF.doConsoleEval(string, -1);
    }

    static void doExecuteCommand(String string) {
        block7: {
            if (SwingUtilities.isEventDispatchThread()) {
                assert (CmdWinEditorKit.getInstance() != null) : "doExecuteCommand: The command window editor kit is not available";
                if (string != null) {
                    try {
                        if (sCWDoc.getCurrentPrompt() == Prompt.INPUT_PROMPT) {
                            CmdWinEditorKit.getInstance();
                            CmdWinEditorKit.insertCommand(string);
                            sMatlab.evalConsoleOutput(string);
                            break block7;
                        }
                        CmdWinEditorKit.getInstance();
                        CmdWinEditorKit.insertCommandAndSend(string);
                    }
                    catch (BadLocationException badLocationException) {
                        Log.logException((Exception)badLocationException);
                    }
                }
            } else {
                final String string2 = string;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CmdWinMLIF.doExecuteCommand(string2);
                    }
                });
            }
        }
    }

    static void doExecuteCommand(final @NotNull String string, final @NotNull MatlabExecutionErrorHandler matlabExecutionErrorHandler) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                assert (CmdWinEditorKit.getInstance() != null) : "doExecuteCommand: The command window editor kit is not available";
                try {
                    if (Prefs.getBooleanPref((String)CmdWinMLIF.INSERT_BEFORE_PROMPT_PREF, (boolean)true)) {
                        CmdWinEditorKit.getInstance();
                        CmdWinEditorKit.insertCommand(string);
                    }
                    MVM mVM = MvmContext.get();
                    MatlabEvalRequest matlabEvalRequest = new MatlabEvalRequest(string);
                    matlabEvalRequest.setExternal(true);
                    matlabEvalRequest.setSuppressDebugControlOutput(true);
                    FutureEvalResult futureEvalResult = mVM.getExecutor().submit(matlabEvalRequest);
                    CmdWinMLIF.fireMLExecutionChanged(0, MLExecutionEvent.InterpretedStatus.START_EVAL);
                    new Thread(new Runnable((FutureResult)futureEvalResult){
                        final /* synthetic */ FutureResult val$result;
                        {
                            this.val$result = futureResult;
                        }

                        @Override
                        public void run() {
                            try {
                                this.val$result.get((long)Prefs.getIntegerPref((String)CmdWinMLIF.ERROR_HANDLING_TIMEOUT_PREF, (int)2), TimeUnit.SECONDS);
                            }
                            catch (MvmExecutionException mvmExecutionException) {
                                CmdWinMLIF.handleMvmException(mvmExecutionException.getMvmCause(), matlabExecutionErrorHandler);
                            }
                            catch (TimeoutException timeoutException) {
                            }
                            catch (InterruptedException interruptedException) {
                                Log.logException((Exception)interruptedException);
                            }
                            catch (RuntimeException runtimeException) {
                                Log.logException((Exception)runtimeException);
                            }
                        }
                    }, "Command Window doExecuteCommand").start();
                }
                catch (BadLocationException badLocationException) {
                    Log.logException((Exception)badLocationException);
                }
            }
        });
    }

    public static void handleMvmException(MvmException mvmException, MatlabExecutionErrorHandler matlabExecutionErrorHandler) {
        matlabExecutionErrorHandler.handleError(mvmException);
    }

    private static synchronized void forcePausedOff() {
        if (sPaused > 0) {
            sPaused = 1;
            CmdWinMLIF.setPaused(false, 0);
        }
        CmdWinMLIF.pauseInvariants();
    }

    private static void pauseInvariants() {
        assert (sPaused >= 0);
    }

    private static void setPassThrough(boolean bl) {
        if (bl && !sBangMode) {
            if (PlatformInfo.isUnix()) {
                if (sBangKeyListener == null) {
                    sBangKeyListener = new BangKeyListener();
                }
                sCWView.addKeyListener(sBangKeyListener);
            }
            sBangMode = true;
            CmdWinMLIF.fireMLExecutionChanged(0, MLExecutionEvent.InterpretedStatus.BANG);
        } else if (!bl) {
            if (PlatformInfo.isUnix()) {
                sCWView.removeKeyListener(sBangKeyListener);
            }
            sBangMode = false;
            CmdWinMLIF.fireMLExecutionChanged(0, MLExecutionEvent.InterpretedStatus.BANG_FINISH);
        }
    }

    private static void addCommandText(String string) {
        if (string.length() > 0) {
            if (EventQueue.isDispatchThread()) {
                CmdWinMLIF.addTextFromC(string);
            } else {
                EventQueue.invokeLater(new AddCommandTextOnEventThread(string));
            }
        }
    }

    public static void processKeyFromC(final int n, final int n2, final char c) {
        if ((n & 2) != 0 && n2 != 67 || (n & 8) != 0 || PlatformInfo.isMacintosh() && (n & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0 && n2 != 46) {
            return;
        }
        final long l = System.currentTimeMillis();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!CmdWinMLIF.isPaused()) {
                    MLDesktop.getInstance().showCommandWindow();
                    KeyEvent keyEvent = new KeyEvent(sCWView, 401, l, n, n2, c);
                    sCWView.processKeyEvent(keyEvent);
                    KeyEvent keyEvent2 = new KeyEvent(sCWView, 400, l, n, 0, c == '\uffff' ? (char)'\u0000' : c);
                    KeyEvent keyEvent3 = new KeyEvent(sCWView, 402, l, n, n2, c);
                    if (n2 != 38 && n2 != 40) {
                        sCWView.processKeyEvent(keyEvent2);
                    }
                    sCWView.processKeyEvent(keyEvent3);
                } else {
                    CmdWinMLIF.unpauseMATLAB(c);
                }
            }
        });
    }

    public static void processKeyFromC(KeyEvent keyEvent) {
        CmdWinMLIF.processKeyFromC(keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar());
    }

    private static void addTextFromC(String string) {
        try {
            if (!sInitializing) {
                sSlashREndPos = sCWDoc.getAfterThePrompt();
            }
            if (string.length() != 1 || !string.equals("\n")) {
                sCWDoc.insertString(((XCaret)sCWView.getCaret()).getInsertDot(), string, null);
                sSlashREndPos = sCWDoc.getAfterThePrompt() + string.length();
            }
            if (string.endsWith("\n")) {
                CmdWinEditorKit.sendCurrentCommand(sSlashREndPos);
            }
            CmdWinMLIF.unpauseMATLAB(string.charAt(0));
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
    }

    static boolean isInBangMode() {
        return sBangMode;
    }

    private static synchronized boolean isPaused() {
        return sPaused > 0;
    }

    static boolean isStudentVersion() {
        return sIsStudent;
    }

    private static synchronized void setPaused(boolean bl, int n) {
        if (bl) {
            if (++sPaused == 1) {
                if (sKeyStrokeListener == null) {
                    sKeyStrokeListener = new KeyStrokeListener();
                }
                sCWView.addKeyListener(sKeyStrokeListener);
                Prompt prompt = CmdWinMLIF.getNextPrompt(n);
                sCWDoc.setPrompt(prompt);
                CmdWinMLIF.fireMLExecutionChanged(n << 8, MLExecutionEvent.InterpretedStatus.UNSET);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            sCWDoc.replacePrompt();
                        }
                        catch (BadLocationException badLocationException) {
                            Log.logException((Exception)badLocationException);
                        }
                    }
                });
            } else {
                boolean bl2 = false;
                if (!$assertionsDisabled) {
                    bl2 = true;
                    if (!true) {
                        throw new AssertionError();
                    }
                }
                if (bl2) {
                    KeyListener[] keyListenerArray;
                    boolean bl3 = false;
                    for (KeyListener keyListener : keyListenerArray = sCWView.getKeyListeners()) {
                        if (keyListener != sKeyStrokeListener) continue;
                        bl3 = true;
                        break;
                    }
                    assert (bl3);
                }
            }
        } else if (--sPaused == 0) {
            sCWView.removeKeyListener(sKeyStrokeListener);
            EventQueue.invokeLater(sGoToNullPrompt);
        }
        CmdWinMLIF.pauseInvariants();
    }

    static void sendInterruptMsg() {
        if (sSendCtrlC) {
            CmdWinMLIF.forcePausedOff();
            if (CmdWinMLIF.isInBangMode()) {
                char c = '\u0003';
                CmdWinMLIF.sendMATLABAChar(c);
            } else {
                sMatlab.interrupt();
            }
        }
    }

    static void setCWSize(int n, int n2) {
        sMatlab.setWindowSize(n, n2);
    }

    public static CmdWinMLIF getInstance() {
        sCWView = XCmdWndView.getInstance();
        return sInterface;
    }

    static MatlabMCR getMatlab() {
        return sMatlab;
    }

    static boolean isWaitingForContinuation() {
        return sChangeEvent != null && sChangeEvent.getInterpretedStatus() == MLExecutionEvent.InterpretedStatus.COMPLETING_BLOCK;
    }

    private static Prompt getNextPrompt(int n) {
        Prompt prompt;
        if (n == Matlab.NO_PROMPT) {
            prompt = Prompt.NULL_PROMPT;
        } else if (n == Matlab.INCOMPLETE_BLOCK_PROMPT) {
            prompt = Prompt.INCOMPLETE_BLOCK_PROMPT;
        } else if (n == Matlab.PAUSE_PROMPT) {
            prompt = Prompt.PAUSE_PROMPT;
        } else if (n == Matlab.MORE_PROMPT) {
            prompt = Prompt.MORE_PROMPT;
        } else if (n == Matlab.DEBUG_PROMPT) {
            prompt = Prompt.KEYBOARD_PROMPT;
        } else if (n == Matlab.KEYBOARD_PROMPT) {
            prompt = Prompt.KEYBOARD_PROMPT;
        } else if (n == Matlab.INPUT_PROMPT) {
            prompt = Prompt.INPUT_PROMPT;
        } else if (n == Matlab.SIMEVENTS_DEBUG_PROMPT) {
            prompt = Prompt.SIMEVENTS_DEBUG_PROMPT;
        } else if (n == Matlab.SF_EML_DEBUG_PROMPT) {
            prompt = Prompt.SF_EML_DEBUG_PROMPT;
        } else if (n == Matlab.EMERGENCY_EXIT_PROMPT || n == Matlab.BASE_PROMPT || n == Matlab.BANG_PROMPT || n == Matlab.SIMULINK_DEBUG_PROMPT) {
            if (n == Matlab.EMERGENCY_EXIT_PROMPT) {
                Prompt.setEmergency();
            }
            prompt = Prompt.getBasePrompt(sIsStudent);
        } else {
            prompt = Prompt.getBasePrompt(sIsStudent);
        }
        return prompt;
    }

    private static void inputRequested(final int n) {
        sInitializing = false;
        sSendCtrlC = true;
        CmdWinMLIF.fireMLExecutionChanged(n, MLExecutionEvent.InterpretedStatus.UNSET);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Matlab.getCodeBlockStatus((int)n) == 1) {
                    CmdWinSyntaxWrapper.saveState();
                } else {
                    CmdWinSyntaxWrapper.cleanState();
                }
                Prompt prompt = CmdWinMLIF.getNextPrompt(Matlab.getInputRequester((int)n));
                if (prompt != sCWDoc.getCurrentPrompt() || prompt == null || !prompt.toString().equals(fCurrentPromptText)) {
                    sCWDoc.setPrompt(prompt);
                    fCurrentPromptText = sCWDoc.getCurrentPrompt().toString();
                    try {
                        sCWDoc.replacePrompt();
                    }
                    catch (BadLocationException badLocationException) {
                        Log.logException((Exception)badLocationException);
                    }
                }
            }
        });
    }

    private static void enableCtrlCRequests() {
        sSendCtrlC = true;
    }

    public static boolean isMatlabAbleToAcceptCtrlC() {
        return sSendCtrlC;
    }

    private static void keyStrokeRequested(final int n) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CmdWinMLIF.setPaused(true, n);
            }
        });
    }

    private static void profilerActive(boolean bl) {
        MLExecutionEvent.InterpretedStatus interpretedStatus = bl ? MLExecutionEvent.InterpretedStatus.PROFILER_ON : MLExecutionEvent.InterpretedStatus.PROFILER_OFF;
        CmdWinMLIF.fireMLExecutionChanged(0, interpretedStatus);
    }

    public static void clc() {
        sCWDoc.closeText();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                sCWDoc.clear();
            }
        });
    }

    private static void home() {
        sCWDoc.closeText();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                sCWView.home();
            }
        });
    }

    void bufferBeforePrompt(char[] cArray, int n, int n2, boolean bl) {
        sCWDoc.flushBuffer(cArray, n, n2, bl);
    }

    static {
        sKeyStrokeListener = null;
        sBangKeyListener = null;
        sPaused = 0;
        sBangMode = false;
        sSlashREndPos = 0;
        sCWView = null;
        sGoToNullPrompt = null;
        sInterface = new CmdWinMLIF();
        fCurrentPromptText = null;
    }

    private static class BangKeyListener
    extends KeyAdapter {
        boolean iKeyPressed = false;
        int iKey = 0;

        private BangKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            this.iKeyPressed = true;
            this.iKey = keyEvent.getKeyCode();
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (this.iKeyPressed) {
                this.iKeyPressed = false;
                char c = keyEvent.getKeyChar();
                AWTKeyStroke aWTKeyStroke = AWTKeyStroke.getAWTKeyStroke(46, 4);
                AWTKeyStroke aWTKeyStroke2 = AWTKeyStroke.getAWTKeyStroke((int)keyEvent.getKeyChar(), keyEvent.getModifiers());
                boolean bl = aWTKeyStroke.equals(aWTKeyStroke2);
                if (!(keyEvent.isControlDown() && this.iKey == 86 || bl)) {
                    CmdWinMLIF.sendMATLABAChar(c);
                    keyEvent.consume();
                }
            }
        }
    }

    private static class KeyStrokeListener
    extends KeyAdapter {
        private KeyStrokeListener() {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\u0003') {
                return;
            }
            CmdWinMLIF.unpauseMATLAB(keyEvent.getKeyChar());
            keyEvent.consume();
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n;
            block6: {
                block4: {
                    block5: {
                        n = keyEvent.getKeyCode();
                        if (n == 38 || n == 40 || n == 37 || n == 39 || n == 16) break block4;
                        if (n != 10) break block5;
                        if (keyEvent.getKeyLocation() == 4) break block4;
                    }
                    if (n != 27 || !PlatformInfo.isMacintosh()) break block6;
                }
                CmdWinMLIF.unpauseMATLAB(keyEvent.getKeyChar());
                keyEvent.consume();
            }
            if (n == 8 || n == 127 || n == 10) {
                keyEvent.consume();
            }
        }
    }

    private static class GoToNullPrompt
    implements Runnable {
        private GoToNullPrompt() {
        }

        @Override
        public void run() {
            sCWDoc.setPrompt(Prompt.NULL_PROMPT);
            try {
                sCWDoc.replacePrompt();
            }
            catch (BadLocationException badLocationException) {
                Log.logException((Exception)badLocationException);
            }
        }
    }

    private static class AddCommandTextOnEventThread
    implements Runnable {
        private String fCommandString;

        public AddCommandTextOnEventThread(String string) {
            this.fCommandString = string;
        }

        @Override
        public void run() {
            CmdWinMLIF.addTextFromC(this.fCommandString);
        }
    }
}

